/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "freedos.h"

/*****************************************************************************
 * This function prints out all lines containing a substring.  There are some
 * conditions that may be passed to the function.
 *
 * Author: James Hall
 */

void 
ffind (char sz[], FILE * p, int iNot, int iCount, int iNum, int iIgnore)
{
  int i, iLen;
  long lLine = 0, lTotal = 0;
  char *c, szTemp[MAX_STR], szString[MAX_STR];

  /* Convert to upper if needed */

  if (iIgnore)
    {
      iLen = strlen (sz);
      for (i = 0; i < iLen; i++)
	sz[i] = toupper (sz[i]);
    }

  /* Scan the file until EOF */

  while (fgets (szTemp, MAX_STR, p) != NULL)
    {

      /* Remove the trailing newline */

      iLen = strlen (szTemp);
      if (szTemp[iLen - 1] == '\n')
	szTemp[iLen - 1] = '\0';

      /* Increment number of lines */

      lLine++;
      strcpy (szString, szTemp);

      /* Convert to upper if needed */

      if (iIgnore)
	for (i = 0; i < iLen; i++)
	  szTemp[i] = toupper (szTemp[i]);

      /* Locate the substring */
      /* strstr() returns a pointer to the first occurrence in the
       string of the substring */

      if ((((c = strstr (szTemp, sz)) != NULL) &&
	   (!iNot)) || ((c == NULL) && (iNot)))
	{

	  if (!iCount)
	    {
	      if (iNum)
		printf ("%ld:", lLine);

	      /* Print the line of text */

	      puts (szString);
	    }

	  else
	    lTotal++;
	}
    }

  if (iCount)
    printf ("Number of lines: %ld\n", lTotal);

  return;
}
