/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

/***********************************************************************
 * This function displays the date and allows the user to change it.
 *
 * Author: James Hall
 */

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include "getopt.h"
#include "freedos.h"


/* Structure from Quick-C that sets the DOS date */

struct dosdate_t ddate;


void usage (void);


main (int argc, char **argv)
{
  int i;
  unsigned uDay, uMonth, uYear;
  char *prgszDays[] =
  {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
  char szBuf[20];

  /* Scan the command line */

  while ((i = getopt (argc, argv, "?")) != EOF)
    {
      switch (i)
	{
	default:
	  usage ();
	  break;
	}
    }

  /* Check if there are enough args left */

  if ((argc - optind) != 0)
    strcpy (szBuf, argv[1]);

  else
    {
      /* Get the current date */
      /* _dos_getdate() from Quick-C returns the date as a struct */

      _dos_getdate (&ddate);

      printf ("Current date is: %u/%02u/%02u %s\n",
	      ddate.month, ddate.day, ddate.year - 1900,
	      prgszDays[ddate.dayofweek]);

      /* Get the new date */

      printf ("Enter new date: ");
      gets (szBuf);
    }

  if (strlen (szBuf))
    {
      sscanf (szBuf, "%u/%u/%u", &uMonth, &uDay, &uYear);

      /* Parse the new date */

      if ((uYear - 80) <= 20)
	ddate.year = uYear + 1900;

      else if ((uYear >= 1980) && (uYear <= 2099))
	ddate.year = uYear;

      if ((uMonth + 1) <= 13)
	ddate.month = (unsigned char) uMonth;

      if ((uDay + 1) <= 32)
	ddate.day = (unsigned char) uDay;

      /* Set the date */
      /* _dos_setdate() from Quick-C sets the date */

      _dos_setdate (&ddate);
      _dos_getdate (&ddate);

      printf ("New date: %u/%02u/%02u %s\n",
	      ddate.month, ddate.day, ddate.year - 1900,
	      prgszDays[ddate.dayofweek]);
    }
  exit (0);
}

void 
usage (void)
{
  printp ("DATE", "Displays the date and allows you to change it");
  printu ("DATE", "[mm/dd/yy]");
  exit (1);
}
