;==============================================================================
;==
;==     Project                 : XMS tester
;==     Module name             : 
;==     Author(s)               : Mark E. Huss
;==     Purpose                 : Very simple XMS tester
;==
;==     Created                 : 
;==
;==                              Revision history
;==                              ================
;==
;==============================================================================
	page 65,132

@Print	MACRO	s1
	IFNB	<s1>
	  mov	dx,offset s1
	ENDIF
	mov	ah,9
	int	21h
	ENDM

@Putc	MACRO	c1,c2,c3,c4
	mov	ah,2
	IRP	char,<c1,c2,c3,c4>
	  IFB	<char>
	    EXITM
	  ENDIF
	  mov	dl,char
	  int	21h
	ENDM
	ENDM

CSEG	segment
	assume cs:CSEG, ds:CSEG, es:CSEG

	org	80h
pcount	db	?
params	label	byte

	org	100h
start:	jmp	sstart

	even
hm_vec	label	dword
hmv	dw	?,?

handle1	dw	?
handle2	dw	?

xmem_move	label	word
length_lo	dw	?
length_hi	dw	?
source_h	dw	?
source_lo	dw	?
source_hi	dw	?
dest_h		dw	?
dest_lo		dw	?
dest_hi		dw	?

hello	db	13,10,"XMS Test Program",13,10
crlf	db	13,10,"$"

aversion db	"Version: $"
req_hm	db	"Request HiMem: $"
rel_hm	db	"Release HiMem: $"
q_a20	db	"Query A20: $"
en_a20	db	"Enable A20: $"
dis_a20	db	"Disable A20: $"
query	db	"Query (largest/total): $"
alloc	db	"Alloc: $"
locke	db	"Lock: $"
unlock	db	"UnLock: $"
handle	db	"HandleInfo: $"
free	db	"Free: $"
moveto	db	"MoveTo: $"
movefr	db	"MoveFrom:"
spc	db	" $"
ok      db      "OK",13,10,"$"

err_	db	"XMS Error: $"
no_hm	db	"XMS not found",13,10,"$"
err_fr	db	"'From' data error",13,10,"$"

;------------------------------------------------------------------------------
; htoa4, htoa2, htoa1 
;
; print number in AX as ascii hex
;
; Arguments:
;	AX = number to print
; Returns:
;	nothing
; Alters:
;	AX, DL
; Calls:
;	nothing
;------------------------------------------------------------------------------
htoa4	proc	near
	push	ax
	xchg	al,ah
	call	htoa2
	pop	ax
htoa2:	push	ax
	REPT	4
	shr	al,1
	ENDM
	call	htoa1
	pop	ax
htoa1:	and	al,0Fh
	add	al,90h
	daa
	adc	al,40h
	daa
	mov	dl,al
	mov	ah,2
	int	21h
	ret
htoa4	endp

;------------------------------------------------------------------------------
fill_buffer	proc	near
	push	cs
	pop	es
	mov	cx,1000h
	mov	di,offset buffer
	cld
	rep	stosw
	ret
fill_buffer	endp
;------------------------------------------------------------------------------
check_buffer	proc	near
	push	cs
	pop	es
	mov	cx,1000h
	mov	di,offset buffer
	cld
	rep	scasw
	ret
check_buffer	endp
;------------------------------------------------------------------------------

sstart:
	@Print	hello
	mov	ax,4300h
	int	2Fh
	cmp	al,80h
	je	xms_found
	mov	dx,offset no_hm
	jmp	error_exit
xms_found:
	mov	ax,4310h
	int	2Fh
	mov	hmv,bx
	mov	hmv[2],es
	push	cs
	pop	es

	@Print	aversion
	mov	ah,0
	call	hm_vec
	call	htoa4
	@Putc	' '
	mov	ax,bx
	call	htoa4
	@Print	crlf

	@Print	query
	mov	ah,8
	sub	bx,bx
	call	hm_vec
	test	bl,bl
	jz	query_ok
	jmp	hm_error

query_ok:
	push	dx
	call	htoa4
	@Putc	' '
	pop	ax
	call	htoa4
	@Print	crlf

	@Print	req_hm
	mov	ah,1
	mov	dx,0F000h
	call	hm_vec
	test	ax,ax
	jnz	req_hm_ok
	jmp	hm_error
req_hm_ok:
	@Print	ok

	@Print	en_a20
	mov	ah,3
	call	hm_vec
	test	ax,ax
	jnz	en_a20_ok
	jmp	hm_error
en_a20_ok:

	@Print	q_a20
	mov	ah,7
	call	hm_vec
	call	htoa4
	@Print	crlf

	@Print	dis_a20
	mov	ah,4
	call	hm_vec
	test	ax,ax
	jnz	dis_a20_ok
	jmp	hm_error
dis_a20_ok:

	@Print	q_a20
	mov	ah,7
	call	hm_vec
	call	htoa4
	@Print	crlf

	@Print	rel_hm
	mov	ah,2
	call	hm_vec
	test	ax,ax
	jnz	rel_hm_ok
	jmp	hm_error
rel_hm_ok:
	@Print	ok

	@Print	alloc
	mov	dx,64
	mov	ah,9
	call	hm_vec
	test	ax,ax
	jnz	alloc1_ok
	jmp	hm_error
alloc1_ok:
	mov	handle1,dx
	mov	ax,dx
	call	htoa4
	@Print	crlf
	
	@Print	handle
	mov	dx,handle1
	mov	ah,0Eh
	call	hm_vec
	test	ax,ax
	jnz	hand1_ok
	jmp	hm_error
hand1_ok:
	mov	ax,dx
	call	htoa4
	@Print	spc
	mov	al,bh
	call	htoa2
	@Print	spc
	mov	al,bl
	call	htoa2
	@Print	crlf

	@Print	locke
	mov	ah,0Ch
	mov	dx,handle1
	call	hm_vec
	test	ax,ax
	jnz	lock_ok
	jmp	hm_error
lock_ok:
	mov	ax,dx
	call	htoa4
	mov	ax,bx
	call	htoa4
	@Print	crlf

	@Print	unlock
	mov	ah,0Dh
	mov	dx,handle1
	call	hm_vec
	test	ax,ax
	jnz	unlock_ok
	jmp	hm_error
unlock_ok:
	@Print	ok

	@Print	alloc
	mov	dx,64
	mov	ah,9
	call	hm_vec
	test	ax,ax
	jnz	alloc2_ok
	jmp	hm_error
alloc2_ok:
	mov	handle2,dx
	mov	ax,dx
	call	htoa4
	@Print	crlf

	@Print	handle
	mov	dx,handle2
	mov	ah,0Eh
	call	hm_vec
	test	ax,ax
	jnz	hand2_ok
	jmp	hm_error
hand2_ok:
	mov	ax,dx
	call	htoa4
	@Print	spc
	mov	al,bh
	call	htoa2
	@Print	spc
	mov	al,bl
	call	htoa2
	@Print	crlf

	@Print	locke
	mov	ah,0Ch
	mov	dx,handle2
	call	hm_vec
	test	ax,ax
	jnz	lock2_ok
	jmp	hm_error
lock2_ok:
	mov	ax,dx
	call	htoa4
	mov	ax,bx
	call	htoa4
	@Print	crlf

	@Print	unlock
	mov	ah,0Dh
	mov	dx,handle2
	call	hm_vec
	test	ax,ax
	jnz	unlock2_ok
	jmp	hm_error
unlock2_ok:
	@Print	ok

	@Print	moveto
	mov	ax,101h
	call	fill_buffer
	mov	length_lo,2000h
	mov	source_h,0
	mov	source_lo,offset buffer
	mov	source_hi,ds
	mov	ax,handle1
	mov	dest_h,ax
	mov	dest_lo,0		
	mov	dest_hi,0
	mov	ah,0Bh
	mov	si,offset xmem_move
	call	hm_vec
	test	ax,ax
	jnz	move1_ok
	jmp	hm_error
move1_ok:
	@Print	ok

	@Print	moveto
	mov	ax,202h
	call	fill_buffer
	mov	length_lo,2000h
	mov	source_h,0
	mov	source_lo,offset buffer
	mov	source_hi,ds
	mov	ax,handle2
	mov	dest_h,ax
	mov	dest_lo,0		
	mov	dest_hi,0
	mov	ah,0Bh
	mov	si,offset xmem_move
	call	hm_vec
	test	ax,ax
	jnz	move2_ok
	jmp	hm_error
move2_ok:
	@Print	ok
	
	sub	ax,ax
	call	fill_buffer

	@Print	movefr
	mov	length_lo,2000h
	mov	ax,handle1
	mov	source_h,ax
	mov	source_lo,0
	mov	source_hi,0
	mov	dest_h,0
	mov	dest_lo,offset buffer	
	mov	dest_hi,ds
	mov	ah,0Bh
	mov	si,offset xmem_move
	call	hm_vec
	test	ax,ax
	jnz	move3_ok
	jmp	hm_error
move3_ok:
	@Print	ok
	mov	ax,101h
	call	check_buffer
	jz	buff1_ok
	mov	dx,offset err_fr
	jmp	error_exit
buff1_ok:

	@Print	movefr
	mov	length_lo,2000h
	mov	ax,handle2
	mov	source_h,ax
	mov	source_lo,0
	mov	source_hi,0
	mov	dest_h,0
	mov	dest_lo,offset buffer	
	mov	dest_hi,ds
	mov	ah,0Bh
	mov	si,offset xmem_move
	call	hm_vec
	test	ax,ax
	jnz	move4_ok
	jmp	hm_error
move4_ok:
	@Print	ok
	mov	ax,202h
	call	check_buffer
	jz	buff2_ok
	mov	dx,offset err_fr
	jmp	error_exit
buff2_ok:

	@Print	free
	mov	dx,handle2
	mov	ah,0Ah
	call	hm_vec
	test	ax,ax
	jnz	free2_ok
	jmp	hm_error
free2_ok:
	@Print	ok

	@Print	free
	mov	dx,handle1
	mov	ah,0Ah
	call	hm_vec
	test	ax,ax
	jnz	free1_ok
	jmp	hm_error
free1_ok:
	@Print	ok

exit:
	mov	ax,4C00h
	int	21h

hm_error:
	@Print	err_
	mov	al,bl
	call	htoa2
	mov	dx,offset crlf
error_exit:
	@Print
	mov	ax,4C01h
	int	21h

	even
buffer:

CSEG	ends
	end	start
