/* ENVIRON.H
 * environment handling
 * Tim Norman
 * 1-14-95
*/

/* delete the variable at the position var, which is pointing into */
/* environment */
void delvarpos (char *var)
{
  int count, gap, index;
  char *place;

  if (!var)
     return;

  for (count = 0; count < num_environment_variables; count++)
     if (env_vars[count] == var)
     {
	gap = strlen (env_vars[count]) + 1;

	for (place = env_vars[count];
	     place != env_vars[num_environment_variables] - gap;
	     place++)
	  *place = *(place + gap);

	for (index = count; index != num_environment_variables; index++)
	  env_vars[index] = env_vars[index + 1] - gap;

	num_environment_variables--;

        break;
     }
}

int delvar (char *var)
{
  char *findenv_pos (char *);

  delvarpos (findenv_pos (var));

  return 0;
}

/* returns pointer to the WHOLE environment varible asked for */
char *findenv_pos (char *name)
{
  int place = 0, count;

  for (count = 0; count < num_environment_variables; count++)
    if (strncmp (name, env_vars[count], strlen (name)) == 0 &&
	env_vars[count][strlen (name)] == '=')
      return env_vars[count];

  return NULL;
}

/* returns pointer to only the data part of an environment variable */
char *findenv (char *name)
{
  int place = 0, count;

  for (count = 0; count < num_environment_variables; count++)
    if (strncmp (name, env_vars[count], strlen (name)) == 0 &&
	env_vars[count][strlen (name)] == '=')
      return env_vars[count] + strlen (name) + 1;

  return NULL;
}

int addenv (char *var)
{
  char *place, *varname;

  if (!(place = strchr (var, '=')))
    return 1;

  if (*(place + 1) == 0)
    {
      *(place) = 0;
      return delvar (var);
    }

  /* check if the variable already exists and delete it if it does */
  *(place) = 0;
  if ((varname = findenv_pos (var)) != NULL)
     delvarpos (varname);
  *(place) = '=';

  /* add variable to the end of the list */
  if ((environment + ENV_SIZE) - env_vars[num_environment_variables]
      < strlen (var) + 1)
    return 2;

  strcpy (env_vars[num_environment_variables], var);
  num_environment_variables++;
  env_vars[num_environment_variables] = env_vars[num_environment_variables - 1] +
				   strlen (var) + 1;

  return 0;
}

void show_environment ()
{
   unsigned char count;

   for (count = 0; count < num_environment_variables; count++)
      puts (env_vars[count]);
}
