/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

/************************************************************************
 * This program locates a string in a text file and prints those lines
 * that contain the string.  Multiple files are clearly separated.
 *
 * Author: James Hall
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "getopt.h"
#include "freedos.h"


void usage (void);


main (int argc, char **argv)
{

  int c, i, iNot = FALSE, iCount = FALSE, iNum = FALSE, iIgnore = FALSE;
  char szBuf[MAX_STR];
  FILE *p;

  /* Scan the command line */

  while ((c = getopt (argc, argv, "cCiInNvV?")) != EOF)
    {
      switch (c)
	{
	case 'c':
	case 'C':		/* Count */
	  iCount = TRUE;
	  break;
	case 'i':
	case 'I':		/* Ignore */
	  iIgnore = TRUE;
	  break;
	case 'n':
	case 'N':		/* Number */
	  iNum = TRUE;
	  break;
	case 'v':
	case 'V':		/* Not with */
	  iNot = TRUE;
	  break;
	default:
	  usage ();
	  break;
	}
    }

  /* Get the string */

  if ((c = optind) >= argc)
    usage ();

  else
    strcpy (szBuf, argv[c++]);

  /* Read the files */

  if ((argc - c) == 0)
    ffind (szBuf, stdin, iNot, iCount, iNum, iIgnore);

  for (i = c; i < argc; i++)
    {
      if ((p = fopen (argv[i], "r")) != NULL)
	{
	  printf ("=================== %s\n", argv[i]);
	  ffind (szBuf, p, iNot, iCount, iNum, iIgnore);
	  fclose (p);
	}

      else
	fprintf (stderr, "Could not open %s\n", argv[i]);
    }

  exit (0);
}


void 
usage (void)
{
  printp ("FIND", "Prints all lines of a file that contain a string.");
  printu ("FIND", "[/C] [/I] [/N] [/V] \"string\" [file..]");
  printo ("/C", "Count the number of occurrences of the string");
  printo ("/I", "Ignore case");
  printo ("/N", "Number the displayed lines, starting with 1");
  printo ("/V", "Just print the lines that don\'t contain the string");
  exit (1);
}
