#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "index.h"

#define AFSep		"                             Directory"

static void		Clip(char *str);
static void		LoadIDX(FILE *f);
static void		MkAFIDX();
static void		MkIDX(FILE *f);
static ulong	ReadNum(char *s);
static void		WriteIDX();

static ulong	bcnt[256];
static char		descr[256][66];
static ulong	fcnt[256];
static ulong	offset[256];
static uint		topcnt;

ulong	BytCnt(uint t)
{
	if (t >= topcnt)
		return 0;
	else
		return bcnt[t];
}

void	Clip(char *str)
{
	char	*s;

	s = strchr(str, 0);

	while (s > str && isspace(*(s - 1)))
		*--s = 0;
}

char	*Descr(uint t)
{
	if (t >= topcnt)
		return 0;
	else
		return descr[t];
}

ulong	FilCnt(uint t)
{
	if (t >= topcnt)
		return 0;
	else
		return fcnt[t];
}

void	LoadIDX(FILE *f)
{
	fread(&topcnt, 1, sizeof(topcnt), f);
	fread(offset, topcnt, sizeof(ulong), f);
	fread(descr, topcnt, sizeof(descr[0]), f);
	fread(fcnt, topcnt, sizeof(ulong), f);
	fread(bcnt, topcnt, sizeof(ulong), f);
}

void	MkAFIDX()
{
	FILE	*f;

	f = fopen("allfile.dir", "rb");

	if (!f)
		{
		fprintf(stderr, "Unable to open ALLFILE.DIR\n");
		exit(1);
		}

	MkIDX(f);

	fclose(f);

	WriteIDX();
}

void	MkIDX(FILE *f)
{
	char	line[100];

	while (!feof(f))
		{
		uint	t;

		while (!feof(f))
			{
			fgets(line, sizeof(line), f);

			if (!memcmp(line, " Dir ", 6))
				break;
			}

		if (!feof(f))
			{
			if (line[6] == ' ')
				t = atoi(line + 7);
			else 
				t = atoi(line + 6);

			if (t < 1 || t > 256)
				{
				fprintf(stderr, "Error: Directory %d is out of bounds.\n", t);
				exit(1);
				}
			else 
				printf("Found subdirectory %u.\r", t);

			memcpy(descr[t - 1], line + 11, 65);
			Clip(descr[t - 1]);

			fgets(line, sizeof(line), f);
			fgets(line, sizeof(line), f);

			fcnt[t - 1] = ReadNum(line + 13);
			bcnt[t - 1] = ReadNum(line + 32);

			fgets(line, sizeof(line), f);
			fgets(line, sizeof(line), f);
			fgets(line, sizeof(line), f);

			offset[t - 1] = ftell(f);

			if (t > topcnt)
				topcnt = t;
			}
		}

	printf("\n");
}

ulong	Offset(uint topic)
{
	if (topic >= topcnt)
		return 0;
	else
		return offset[topic];
}

void	OpenIndex()
{
	FILE	*f;

	f = fopen("allfile.idx", "rb");

	if (f)
		{
		LoadIDX(f);

		fclose(f);
		}
	else
		MkAFIDX();
}

ulong	ReadNum(char *s)
{
	ulong	val;

	while (isspace(*s))
		s++;

	val = 0;

	while (isdigit(*s) || *s == ',')
		{
		if (isdigit(*s))
			val = val * 10 + *s - '0';

		s++;
		}

	return val;
}

uint	TopicCnt()
{
	return topcnt;
}

void	WriteIDX()
{
	FILE	*f;

	f = fopen("allfile.idx", "wb");

	if (!f)
		{
		fprintf(stderr, "Unable to create ALLFILE.IDX\n");
		exit(1);
		}

	fwrite(&topcnt, 1, sizeof(topcnt), f);
	fwrite(offset, topcnt, sizeof(ulong), f);
	fwrite(descr, topcnt, sizeof(descr[0]), f);
	fwrite(fcnt, topcnt, sizeof(ulong), f);
	fwrite(bcnt, topcnt, sizeof(ulong), f);

	fclose(f);
}
