#include <bios.h>
#include <ctype.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "video.h"

static void		Cursor(uchar x, uchar y);
static int		Input(char *buf, uint size);
static void		IWDraw(char *prompt);
static void		IWRestore();
static void		IWSave();
static void		Print(uint y, char *line, uchar at);
static void		RefLine(uint pline, uint lline);
static void		SearchLine(uint *line);

static uint		atbord;
static uint		atcurs;
static uint		atscur;
static uint		atsrch;
static uint		atstxt;
static uint		attext;
static uint		datalcnt;
static uint		datapara;
static int		inpwind;
static uchar	iwxpos;
static uchar	iwypos;
static uint		iwsav[2000];
static uchar	iwxsiz;
static uchar	iwysiz;
static int		mono;
static uint		savcur;
static uint		savvid[2000];
static char		srchtxt[81];
static char		vbl79;
static uint		vcuroff;
static int		vidfnd;
static uint		vidfndln;
static uint		*vidram;
static uint		vidrows;

void	Cursor(uchar x, uchar y)
{
	REGS	r;

	r.h.ah = 0x02;
	r.h.bh = 0x00;
	r.h.dh = y;
	r.h.dl = x;
	int86(0x10, &r, &r);
}

uint	FndLine()
{
	return vidfndln;
}

int	Input(char *buf, uint size)
{
	uchar	fx, fy, fw;
	uint	voff;
	int	x, curs, off;

	fx = iwxpos + 2;
	fy = iwypos + 3;

	fw = size;

	if (fw > 60)
		fw = 60;

	voff = fy * 80 + fx;

	for (x = 0 ; x < fw ; x++)
		vidram[voff + x] = atsrch | ' ';

	curs	= 0;
	off	= 0;

	buf[0] = 0;

	while (1)
		{
		uint	k;
		char	*b;

		if (off > curs)
			off = curs;
		else if (off + fw < curs)
			off = curs - fw;

		b = buf + off;

		for (x = 0 ; x < fw ; x++)
			if (*b)
				vidram[voff + x] = atsrch | *b++;
			else
				vidram[voff + x] = atsrch | ' ';

		Cursor(fx + curs - off, fy);

		k = bioskey(0);

		if (k & 0x00ff)
			k &= 0x00ff;

		switch (k)
			{
			case 8:
				if (curs)
					buf[--curs] = 0;
				break;

			case '\n':
			case '\r':
				return 1;

			case 27:
				return 0;

			default:
				if (k >= 0x20 && k <= 0x7f && curs < size)
					{
					buf[curs++] = k;
					buf[curs] = 0;
					}
				break;
			}
		}
}

void	IWDraw(char *prompt)
{
	int	lx, rx, ty, by, cy, x, y, len;

	lx = iwxpos;
	rx = iwxpos + iwxsiz - 1;
	ty = iwypos;
	by = iwypos + iwysiz - 1;
	cy = iwypos + iwysiz / 2;

	for (y = ty ; y <= by ; y++)
		for (x = lx ; x <= rx ; x++)
			vidram[y * 80 + x] = attext | ' ';

	for (x = 1 ; x < iwxsiz - 1 ; x++)
		{
		vidram[ty * 80 + iwxpos + x] = attext | 205;
		vidram[cy * 80 + iwxpos + x] = attext | 205;
		vidram[by * 80 + iwxpos + x] = attext | 205;
		}

	vidram[ty * 80 + lx] = attext | 201;
	vidram[ty * 80 + rx] = attext | 187;
	vidram[cy * 80 + lx] = attext | 204;
	vidram[cy * 80 + rx] = attext | 185;
	vidram[by * 80 + lx] = attext | 200;
	vidram[by * 80 + rx] = attext | 188;

	vidram[(ty + 1) * 80 + lx] = attext | 186;
	vidram[(ty + 1) * 80 + rx] = attext | 186;
	vidram[(ty + 3) * 80 + lx] = attext | 186;
	vidram[(ty + 3) * 80 + rx] = attext | 186;

	len = strlen(prompt);

	x = iwxpos + (iwxsiz - len) / 2;

	for (y = 0 ; prompt[y] ; y++)
		vidram[(ty + 1) * 80 + x + y] = attext | prompt[y];
}

void	IWRestore()
{
	uint	h, v;

	for (v = 0 ; v < iwysiz ; v++)
		for (h = 0 ; h < iwxsiz ; h++)
			{
			uint	x, y;

			x = iwxpos + h;
			y = iwypos + v;

			vidram[y * 80 + x] = iwsav[v * iwxsiz + h];
			}
}

void	IWSave()
{
	uint	h, v;

	for (v = 0 ; v < iwysiz ; v++)
		for (h = 0 ; h < iwxsiz ; h++)
			{
			uint	x, y;

			x = iwxpos + h;
			y = iwypos + v;

			iwsav[v * iwxsiz + h] = vidram[y * 80 + x];
			}
}

void	Print(uint y, char *text, uchar at)
{
	uint	x;

	for (x = 0 ; x < 80 ; x++)
		if (*text)
			vidram[y * 80 + x] = (uint(at) << 8) | *((uchar*)text++);
		else 
			vidram[y * 80 + x] = (uint(at) << 8) | 0x0020;
}

void	RefLine(uint pline, uint lline)
{
	uchar	*ld;
	uint	line[80], at;
	int	x;

	if (lline < datalcnt)
		{
		ld = (uchar*)MK_FP(datapara + lline * 5, 0);

		if (pline == vcuroff + 1)
			at = atcurs;
		else if (ld[79] & 0x80)
			at = atstxt;
		else
			at = attext;

		for (x = 0 ; x < 79 ; x++)
			line[x] = at | ld[x];

		line[79] = at | ' ';

		if (srchtxt[0])
			{
			SearchLine(line);

			if (vidfnd && vidfndln == 0xffff)
				vidfndln = pline - 1;
			}

		memcpy(vidram + pline * 80, line, sizeof(line));
		}
	else
		for (x = 0 ; x < 80 ; x++)
			vidram[pline * 80 + x] = attext | ' ';
}

void	SearchLine(uint *line)
{
	int	x, fnd = 0;

	for (x = 0 ; x < 80 ; x++)
		{
		int	y;

		for (y = 0 ; srchtxt[y] ; y++)
			if (toupper(line[x + y] & 0x00ff) != toupper(srchtxt[y]))
				break;

		if (!srchtxt[y])
			{
			vidfnd	= 1;
			fnd		= 1;

			while (y--)
				line[x + y] = atsrch | (line[x + y] & 0x00ff);
			}
		}

	if (fnd)
		for (x = 0 ; x < 80 ; x++)
			if ((line[x] & 0xff00) == atcurs)
				line[x] = atscur | (line[x] & 0x00ff);
			else if ((line[x] & 0xff00) == attext)
				line[x] = atstxt | (line[x] & 0x00ff);
}

void	VidBL79(char c)
{
	vbl79 = c;

	if (c)
		vidram[vidrows * 80 - 1] = atbord | c;
	else 
		vidram[vidrows * 80 - 1] = atbord | ' ';
}

void	VidBotLine(char *text)
{
	uchar	*t = (uchar*)text;
	uint	*vr;
	int	c, x;

	vr = vidram + (vidrows - 1) * 80;

	c = (80 - strlen(text)) / 2;

	for (x = 0 ; x < 80 ; x++)
		if (vbl79 && x == 79)
			vr[x] = atbord | vbl79;
		else if (x >= c && *t)
			vr[x] = atbord | *t++;
		else
			vr[x] = atbord | ' ';
}

void	VidCursor(uint cur)
{
	vcuroff = cur;
}

void	VidDefData(uint base, uint lines)
{
	datapara = base;
	datalcnt = lines;
}

int	VidFound()
{
	return vidfnd;
}

void	VidHelp()
{
	Print( 2, "ͻ", 0x3e);
	Print( 3, " ESC           Quit AFView                                                    ", 0x3e);
	Print( 4, " ,           Move cursor line up and down                                   ", 0x3e);
	Print( 5, " PgUp, PgDn    Move up and down 1 page                                        ", 0x3e);
	Print( 6, " Home, End     Put cursor on top or bottom of screen                          ", 0x3e);
	Print( 7, " ^Home, ^End   Put cursor at top or bottom of list                            ", 0x3e);
	Print( 8, " Enter         Toggle between viewing directory list and a directory          ", 0x3e);
	Print( 9, " Alt S         Sort list                                                      ", 0x3e);
	Print(10, " F1            Display this screen                                            ", 0x3e);
	Print(11, " F5            Search for text                                                ", 0x3e);
	Print(12, " Shift F5      Search again                                                   ", 0x3e);
	Print(13, "͹", 0x3e);
	Print(14, " This silly little program was written by Chris Sokol.  If you find this      ", 0x3e);
	Print(15, " program useful, good.  I don't want anything from you.  Some day a real      ", 0x3e);
	Print(16, " version of this program may be written.  If you have any suggestions or      ", 0x3e);
	Print(17, " comments, send mail to chris@infosafe.com.  I don't really check my IF mail  ", 0x3e);
	Print(18, " so it must go to the above address.                                          ", 0x3e);
	Print(19, "͹", 0x3e);
	Print(20, " Oh, yeah.  This program is completely unsupported.  Sorry, no time for that. ", 0x3e);
	Print(21, "ͼ", 0x3e);
}

void	VidInit(int font8x8)
{
	REGS	r;

	r.h.ah = 0x0f;
	int86(0x10, &r, &r);

	if (r.h.al == 0x07)
		{
		vidram = (uint*)0xb0000000;
		mono = 1;
		}
	else if (r.h.al == 0x03)
		{
		vidram = (uint*)0xb8000000;
		mono = 0;
		}
	else
		{
		fprintf(stderr, "Program must be started in 80 column text mode.\n");
		exit(1);
		}

	memcpy(savvid, vidram, sizeof(savvid));

	r.h.ah = 0x03;
	r.h.bh = 0x00;
	int86(0x10, &r, &r);

	savcur = r.x.dx;

	if (!mono && font8x8)
		{
		r.x.ax = 0x0003;
		int86(0x10, &r, &r);

		r.x.ax = 0x1112;
		r.h.bl = 0x00;
		int86(0x10, &r, &r);

		r.x.ax = 0x1130;
		r.h.bh = 0x00;
		r.h.dl = 25;
		int86(0x10, &r, &r);

		vidrows = r.h.dl;
		}
	else
		vidrows = 25;

	Cursor(80, vidrows);

	if (mono)
		{
		atbord = 0x7f00;
		atcurs = 0x7000;
		atscur = 0x7000;
		atsrch = 0x7f00;
		atstxt = 0x0f00;
		attext = 0x0700;
		}
	else 
		{
		atbord = 0x4e00;
		atcurs = 0x2f00;
		atscur = 0x2f00;
		atsrch = 0x4f00;
		atstxt = 0x1f00;
		attext = 0x1e00;
		}
}

int	VidInput(char *prompt, char *buf, uint size)
{
	int	len, stat;

	len = strlen(prompt);

	if (size > len)
		len = size;

	iwxsiz = (len < 60) ? (len + 4) : (64);
	iwysiz = 5;

	iwxpos = (80 - iwxsiz) / 2;
	iwypos = (vidrows - iwysiz) / 2;

	IWSave();

	IWDraw(prompt);

	stat = Input(buf, size);

	IWRestore();

	Cursor(80, vidrows);

	return stat;
}

void	VidRefresh(uint topline)
{
	int	y;

	vidfnd	= 0;
	vidfndln	= 0xffff;

	for (y = 1 ; y < vidrows - 1 ; y++)
		RefLine(y, topline + y - 1);
}

uint	VidRows()
{
	return vidrows;
}

void	VidSearch(char *text)
{
	if (text)
		{
		memcpy(srchtxt, text, 80);
		srchtxt[80] = 0;
		}
	else
		srchtxt[0] = 0;
}

void	VidTerm()
{
	REGS	r;

	if (vidrows != 25)
		{
		r.x.ax = 0x0003;
		int86(0x10, &r, &r);
		}

	memcpy(vidram, savvid, sizeof(savvid));

	r.h.ah = 0x02;
	r.h.bh = 0x00;
	r.x.dx = savcur;
	int86(0x10, &r, &r);
}

void	VidTopLine(char *text)
{
	uchar	*t = (uchar*)text;
	int	c, x;

	c = (80 - strlen(text)) / 2;

	for (x = 0 ; x < 80 ; x++)
		if (x >= c && *t)
			vidram[x] = atbord | *t++;
		else
			vidram[x] = atbord | ' ';
}
