/*
AFVIEW.EXE - a browser for Invention Factory's ALLFILE.DIR text file.

This program was written by Chris Sokol.  It is worth nothing, and anyone can
do anything with it that they would like to.
*/

#include <bios.h>
#include <ctype.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "index.h"
#include "kbd.h"
#include "sort.h"
#include "video.h"

static void		AFV();
static void		ArgsInit(int argc, char **argv);
static void		BotFile();
static void		BotScr();
static int		ContainsSearch(int line);
static void		CursDn();
static void		CursUp();
static uint		DosAlloc(uint pcnt);
static void		DosFree(uint para);
static int		LineCmp(const void *p1, const void *p2);
static void		LoadSubDir(uint topic);
static void		MkLine(uint base, uint l, char *text);
static void		MkMaster();
static void		PageDn();
static void		PageUp();
static void		ProcKey();
static void		Refresh();
static void		SearchNext();
static void		Sort();
static void		TopFile();
static void		TopScr();
static void		Usage();
static void		ViewMaster();
static void		ViewSubDir(uint topic);

static FILE		*afdir;
static uint		curoff;
static ulong	*lineoffs;
static uint		*lines;
static uint		master;
static uint		nlines;
static uint		pagesz;
static uint		savcur;
static uint		savtop;
static char		search[81];
static int		showhelp;
static int		sortkey;
static int		startdir;
static uint		subdir;
static uint		topline;
static int		running;
static int		use8x8;
static int		vwmaster;

void	AFV()
{
	running	= 1;

	if (startdir >= 1 && startdir <= TopicCnt())
		ViewSubDir(startdir - 1);
	else 
		ViewMaster();

	while (running)
		ProcKey();
}

void	ArgsInit(int argc, char **argv)
{
	int	a;

	startdir	= -1;
	use8x8	= 0;

	for (a = 1 ; a < argc ; a++)
		if (argv[a][0] == '-')
			{
			switch (argv[a][1])
				{
				case '8':
					use8x8 = 1;
					break;

				default:
					Usage();
				}
			}
		else if (isdigit(argv[a][0]))
			startdir = atoi(argv[a]);
		else 
			Usage();
}

void	BotFile()
{
	if (nlines < pagesz)
		{
		topline = 0;
		curoff = nlines - 1;
		}
	else
		{
		topline = nlines - pagesz;
		curoff = pagesz - 1;
		}

	Refresh();
}

void	BotScr()
{
	if (nlines < pagesz)
		curoff = nlines - 1;
	else
		curoff = pagesz - 1;

	Refresh();
}

int	ContainsSearch(int line)
{
	uint	base;
	char	*text;
	int	len, x;

	base	= vwmaster ? master : subdir;
	text	= (char*)MK_FP(base + line * 5, 0);
	len	= strlen(search);

	for (x = 0 ; x < 80 ; x++)
		if (!memicmp(text + x, search, len))
			return 1;

	return 0;
}

void	CursDn()
{
	if (topline + curoff + 1 < nlines)
		if (curoff + 1 < pagesz)
			curoff++;
		else
			topline++;

	Refresh();
}

void	CursUp()
{
	if (curoff)
		curoff--;
	else if (topline)
		topline--;

	Refresh();
}

uint	DosAlloc(uint pcnt)
{
	uchar	*tmp[4];
	REGS	r;

	tmp[0] = new uchar[32768];
	tmp[1] = new uchar[32768];
	tmp[2] = new uchar[32768];
	tmp[3] = new uchar[32768];

	r.h.ah = 0x48;
	r.x.bx = pcnt;
	intdos(&r, &r);

	delete tmp[3];
	delete tmp[2];
	delete tmp[1];
	delete tmp[0];

	if (r.x.cflag)
		return 0;
	else
		return r.x.ax;
}

void	DosFree(uint para)
{
	SREGS	s;
	REGS	r;

	segread(&s);
	s.es = para;

	r.h.ah = 0x49;
	intdosx(&r, &r, &s);
}

int	LineCmp(const void *p1, const void *p2)
{
	uint	*u1 = (uint*)p1, *u2 = (uint*)p2;
	char	*f1, *f2;

	f1 = (char*)MK_FP(subdir + (*u1) * 5, 0);
	f2 = (char*)MK_FP(subdir + (*u2) * 5, 0);

	if (sortkey == SKdate)
		{
		int	m1, m2, d1, d2, y1, y2;

		m1 = atoi(f1 + 23);
		d1 = atoi(f1 + 26);
		y1 = atoi(f1 + 29);
		m2 = atoi(f2 + 23);
		d2 = atoi(f2 + 26);
		y2 = atoi(f2 + 29);

		if (y1 < y2)
			return -1;
		else if (y1 > y2)
			return 1;
		else if (m1 < m2)
			return -1;
		else if (m1 > m2)
			return 1;
		else if (d1 < d2)
			return -1;
		else if (d1 > d2)
			return 1;
		else
			return stricmp(f1, f2);
		}
	else if (sortkey == SKname)
		return stricmp(f1, f2);
	else if (sortkey == SKsize)
		{
		char	*sz1, *sz2;
		long	s1, s2;

		for (sz1 = f1 + 12 ; isspace(*sz1) ; sz1++)
			;

		for (sz2 = f2 + 12 ; isspace(*sz2) ; sz2++)
			;

		s1 = atol(sz1);
		s2 = atol(sz2);

		if (s1 < s2)
			return -1;
		else if (s1 > s2)
			return 1;
		else
			return stricmp(f1, f2);
		}
	else
		return 0;
}

void	LoadSubDir(uint t)
{
	char	line[100];

	fseek(afdir, Offset(t), 0);
	nlines = 0;

	memcpy(line, MK_FP(master + (t + 2) * 5, 0), 80);
	line[80] = 0;
	lineoffs[nlines] = 0xffffffff;
	MkLine(subdir, nlines++, line);

	memset(line, 205, 80);
	line[80] = 0;
	lineoffs[nlines] = 0xffffffff;
	MkLine(subdir, nlines++, line);

	while (nlines < 3000)
		{
		char	*p;
		int	tag;

		lineoffs[nlines] = ftell(afdir);

		fgets(line, sizeof(line), afdir);

		if (feof(afdir))
			break;

		p = strchr(line, 0);

		while (p > line && isspace(*(p - 1)))
			*--p = 0;

		if (!line[0] || line[0] == '')
			break;

		MkLine(subdir, nlines, line);

		nlines++;
		}
}

int	main(int argc, char *argv[])
{
	ArgsInit(argc, argv);

	OpenIndex();

	afdir = fopen("allfile.dir", "r+b");

	if (!afdir)
		{
		fprintf(stderr, "Unable to open ALLFILE.DIR\n");
		return 1;
		}

	MkMaster();

	subdir = DosAlloc(15000);

	if (!subdir)
		{
		DosFree(master);
		fclose(afdir);

		fprintf(stderr, "Unable to allocate enough memory\n");
		return 1;
		}

	lineoffs = new ulong[3000];

	VidInit(use8x8);

	VidTopLine("AFView - ALLFILEViewer.  For use with Invention Factory ALLFILE.DIR");
	VidBotLine("Written by Chris Sokol 2/95.");

	pagesz = VidRows() - 2;

	AFV();

	VidTerm();

	delete lineoffs;
	DosFree(subdir);
	DosFree(master);

	return 0;
}

void	MkLine(uint base, uint l, char *text)
{
	char	*p;
	int	len;

	p = (char*)MK_FP(base + l * 5, 0);

	len = strlen(text);

	if (len > 80)
		len = 80;

	memset(p, ' ', 80);
	memcpy(p, text, len);
}

void	MkMaster()
{
	int	t;
	char	line[81];

	master = DosAlloc((TopicCnt() + 2) * 5);

	MkLine(master, 0, "Description                                                Files      Bytes");
	MkLine(master, 1, "                                                      ");

	for (t = 0 ; t < TopicCnt() ; t++)
		{
		sprintf(line, "%-53s %10ld %10ld", Descr(t), FilCnt(t), BytCnt(t));

		MkLine(master, t + 2, line);
		}
}

void	*operator new(uint size)
{
	void	*m;

	m = calloc(1, size);

	if (!m)
		{
		REGS	r;

		r.x.ax = 0x0003;
		int86(0x10, &r, &r);

		fprintf(stderr, "Out of memory!\n");
		exit(1);
		}

	return m;
}

void	PageDn()
{
	if (topline + pagesz * 2 <= nlines)
		topline += pagesz;
	else if (topline + pagesz < nlines)
		topline = nlines - pagesz;
	else
		{
		BotFile();
		return;
		}

	Refresh();
}

void	PageUp()
{
	if (topline)
		if (topline >= pagesz)
			topline -= pagesz;
		else
			topline = 0;
	else
		curoff = 0;

	Refresh();
}

void	ProcKey()
{
	uint	k;

	k = bioskey(0);

	if (k & 0x00ff)
		k &= 0x00ff;

	VidBotLine("Written by Chris Sokol 3/95.");

	if (showhelp)
		{
		Refresh();
		showhelp = 0;
		}
	else if (k == 27)
		running = 0;
	else if (k == KB_CURS_UP)
		CursUp();
	else if (k == KB_CURS_DN)
		CursDn();
	else if (k == KB_PAGE_UP)
		PageUp();
	else if (k == KB_PAGE_DN)
		PageDn();
	else if (k == KB_HOME)
		TopScr();
	else if (k == KB_END)
		BotScr();
	else if (k == KB_CTL_HOME)
		TopFile();
	else if (k == KB_CTL_END)
		BotFile();
	else if (k == '\n' || k == '\r')
		if (vwmaster)
			{
			if (topline + curoff >= 2)
				{
				savcur = curoff;
				savtop = topline;

				ViewSubDir(topline + curoff - 2);
				}
			}
		else
			ViewMaster();
	else if (k == KB_F1)
		{
		VidHelp();
		showhelp = 1;
		}
	else if (k == KB_F5)
		{
		if (VidInput("Enter search text:", search, 80))
			{
			VidSearch(search);
			Refresh();

			if (search[0])
				if (VidFound())
					{
					curoff = FndLine();
					Refresh();
					}
				else 
					SearchNext();
			}
		}
	else if (k == KB_SHF_F5)
		if (search[0])
			SearchNext();
		else
			VidBotLine("Nothing to search for!");
	else if (k == KB_ALT_S)
		Sort();
}

void	Refresh()
{
	VidCursor(curoff);
	VidRefresh(topline);
}

void	SearchNext()
{
	if (topline + pagesz * 2 <= nlines)
		{
		topline += pagesz;

		while (topline + pagesz < nlines)
			if (ContainsSearch(topline))
				break;
			else
				topline++;

		Refresh();

		if (VidFound())
			{
			curoff = FndLine();
			Refresh();
			}
		}
}

void	Sort()
{
	uint	x;
	FILE	*f;

	VidBotLine("Sort by (D)ate, (N)ame, (S)ize.");

	while (1)
		{
		uint	k;

		k = bioskey(0) & 0x00ff;

		if (k == 27)
			{
			VidBotLine("Sort aborted.");
			return;
			}
		else if (k == 'd' || k == 'D')
			{
			sortkey = SKdate;
			break;
			}
		else if (k == 'n' || k == 'N')
			{
			sortkey = SKname;
			break;
			}
		else if (k == 's' || k == 'S')
			{
			sortkey = SKsize;
			break;
			}
		}

	VidBotLine("Sorting...");

	lines = new uint[nlines];

	for (x = 0 ; x < nlines - 2 ; x++)
		lines[x] = x + 2;

	qsort(lines, nlines - 2, sizeof(uint), LineCmp);

	f = fopen("temp.tmp", "wb");

	for (x = 0 ; x < nlines - 2 ; x++)
		{
		char	*l;

		l = (char*)MK_FP(subdir + lines[x] * 5, 0);

		fwrite(l, 1, 80, f);
		}

	fclose(f);

	f = fopen("temp.tmp", "rb");

	for (x = 2 ; x < nlines ; x++)
		{
		char	*l;

		l = (char*)MK_FP(subdir + x * 5, 0);

		fread(l, 1, 80, f);
		}

	fclose(f);

	delete lines;

	VidBotLine("Sort completed");

	Refresh();
}

void	TopFile()
{
	curoff = 0;
	topline = 0;

	Refresh();
}

void	TopScr()
{
	curoff = 0;

	Refresh();
}

void	Usage()
{
	fprintf(stderr, "AFVIEW [options] [dir#]\n");
	fprintf(stderr, "\t-8\tUse 8x8 font (EGA/VGA)\n");

	exit(1);
}

void	ViewMaster()
{
	curoff	= savcur;
	nlines	= TopicCnt() + 2;
	topline	= savtop;
	vwmaster	= 1;

	VidDefData(master, nlines);

	Refresh();
}

void	ViewSubDir(uint t)
{
	LoadSubDir(t);

	curoff	= 0;
	topline	= 0;
	vwmaster	= 0;

	VidDefData(subdir, nlines);

	Refresh();
}
