#include <proto/dos.h>
#include <proto/exec.h>

#define extern
#include "global.h"
#undef extern

#include "misc.h"
#include "readdir.h"
#include "adfile.h"
#include "shortad.h"
#include "incfile.h"
#include "convertad.h"
#include "readxref.h"

/***********************************************/

const static char VersionString[] = "\0$VER: ADtoHT " VERSION " " __AMIGADATE__;

/***********************************************/

void CloseAll(void)
{
	FreeArgs(RDArgs);
	if (IncludeDir)
		UnLock(IncludeDir);
	if (AutodocDir)
		UnLock(AutodocDir);
	if (XRefFile)
		Close(XRefFile);
	if (HypertextDir)
		UnLock(HypertextDir);
	if (ErrorFile)
		Close(ErrorFile);
	FreeList((struct AnyNode *) FileList);
	FreeList((struct AnyNode *) IncludeFileList);
	FreeList((struct AnyNode *) StructList);
	FreeList((struct AnyNode *) TypedefList);
	FreeList((struct AnyNode *) AutodocList);
	FreeList((struct AnyNode *) AutodocFileList);
	FreeList((struct AnyNode *) TypedefTempList);
	FreeVec(IncludeFileArray);
	FreeVec(StructArray);
	FreeVec(AutodocArray);
	FreeVec(TypedefArray);
	FreeVec(ShortAutodocArray);
}

/***********************************************/

int main(void)
{
	Arguments.XRefFile = "autodoc.xref";
	Arguments.Extension = ".guide";
	Arguments.ErrorFile = "NIL:";
	if (RDArgs = ReadArgs("AUTODOCS/A,INCLUDES/A,HYPERTEXT/A,XREFOUT/K,XREFIN/K,ERROR/K,EXTENSION/K,NOEXPAND/S,CED/S,SHORTTOC/S", (long *) &Arguments, NULL))
	{
		if (ErrorFile = Open(Arguments.ErrorFile, MODE_NEWFILE))
		{
			if (AutodocDir = Lock(Arguments.AutodocDir, ACCESS_READ))
			{
				if (IncludeDir = Lock(Arguments.IncludeDir, ACCESS_READ))
				{
					if (HypertextDir = Lock(Arguments.HypertextDir, ACCESS_READ))
					{
						if (!ReadXRef())
						{
							CloseAll();
							exit(RETURN_ERROR);
						}
						if (XRefFile = Open(Arguments.XRefFile, MODE_NEWFILE))
						{
							if (FPrintf(XRefFile, "/* This file was created by ADtoHT " VERSION " */\n"
										"/* Do not edit.                        */\n\n"
										"XREF:\n") == -1)
							{
								DosError(Arguments.XRefFile);
							}
							printf("*** Reading includes ***\n");
							if (!ProcessIncludes(IncludeDir, ""))
							{
								CloseAll();
								exit(RETURN_ERROR);
							}
							if (!(IncludeFileArray = (struct FileNode **) ListToArray((struct AnyNode *) FileList)))
							{
								CloseAll();
								exit(RETURN_ERROR);
							}
							FileList = NULL;
							if (!(StructArray = (struct StructNode **) ListToArray((struct AnyNode *) StructList)))
							{
								CloseAll();
								exit(RETURN_ERROR);
							}
							if (!(TypedefArray = (struct StructNode **) ListToArray((struct AnyNode *) TypedefList)))
							{
								CloseAll();
								exit(RETURN_ERROR);
							}
							if (!PrintIncludeFileList())
							{
								CloseAll();
								exit(RETURN_ERROR);
							}
							if (!PrintStructList())
							{
								CloseAll();
								exit(RETURN_ERROR);
							}
							if (!PrintTypedefs())
							{
								CloseAll();
								exit(RETURN_ERROR);
							}
							printf("*** Collecting autodoc contents ***\n");
							if (!ReadAutodocs())
							{
								CloseAll();
								exit(RETURN_ERROR);
							}
							if (!MakeShortAutodocs())
							{
								CloseAll();
								exit(RETURN_ERROR);
							}
							if (!PrintShortAutodocList())
							{
								CloseAll();
								exit(RETURN_ERROR);
							}
							if (FPrintf(XRefFile, "\n#\n") == -1)
							{
								DosError(Arguments.XRefFile);
							}
							printf("*** Converting autodocs to hypertext ***\n");
							if (!ConvertAutodocs())
							{
								CloseAll();
								exit(RETURN_ERROR);
							}
						}
						else
						{
							DosError(Arguments.XRefFile);
						}
					}
					else
					{
						DosError(Arguments.HypertextDir);
					}
				}
				else
				{
					DosError(Arguments.IncludeDir);
				}
			}
			else
			{
				DosError(Arguments.AutodocDir);
			}
		}
		else
		{
			DosError(Arguments.ErrorFile);
		}
	}
	else
	{
		DosError(NULL);
	}
	CloseAll();
}
