/* Read an existing crossreference file */

#include "global.h"
#include "misc.h"
#include "readdir.h"
#include "adfile.h"
#include "incfile.h"
#include "readxref.h"

/***********************************************/

static UBYTE MyBuffer[1000];

/* static struct RDArgs *RDArgs; */

static struct RDArgs __aligned MyArgs =
{
	{Buffer, 0, 0},
	NULL,
	MyBuffer, 1000,
	NULL,
	0
};

static struct
{
	char *Name;
	char *File;
	long *Line;
	long *Type;
	char *Comment;
}
Line;

/***********************************************/

#define XREF_ERROR 0
#define XREF_OK    1
#define XREF_END   2

static WORD GetLine(void)
{
	if (!ReadLine(TRUE, TRUE))
		return (XREF_ERROR);
	if (Buffer[0] != '\n')
	{
		MyArgs.RDA_Source.CS_Length = strlen(Buffer);
		MyArgs.RDA_Source.CS_CurChr = 0;
		MyArgs.RDA_DAList = NULL;
		if (RDArgs = ReadArgs("Name/A,File/A,Line/A/N,Type/A/N,Comment/F", (long *) &Line, &MyArgs))
		{
			return (XREF_OK);
		}
		else
		{
			PrintFault(IoErr(), NULL);
			printf("File %s, line %ld\n", CurrentSource, CurrentLine);
			return (XREF_ERROR);
		}
	}
	return (XREF_END);
}

/***********************************************/

BOOL ReadXRef(void)
{
	BOOL Success;
	BOOL SectionDone;
	int Index;

	Success = TRUE;
	if (CurrentSource = Arguments.XRefIn)
	{
		printf("*** Reading crossreference file ***\n");
		CurrentLine = 0;
		if (CurrentFile = Open(Arguments.XRefIn, MODE_OLDFILE))
		{
			for (Index = 0; Index < 6 && Success; Index++)
			{
				Success = ReadLine(TRUE, TRUE);
			}
			SectionDone = FALSE;
			while (!SectionDone && Success)
			{
				switch (GetLine())
				{
					case XREF_ERROR:
						Success = FALSE;
						break;
					case XREF_OK:
						if (!AddFile("", Line.File))
							Success = FALSE;
						FreeArgs(RDArgs);
						break;
					case XREF_END:
						SectionDone = TRUE;
						break;
				}
			}
			if (Success && !ReadLine(TRUE, TRUE))
				Success = FALSE;
			SectionDone = FALSE;
			while (!SectionDone && Success)
			{
				switch (GetLine())
				{
					case XREF_ERROR:
						Success = FALSE;
						break;
					case XREF_OK:
						if (!AddIdent(Line.Name, Line.File, *Line.Line, FALSE))
							Success = FALSE;
						FreeArgs(RDArgs);
						break;
					case XREF_END:
						SectionDone = TRUE;
						break;
				}
			}
			if (Success && !ReadLine(TRUE, TRUE))
				Success = FALSE;
			SectionDone = FALSE;
			while (!SectionDone && Success)
			{
				switch (GetLine())
				{
					case XREF_ERROR:
						Success = FALSE;
						break;
					case XREF_OK:
						if (!AddIdent(Line.Name, Line.File, *Line.Line, TRUE))
							Success = FALSE;
						FreeArgs(RDArgs);
						break;
					case XREF_END:
						SectionDone = TRUE;
						break;
				}
			}
			if (Success && !ReadLine(TRUE, TRUE))
				Success = FALSE;
			SectionDone = FALSE;
			while (!SectionDone && Success)
			{
				switch (GetLine())
				{
					case XREF_ERROR:
						Success = FALSE;
						break;
					case XREF_OK:
						if (Line.Comment)
						{
							char *Temp;
							Line.Comment += 3;
							for (Temp = Line.Comment; *Temp && *Temp != ' '; Temp++);
							*Temp = '\0';
							if (!AddAutodoc(Line.Comment, Line.File, *Line.Type))
								Success = FALSE;
						}
						else
						{
						}
						FreeArgs(RDArgs);
						break;
					case XREF_END:
						SectionDone = TRUE;
						break;
				}
			}
			if (!IoErr())
			{
				Success = TRUE;
			}
			Close(CurrentFile);
		}
		else
		{
			PrintFault(IoErr(), CurrentSource);
			Success = FALSE;
		}
	}
	return (Success);
}
