{******************************************************************
** CIPHER.PAS - a file encryption/decryption utility using an XOR *
**    algorithm. To encrypt a file named PLAIN.TXT to one named   *
**    CODE.TXT using the key string ABCD, type at the DOS prompt  *
**    this command line:
**       CIPHER ABCD PLAIN.TXT CODE.TXT                           *
**    To decrypt CODE.TXT back to PLAIN.TXT, you must use the same*
**    code string.   Issue this command at the DOS prompt:        *
**            CIPHER ABCD  CODE.TXT PLAIN.TXT                     *
**    Program author is Mark R. Parker.                           *
******************************************************************}

PROGRAM Cipher;
VAR
  Ch : Byte;
  Len,                      {Length of the encoding string}
  PCount: Integer;          {Count of command-line parameters}
  Index : LongInt;
  KeyStr: String[80];       {The encoding string}
  InFile, OutFile : FILE OF Byte;

PROCEDURE GiveUsage;
BEGIN
 WriteLn('Usage: cipher <key> <input-file> <output-file>');
 WriteLn('<key> is the coding/decoding character string,');
 WriteLn('<input-file> is the name of the file to be encrypted,');
 WriteLn('<output-file> is the name of the file to be decrypted.');
 WriteLn('First time encrypts, second time decrypts.')
END;   {GiveUsage}

PROCEDURE ErrorMsg1;
BEGIN
   WriteLn('Input file does not exist!');
   WriteLn('You must provide the name of an existing file!');
   WriteLn('Please try again.')
END;    {ErrorMsg1}

PROCEDURE ErrorMsg2;
BEGIN
   WriteLn('Output file already exists!');
   Write('Delete or rename the output file');
   WriteLn(' and try again.')
END;    {ErrorMsg2}

BEGIN
  Index := 0;              {Initialize variables}
  PCount := ParamCount;
  CASE PCount OF
    0 .. 2 : BEGIN         {Too few arguments on command-line}
               GiveUsage;
               Halt(1)
             END;

    3      : BEGIN         {Correct number of command-line args}
                     {Open input file - halt if file doesn't exist}
               Assign(InFile, ParamStr(2));
               {$I-} Reset(InFile); {$I+}
               IF IoResult <> 0 THEN
               BEGIN
                 ErrorMsg1;
                 Halt(2)
               END;
                       {Open output file - halt if file does exist}
               Assign(OutFile, ParamStr(3));
               {$I-} ReWrite(OutFile); {$I+}
               IF IoResult = 0 THEN
               BEGIN
                 ErrorMsg2;
                 Halt(3)
               END;

     {Everything was OK.  Each pass, read a character from the
      input file, encrypt it, then write it to the output file.}

               KeyStr := ParamStr(1);
               Len := Length(KeyStr);
               WHILE NOT Eof(InFile) DO
               BEGIN
                 Read(InFile, Ch);
                 Ch := Ch XOR Byte(KeyStr[Index MOD Len + 1]);
                 Inc(Index);
                 Write(OutFile, Ch)
               END;
               Close(InFile);
               Close(OutFile);
             END  { CASE PCount of 3 }
  END     {CASE}
END.








