#ifdef __GNUC__
#include <inline/exec.h>
#include <dos/dos.h>
#include <inline/dos.h>
#endif
#ifndef __GNUC__
#include <clib/exec_protos.h>
#include <clib/dos_protos.h>
#endif
#include <exec/memory.h>

extern struct WBStartup *_WBenchMsg;
extern int main(int argc,char *argv[]);
extern void *__mallocbase;
extern void *__stdiostreams;
extern void *__otherstreams;
extern void *__atexitbase;
extern void *__endlabel;

static char **argv=NULL;  /* You know */
static char *myname=NULL; /* Who am I ? = argv[0] */
static char *cline=NULL;  /* Copy of commandline = argv[1..argc-1] */

static char *getmyname(void)
{
  char *a;
  int l;
  for(l=256;;l+=256)
  {
    a=(char *)AllocVec(l,MEMF_ANY); /* Someone else cleans up for us */
    if (a==NULL)
      return NULL;
    if (GetProgramName(a,l))
      return a;
    FreeVec(a);
  }
}

static int argsize(char *string)
{
  int i=0;
  while (*string++!='\n')
    i++;
  return i;
}

#ifdef __GNUC__
volatile void exit(int returncode)
#else
void exit(int returncode)
#endif
{
  if(&__atexitbase+1!=&__endlabel)
    (*((void (**)(void))&__atexitbase)[1])(); /* Alle Funktionen ausfhren */
  if(&__otherstreams+1!=&__atexitbase)
    (*((void (**)(void))&__otherstreams)[1])(); /* Alle Files Schlieen */
  if(&__stdiostreams+1!=&__otherstreams)
    (*((void (**)(void))&__stdiostreams)[2])(); /* stdin, stdout, stderr */
  if(&__mallocbase+1!=&__stdiostreams)
    (*((void (**)(void))&__mallocbase)[1])(); /* Allozierten Speicher freigeben */
  if(myname!=NULL)
    FreeVec(myname);
  if(argv!=NULL)
    FreeVec(argv);
  if(cline!=NULL)
    FreeVec(cline);
  _exit(returncode);
}

static int wbstart(void)
{ return main(0,(char **)_WBenchMsg); }

static int clistart(char *commandline)
{
  int i;
  char *b;
  int argc;
  if((cline=(char *)AllocVec(argsize(commandline)+1,MEMF_ANY))==NULL)
    return RETURN_FAIL;
  b=cline;
  argc=1;
  while(*commandline!='\n')
  {
    if(*commandline!='\"')
      while(*commandline!='\n'&&*commandline!=' '&&*commandline!='\t')
	*b++=*commandline++;
    else
    { commandline++;
      while(*commandline!='\n'&&*commandline!='\"')
      {
	if(*commandline=='*')
	  if(*++commandline=='\n')
	    break;
	*b++=*commandline++;
      }
    }
    if(*commandline!='\n')
    {
      commandline++;
      while(*commandline==' '||*commandline=='\t')
	commandline++;
    }
    *b++='\0';
    argc++;
  }
  if((argv=(char **)AllocVec(argc*sizeof(char *),MEMF_ANY))==NULL)
    return RETURN_FAIL;
  if((myname=getmyname())==NULL) /* exit cleans up for us */
    return RETURN_FAIL;
  argv[0]=myname;
  b=cline;
  for (i=1;i<argc;i++)
  {
    argv[i]=b;
    while(*b++)
      ;
  }
  return main(argc,argv);
}

#ifdef __GNUC__
volatile void _main(char *commandline)
#else
void _main(char *commandline)
#endif
{
  if(&__stdiostreams+1!=&__otherstreams)
    (*((void (**)(void))&__stdiostreams)[1])(); /* stdin, stdout, stderr initialisieren */
  if(_WBenchMsg!=NULL)
    exit(wbstart());
  else
    exit(clistart(commandline));
}
