#include <exec/types.h>
#include <exec/memory.h>
#include <exec/nodes.h>
#include <exec/lists.h>

extern struct MinList __memorylist;

struct memoryentry
{
  struct MinNode node;
  unsigned long size[1]; /* &memoryentry.size[1] gibt dann den Speicher */
};

void *malloc(unsigned long size)
{
  struct memoryentry *a;
  a=(struct memoryentry *)AllocMem(sizeof(struct memoryentry)+size,MEMF_ANY);
  if(a==NULL)
    return NULL;
  a->size[0]=size;
  AddHead((struct List *)&__memorylist,(struct Node *)&a->node);
  return (void*)&a->size[1];
}

void free(void *ptr)
{
  struct memoryentry *a;
  a=(struct memoryentry *)ptr-1;
  Remove((struct Node *)&a->node);
  FreeMem(a,sizeof(struct memoryentry)+a->size[0]);
}

void __freeall(void)
{
  struct memoryentry *a;
  while ((a=(struct memoryentry *)RemHead((struct List *)&__memorylist))!=NULL)
    FreeMem(a,sizeof(struct memoryentry)+a->size[0]); /* Den Speicher freigeben */
}

void *calloc(unsigned long nmemb,unsigned long size)
{
  unsigned long l;
  unsigned long *a;
  void *b;
  l=nmemb*size+sizeof(unsigned long)-1&~sizeof(unsigned long);
  a=(unsigned long *)(b=malloc(l));
  if(b==NULL)
    return NULL;
  do
    *a++=0;
  while(l-=sizeof(unsigned long int));
  return b;
}

void *realloc(void *ptr,unsigned long size)
{
  void *a;
  unsigned long l;
  a=malloc(size);
  if(a==NULL)
    return NULL;
  l=((unsigned long *)ptr)[-1];
  l=l<size?l:size;
  CopyMem(ptr,a,l);
  return a;
}

