/*
	WILDFILE.C

	Some routines to support wildcard filename handling.. Done by MikMak
*/

#include <stddef.h>
#include <dir.h>
#include "wildfile.h"

char path[MAXPATH];
char drive[MAXDRIVE];
char dir[MAXDIR];
char name[MAXFILE];
char ext[MAXEXT];

struct ffblk ffblk;


char *GetFirstName(char *wildname)
/*
	Finds the first file in a directory that corresponds to the wildcard
	name 'wildname'.

	returns:	ptr to full pathname

				or

				NULL if file couldn't be found
*/
{
	int found;

	fnsplit(wildname,drive,dir,name,ext);

	if(!findfirst(wildname,&ffblk,0)){
		fnmerge(path,drive,dir,ffblk.ff_name,NULL);
		return path;
	}
	return NULL;
}


char *GetNextName(void)
/*
	Finds another file in a directory that corresponds to the wildcard
	name of the GetFirstName call.

	returns:	ptr to full pathname

				or

				NULL if file couldn't be found
*/
{
	if(!findnext(&ffblk)){
		fnmerge(path,drive,dir,ffblk.ff_name,NULL);
		return path;
	}
	return NULL;
}

