#ifndef MODPLAY_H
#define MODPLAY_H

#include "mytypes.h"


typedef struct AUDTMP{
	UBYTE kick;			// if true=sample has to be restarted
	UBYTE sample;		// which sample number (0-31)
	int   handle;		// which sample-handle

	ULONG size;			// size of the sample in bytes
	ULONG start;		// The start byte index in the sample
	ULONG loop;			// loop position (index) (only loop if loop<size)

	BYTE  volume;		// amiga volume (0 t/m 64) to play the sample at
	UWORD period;		// period to play the sample at

	/* You should not have to use the values
	   below in the player routine */

	UBYTE eff,dat,note;	//

	BYTE  retrig;		// retrig value (0 means don't retrig)
	BYTE  finetune;		// what finetune to use

	BYTE  tmpvolume;	// tmp volume
	UWORD tmpperiod;	// tmp period
	UWORD wantedperiod;	// period to slide to (with effect 3 or 5)

	UBYTE portspeed;	// noteslide speed (toneportamento)

	UBYTE glissando;	// glissando (0 means off)
	UBYTE wavecontrol;	//

	BYTE  vibpos;		// current vibrato position
	UBYTE vibspd;		// "" speed
	UBYTE vibdepth;		// "" depth

	BYTE  trmpos;		// current tremolo position
	UBYTE trmspd;		// "" speed
	UBYTE trmdepth;		// "" depth
} AUDTMP;


extern AUDTMP mp_audio[8];
extern UBYTE  mp_bpm;
extern UBYTE  mp_mainvol;

// Function prototypes:

void MP_NextPosition(void);
void MP_PrevPosition(void);
void MP_MainVol(UBYTE vol);
void MP_ExtSpd(int yesno);
void MP_HandleTick(void);
void MP_Init(MODFILE *m);
void MP_RegisterPlayer(void (*Player)(int chn,AUDTMP *aud,MODFILE *mf));

#endif

