#ifndef MODLOAD_H
#define MODLOAD_H

#include <stdio.h>
#include "mytypes.h"


typedef struct MSAMPINFO{	// sample header as it appears in a module
	UBYTE samplename[22];
	UWORD length;
	UBYTE finetune;
	UBYTE volume;
	UWORD reppos;
	UWORD replen;
} MSAMPINFO;



typedef struct SAMPLEINFO{	// new sample info with some converted types
	char  samplename[23];			// name of the sample
	int	  handle;					// handle <- NEW since 0.4
	UBYTE finetune;					// finetune value
	UBYTE volume;					// volume 0-64
	ULONG length;					// length of sample (in bytes)
	ULONG reppos;					// repeat position (relative to start)
	ULONG replen;					// repeat length
} SAMPLEINFO;



typedef struct MODULEHEADER{	// verbatim module header
	UBYTE      songname[20];    		// the songname..
	MSAMPINFO  samples[31];				// all sampleinfo
	UBYTE      songlength;				// number of patterns used
	UBYTE      magic1;					// should be 127
	UBYTE      positions[128];			// which pattern to play at pos
	UBYTE      magic2[4];				// string "M.K." or "FLT4" or "FLT8"
} MODULEHEADER;


typedef struct OLDMODULEHEADER{			// verbatim module header
	UBYTE      songname[20];    		// the songname..
	MSAMPINFO  samples[15];				// all sampleinfo
	UBYTE      songlength;				// number of patterns used
	UBYTE      magic1;					// should be 127
	UBYTE      positions[128];			// which pattern to play at pos
} OLDMODULEHEADER;



typedef struct MODTYPE{				// struct to identify type of module
	char 	id[4];
	UBYTE	channels;
	char 	*name;
} MODTYPE;



typedef struct MODFILE{
	int			userfp;				// 1 if user supplied fp
	FILE 	   *fp;          		// filepointer to modfile
	char 		songname[21];		// name of the song
	int  		numchn;				// number of tracks per pattern
	int  		numpat;				// number of patterns in this song
	int  		numsmp;				// number of samples
	char  	   *modtype;			// string type of module
	UBYTE 		songlength;			// number of positions in this song
	UBYTE 		positions[128];		// all positions
	void       *patterns[128];		// all patterns
	SAMPLEINFO	samples[31];		// all samples
} MODFILE;


// Function prototypes:

MODFILE *ML_Open(char filename[],FILE *fp);
int  	 ML_Load(MODFILE *mf);
void 	 ML_Free(MODFILE *mf);
void 	 ML_Load15(int yesno);


void ML_RegisterLoader(int (*Loader)(FILE *fp,SAMPLEINFO *smp));
void ML_RegisterUnLoader(void (*UnLoader)(int handle,SAMPLEINFO *smp));
const char *ML_Error(void);

#endif
