; TIP986.LSP: STAR.LSP   Draw Stars   (c)1994, Robert Trombley

(defun C:STAR (/ A C CT D H L MX N NA P P1 R R2 S)
 (setq A (/ pi 2.0) C nil CT 0 NA 0 R 0)
 (while (not C)
  (setq C (getpoint "\nCenter of star? "))
  (if (not C) (princ "\nRequires point. "))
 )
 (while (or (not NA) (< NA 3))
  (setq NA (getint "\nNumber of arms? "))
  (if (or (not NA) (< NA 3)) (princ "\nMust be 3 or more. "))
 )
 (while (or (not R) (<= R 0))
  (setq R (getdist C "\nRadius? "))
  (if (or (not R) (<= R 0)) (princ "\nMust be positive. "))
 )
 (setq P1 (polar C A R)
       N (* NA 2.0)
       D (/ (* pi 2.0) N)
       L (/ (* R (sin D)) (sin (+ A D)))
       H (* L (sin (- A (+ D D))))
 )
 (if (or (= NA 3) (= NA 4)) (setq H (/ R 5.0)))
 (princ "\nInner width for each arm? <")
 (princ (+ H H))
 (setq MX (getreal ">: "))
 (if MX (setq H (/ MX 2.0)))
 (setq R2 (/ H (sin D)))
 (command "LINE" P1
  (while (< CT N)
   (if (= (/ CT 2.0) (fix (/ CT 2.0)))
    (setq S R2)
    (setq S R)
   )
   (setq P (polar C (+ A D) S)
         D (+ D (/ (* pi 2.0) N))
   )
   (command (car (list P)))
   (setq CT (1+ CT))
   (if (= CT N) (command ""))
  )
 )
 (princ)
)

