/* POLYPT.C  (c)1994, Anthony Hotchkiss */

/* Entity modification example */
int polypt (void)
{
   struct resbuf *elist, *item;
   ads_name ename;
   ads_point pt, pnew;

   if (ads_entsel("\nSelect polyline: ", ename, pt) != RTNORM)
      {
         ads_alert("No entity selected...");
         return RTERROR;
      }
   ads_redraw(ename, 3);
   ads_getpoint(NULL,"\nEnter a new point: ",pnew);
   ads_entnext(ename,ename);  /* step to the first vertex */
   ads_entnext(ename,ename);  /* step to the second vertex */
   elist = ads_entget(ename);  /* get the dxf list of the vertex */
   for (item=elist; item; item = item->rbnext)
      if (item->restype == 10)  /* find the point group code */
         {
            item->resval.rpoint[X] = pnew[X]; /* replace X */
            item->resval.rpoint[Y] = pnew[Y];  /* replace Y */
            ads_entmod(elist);  /* modify the sub entity */
         }
   ads_entupd(ename);  /* update the sub entity
                                              (also updates the entire entity) */
   if (elist != NULL) 
      ads_relrb(elist);
   ads_retvoid();
} /* polypt */

