-- grep.e
-- usage: grep string [files...]
-- search through a bunch of files for a given string
-- example:  grep constant *.e
-- String may be given between quotes "...." with \ as an escape

constant SCREEN = 1
constant TRUE = 1
constant LINES_PER_CR = 21

integer line_count
line_count = LINES_PER_CR

integer console
integer match_count

procedure scan(integer fileNum, 
	      sequence string, 
	      sequence file_name,
	      integer show_name)
-- print all lines in current file containing the string
    object line

    while TRUE do
	line = gets(fileNum)
	if atom(line) then
	    return -- end of file
	else
	    if match(string, line) then
		match_count = match_count + 1
		if show_name then
		    puts(SCREEN, file_name & ": ")
		end if
		puts(SCREEN, line)
		line_count = line_count - 1
		if line_count = 0 then
		    puts(SCREEN, "\n\t\t=== Enter for more ===\n")
		    line = gets(console) -- pause
		    line_count = LINES_PER_CR
		end if
	    end if
	end if
    end while
end procedure

include getnames.e

procedure grep()
-- process all files 
-- usage: grep.bat string files...
    sequence string, line
    integer fileNum
    sequence file_names

    file_names = get_names()

    -- process all the files    
    line = command_line()
    if length(line) < 3 then
	puts(SCREEN, "usage: grep string [files]\n")
	return
    end if
    string = line[3]
    if length(string) = 0 then
	puts(SCREEN, "search string is empty\n")
	return
    end if
    match_count = 0
    for i = 1 to length(file_names) do
	fileNum = open(file_names[i], "r")   
	if fileNum = -1 then
	    printf(SCREEN, "cannot open %s\n", {file_names[i]})
	else
	    scan(fileNum, string, file_names[i], length(file_names) > 1)            
	    close(fileNum)
	end if
    end for
    if match_count > 1 then
        printf(SCREEN, "\n\t\t%d lines contain \"%s\"\n", {match_count, string})
    end if
end procedure

console = open("CON", "r")
if console != -1 then
    grep()
end if

