;* DIMISO.LSP by Victor Jensen, March 12, 1991.
; Include line (DEFUN C:DIMISO () (LOAD "DIMISO")) in ACAD.LSP including path
; with name if needed for self loading when DIMISO entered at AutoCAD Command:
; line from keyboard or menu pick.
;* Restore varables
(defun RESVAR ()
 (setvar "ORTHOMODE" o#m)
 (setvar "DIMTIH" d#t)
 (command "DIM" "DIMBLK" d#b "STY" t#s "EXIT"  ; set DIM variables to previous
          "SNAP" "S" "S" "")                   ; set drawing plane to standard
 (setvar "SNAPMODE" s#m)
 (setq *error* olderr o#m nil d#b nil t#s nil d#t nil s#m nil) ; set error handler to previous
)
;* Error handler
(defun DIMERR (s)
 (if (/= s "Function cancelled") (princ (strcat "\nError: " s)))
 (setq s nil)
 (resvar)     ; retore system variables
 (princ)
)
;* Main program
(defun C:DIMISO ( / di s1 s2 u p1 p2 p3 b c g h i p4 p5 p6 p7 p8 p9 d1 d2)
 (setvar "CMDECHO" 0)
 (setq olderr *error* *error* DIMerr    ; set error handler to program function
       d#b (getvar "DIMBLK")            ; get and save system variables
       t#s (getvar "TEXTSTYLE")
       o#m (getvar "ORTHOMODE")
       d#t (getvar "DIMTIH")
       s#m (getvar "SNAPMODE")
 )
 (command "Snap" "S" "I" "")            ; change drawing plane to iso
 (setvar "ORTHOMODE" 0)                 ; keep program from crashing
 (while (/= u "EXIT")                         ; start of DIMensioning loop
  (setq di (strcase (getstring "\nDIMiso: "))) ; enter command
  (while (or (= "U" di) (= "UNDO" di))         ; allow undo of last DIMension
   (command "UNDO" "1")                        ; undo last
   (setq di (strcase (getstring "\nDIMiso: "))) ; enter new command
   (if (= di "") (setq di "U"))                ; allow repeat with RETURN
  )
  (while (= "DIMVAR" di)                   ; start of DIMemsion variable loop
   (setq di (getstring "\nEnter DIMvar: ")) ; enter DIM-variable name
   (setvar "CMDECHO" 1)                    ; show DIM: prompt for input
   (command "DIM" di pause "EXIT")         ; use AutoCAD command to simplify
   (setvar "CMDECHO" 0)                    ; don't show commands
   (setq di (strcase (getstring "\nDIMiso: "))) ; enter new command
   (if (= di "") (setq di "DIMVAR"))           ; allow repeat with RETURN
  )                                          ; end of DIMension variable loop
  (if (= di "") (setq di d#c) (setq d#c di)) ; allow DIMension repeat
  (cond
   ((/= di "EXIT")                                  ; don't do if EXIT entered
    (setq s1 (getvar "DIMSE1") s2 (getvar "DIMSE2")) ; save variable settings
    (cond
     ((= di "HORZL") (setq b 90 c 150 g "ARROW30L" h "DIM30L" i 0)) ; settings
     ((= di "HORZR") (setq b 90 c 30 g "ARROW30R" h "DIM30R" i 2))  ; for type
     ((= di "VERTL") (setq b 150 c 90 g "ARROW30R" h "DIM30R" i 0)) ; of
     ((= di "VERTR") (setq b 30 c 90 g "ARROW30L" h "DIM30L" i 2))  ; DIMension
     ((= di "TOPL") (setq b 150 c 30 g "ARROW30L" h "DIM30L" i 1))  ; option
     ((= di "TOPR") (setq b 30 c 150 g "ARROW30R" h "DIM30R" i 1))  ; chosen
     (T (prompt "\nDIMISO: ERROR: unknown entry.")(setq di "EXIT")); error trap
    ) ; end cond
    (cond
     ((/= di "EXIT")                    ; don't do if set to EXIT by error trap
      (command "DIM" "DIMBLK" g "STY" h "EXIT") ; set arrow and style
      (setvar "SNAPISOPAIR" I)                  ; set iso drawing plane
      (setq p1 (getpoint"\nFirst extension line origin or RETURN to select: "))
      (cond
       ((= nil p1)                           ; if extension origin not entered,
        (setq p2 (entsel))                   ; select line to DIMension
        (while (= nil p2) (princ "\nNO object found!") (setq p2 (entsel)))
        (setq p2 (osnap (cadr p2) "MID")     ; find midpoint of picked line
              p1 (osnap p2 "END")            ; find start end of line
              p2 (polar p1 (angle p1 p2) (* 2.0 (distance p1 p2))) ; other end
        )
       )
       ((boundp 'p1)               ; if first extension origin entered, do this
        (initget 1) (setq p2 (getpoint "\nSecond extension line origin: "))
       )
      ) ; end cond
      (initget 1) (setq p3 (getpoint "\nDIMension line location: "))
      (setq p4 (inters p1 (polar p1 (*(/ PI 180.0)B) 1) ; locate points for
               p3 (polar p3 (*(/ PI 180.0)C) 1) onseg)  ; DIMension and
            p5 (inters p2 (polar p2 (*(/ PI 180.0)B) 1) ; and extension lines
               p3 (polar p3 (*(/ PI 180.0)C) 1) onseg)
            p3 (polar p5 (angle p5 p4)(/(distance p5 p4)2))
            p6 (polar p1 (angle p1 p4)(*(getvar "DIMEXO")(getvar "DIMSCALE")))
            p7 (polar p4 (angle p1 p4)(*(getvar "DIMEXE")(getvar "DIMSCALE")))
            p8 (polar p2 (angle p2 p5)(*(getvar "DIMEXO")(getvar "DIMSCALE")))
            p9 (polar p5 (angle p2 p5)(*(getvar "DIMEXE")(getvar "DIMSCALE")))
            d1 (rtos (distance p4 p5)(getvar "LUNITS")(getvar "LUPREC"))
            d2 (getstring (strcat "\nDIMension text <" d1 ">: "))
      )
      (if (= d2 "") (setq d2 d1)) ; allow default DIM text input
      (if (= (getvar "DIMSE1") 0) (command "LINE" p6 p7 "")) ; draw/don't draw
      (if (= (getvar "DIMSE2") 0) (command "LINE" p8 p9 "")) ; draw/don't draw
      (setvar "DIMSE1" 1)        ; prevent ALIGNED DIMension command drawing
      (setvar "DIMSE2" 1)        ; incorrect extension lines
      (command "DIM1" "ALIGNED" "NON" p4 "NON" p5 "NON" p5 d2)
      (if (= di "VERTR") (command "ROTATE" "L" "" p3 "180"))  ; correct text
;* orientation. if font used can't be set vertical, change "VERTR" to "VERTL".
      (setvar "DIMSE1" s1)       ; reset for next DIMension
      (setvar "DIMSE2" s2)
     ) ; end cond
    ) ; end cond
   ) ; end cond
   (T (setq u "EXIT")) ; if di set to EXIT
  ) ; end cond
 ) ; end DIMension loop
 (resvar) ; restore system variables
 (princ)  ; no nil on exit
) ; End of main program
;* Setup program on load
(setvar "cmdecho" 0)
(if
 (null (tblsearch "BLOCK" "ISOARRWS")) ; If isoarrows block not found
 (command "INSERT" "ISOARRWS" nil      ; insert block
          "STYLE" "DIM30R" "ROMANS" "0" "1" "30" "N" "N" "N"
          "STYLE" "DIM30L" "ROMANS" "0" "1" "-30" "N" "N" "N"
 )
;* If font being used can't use STYLE vertical orientation, remove last "N".
(setvar "cmdecho" 1)
) ; end setup on load
(princ)    ; no nil on load
