;                            C P Y L A Y

; CPYLAY copies selected entities and then changes the copied entities to
; the desired layer.

; olderr and ce are used by cpyerr function so they are global.

1: (defun c:cpylay ( / ss layname laylist en)

; Setup error handling and display
2:  (setq olderr *error*)
3:  (setq *error* cpyerr)
4:  (setq ce (getvar "cmdecho"))
5:  (setvar "cmdecho" 0)
6:  (princ "\nSelect entities to copy: ")

; If no entities selected exit.
7:  (setq ss (ssget))
8:  (if (null ss)
9:    (exit)
10:   )

; Get new layer name.  If none exit.
11:  (while (not laylist)
12:    (setq layname (getstring "\nEnter destination layer name: "))
13:    (if (= layname "")
14:      (exit)
15:      )
16:    (if (not (setq laylist (tblsearch "layer" layname)))
17:      (princ "\nError: Layer name not found.  Try again or enter to exit.")
18:      )
19:    )

; Set marker in drawing.  Copy entites
20:  (setq en (entlast))
21:  (setvar "cmdecho" 1)
22:  (command "copy" ss "" pause pause)
23:  (setvar "cmdecho" 0)
24:  (setq ss nil) ;Done with this selection set

; Collect copied entities into a selection set.
25:  (setq en (entnext en))
26:  (setq ss (ssadd))
27:  (while en
28:    (setq ss (ssadd en ss))
29:    (setq en (entnext en))
30:    )

; Change copied entities to the desired layer.
31:  (command "chprop" ss "" "la" layname "")
32:  (setq *error* olderr)
33:  (setvar "cmdecho" ce)
34:  (princ)
35:  )

;                                   C P Y E R R

; Error handler for CPYLAY program.

; ce and olderr are global variables from CPYLAY

36: (defun cpyerr (st)
37:   (if (/= st "quit / exit abort")
38:     (princ st)
39:     )
40:   (setvar "cmdecho" ce)
41:   (setq *error* olderror)
42:   )
