(defun c:cost ( / ent ename cost newcost)
 (Princ "\nSelect object to assign replacement cost: ")
 (while (not (setq ent (entsel))))
 (setq ename (car ent))

 (setq cost (getdata "COST" ename))

 (if cost
   ; prompt for cost with default
   (setq newcost (getstring T (strcat "\nNew replacement cost <" cost ">: ")))
   ; else just prompt
   (setq newcost (getstring T "\nReplacement cost: "))
 )
 ; if newcost is not null, set the cost
 (if newcost
   (setdata "COST" ename newcost)
 )
 (prin1)
)

(defun c:manu ( / ent ename manu newmanu)
 (Princ "\nSelect object to assign a manufacturer: ")
 (while (not (setq ent (entsel))))
 (setq ename (car ent))

 (setq manu (getdata "MANU" ename))

 (if manu
   ; prompt for manufacturer with default
   (setq newmanu (getstring T (strcat "\nNew manufacturer <" manu ">: ")))
   ; else just prompt
   (setq newmanu (getstring T "\nManufacturer: "))
 )
 ; if newmanu is not null, set the manu
 (if newmanu
   (setdata "MANU" ename newmanu)
 )
 (prin1)
)

(defun getdata (type ename / elist extlist applist sublist data xdcode xddata)
 (setq data nil)

 ; get only the extended entity data that we need
 (setq elist (entget ename (list type)))
 (setq extlist (assoc -3 elist))

 (if extlist
  (progn
   (setq extlist (cdr extlist))      ; Strip -3 from extlist
   (setq applist (car extlist))      ; get the application name      
   (setq applist (cdr applist))      ; Strip app name
   (while (and applist (null data))
     (setq sublist (car applist))    ; Get sub list
     (setq xdcode (car sublist))     ; Get group code
     (setq xddata (cdr sublist))     ; Get data
     (cond
       ((= 1000 xdcode)
         (setq data xddata)
       )
     )
     (setq applist (cdr applist))
   )
  )
 )
 ; return nil or data found
 data
)

(defun setdata (type ename newdata / elist extlist oklist newlist name oneapp
                                    rlist)
 ; make sure the application is registered 
 (regapp type)

 ; Get the complete entity data
 (setq elist (entget ename (list "*")))
 (setq extlist (assoc -3 elist))

 ; make a list for newdata
 (setq newlist (list type (cons 1002 "{")
                          (cons 1000 newdata)
                          (cons 1002 "}")
                )
 )
 (setq newlist (list newlist)) ; double parens for ext data

 (if (null extlist)
   (progn   ; If there is no extended entity data, add newlist
      (setq rlist (cons -3 newlist))
      (setq elist (append elist (list rlist)))
   )
   (progn   ; Data exists, carefully preserve the non-matching data
      ; remove -3 from the begining of the list
      (setq extlist (cdr extlist))

      (while extlist
         ; get the first application
         (setq oneapp (car extlist))
         (setq extlist (cdr extlist))

         ; check to see if it is not the same type we are setting
         (setq name (car oneapp))
         (if (/= (strcase name) (strcase type))
            (if (null oklist) ; if first, create oklist, else append
                (setq oklist (list oneapp))
                (setq oklist (append oklist (list oneapp)))
            )
         )
      ) ; while
      ; Now oklist contains all non-matching extended entity data

      ; append the new data
      (setq rlist (append oklist newlist))
      (setq rlist (cons -3 rlist))

      ; Substitute the modified extended entity data
      (setq elist (subst rlist (assoc -3 elist) elist))
   )
 )

 ; Check to make sure enough space is available
 (if (< (xdroom ename) (xdsize newlist) )
    (princ "\nUnable to add entity data.  Exceeds maximum.")
    (entmod elist)    ; update the entity
 )
)

(prin1)

