;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  Advanced AutoLISP Concepts            Bill Kramer
;;  March 1993  CADENCE
;;
;;  Julian date conversions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; LISTING 1   ;;;;
;;;;;;;;;;;;;;;;;;;;;
(defun J2D (J / Y D M)

;       Decompose Julian date into calendar date.  Algorithm is from
;       Collected Algorithms from Communications of the ACM.
;       Original AutoLISP from Autodesk examples on Compuserve

        (setq j (fix j)
              j (- j 1721119.0) ; 0h Jan 1 1583
              y (fix (/ (1- (* 4 j)) 146097.0)) ; century
                                     ; ^... 4 x 100 x 365.2425
              j (- (* j 4.0) 1.0 (* 146097.0 y))
              d (fix (/ j 4.0))
              j (fix (/ (+ (* 4.0 d) 3.0) 1461.0))
                                          ; ^... 4 x 365.25
              d (- (+ (* 4.0 d) 3.0) (* 1461.0 j))
              d (fix (/ (+ d 4.0) 4.0))
              m (fix (/ (- (* 5.0 d) 3) 153.0))
                                        ; ^... 5 x 30.6
              d (- (* 5.0 d) 3.0 (* 153.0 m))
              d (fix (/ (+ d 5.0) 5.0))
              y (+ (* 100.0 y) j)
        )
        (if (< m 10.0)
           (setq m (+ m 3))
           (progn
              (setq m (- m 9))
              (setq y (1+ y))
           )
        )

        ; return date string
        (formdate D M Y)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; LISTING 2   ;;;;
;;;;;;;;;;;;;;;;;;;;;
(defun FORMDATE (DD MM YY)
  (strcat
    (nth (1- (fix MM)) 
      (list "JAN" "FEB" "MAR" "MAY" "APR" "JUN" 
            "JUL" "AUG" "SEP" "OCT" "NOV" "DEC"))
    " "
    (if (< DD 10) "0" "")
    (itoa (fix DD))
    ", "
    (substr (itoa (fix YY)) 3 2)
  )
)
   ;   For US MM/DD/YYYY
   ;     (strcat
   ;       (itoa (fix MM))  ;; Month
   ;       "/"
   ;       (itoa (fix DD))  ;; Day
   ;       "/"
   ;       (itoa (fix YY))  ;; Year
   ;     )
   ;  For other DD/MM/YYYY
   ;     (strcat
   ;       (itoa (fix DD))  ;; Day
   ;       "/"
   ;       (itoa (fix MM))  ;; Month
   ;       "/"
   ;       (itoa (fix YY))  ;; Year
   ;     )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; LISTING 3   ;;;;
;;;;;;;;;;;;;;;;;;;;;
(defun C:DATES ()
  (prompt
    (strcat "\nDrawing: " (getvar "DWGNAME")
            "\n\tCreated: " (j2d (getvar "TDCREATE"))
            "\n\tLast saved: " (j2d (getvar "TDUPDATE"))
            "\n\tHours in dwg: " (rtos (* 24 (getvar "TDINDWG")) 2 3)
    )
  )
  (princ)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; LISTING 4   ;;;;
;;;;;;;;;;;;;;;;;;;;;
(defun LOG_DWG ()
   (if (null (findfile "DWGLOG.LOG"))
     (progn
       (setq FH (open "DWGLOG.LOG" "w"))
       (write-line 
         (strcat
           (pad_it "Drawing name" 35)
           (pad_it "Created" 12)
           (pad_it "Saved" 12)
           "Elapsed Hrs"
         )
         FH
       )
     )
     (setq FH (open (findfile "DWGLOG.LOG") "a"))
   )
   (write-line
     (strcat
       (pad_it (getvar "DWGNAME") 35) 
       (pad_it (j2d (getvar "TDCREATE")) 12)
       (pad_it (j2d (getvar "TDUPDATE")) 12)
       (rtos (* 24 (getvar "TDINDWG")) 2 3)
     )
     FH)
   (setq FH (close FH))
)
;----------------------------------------------------------
(defun PAD_IT (S N)
  (while (< (strlen S) N)
    (setq S (strcat S " "))
  )
  S
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; LISTING 5   ;;;;
;;;;;;;;;;;;;;;;;;;;;
(defun C:LOGEM ( / LOGLIST FN FH)
  (setq FN "")
  (while (setq FN (getfiled "Select drawing name for log list" FN "dwg" 0))
    (if (null (member FN LOGLIST))
       (setq LOGLIST (cons FN loglist)))
  )
  (setq FH (open "LOGEM.SCR" "w"))
  (foreach LOGGER LOGLIST
     (write-line "_OPEN" FH)
     (write-line LOGGER FH)
     (write-line "(load \"CDNC3-93\")" FH)
     (write-line "(LOG_DWG)" FH)
  )
  (setq FH (close FH))
  (command "_SCRIPT" "LOGEM")
  (princ)
)

