;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; AutoLISP Concepts       Sept 1993
;; W.Kramer
;;
;; Listing 1:  Plotter Queuing Utility
;;
(defun C:QPLT ( / PQ FH DH INX DFL)
  (setq DH (load_dialog "CDNC9-93.DCL")
        DFL ;;;default list
          (list ;;empty drawing name
                "1" ;;To fit flag
                "1.0" ;;scale 1
                "1.0" ;;scale 2
                "0" ;;rotation
                "0.0" ;;origin x
                "0.0" ;;origin y
                "D"   ;;plot display
          )
  )
  ;; Run dialog, loading PQ list
  (if (and DH (new_dialog "QPLOT" DH))
    (progn
      (QP:ACT) ;;define dialog actions
      ;; If ok return from dialog, write script file
      (if (= (start_dialog) 1)
        (progn
           (setq FH (open "CDNC9-93.SCR" "w")) ;; open plotter queue script
           (mapcar 'qp:build pq)
           (setq FH (close FH))
        )
      )
      (unload_dialog DH)
    )
    (prompt "\nUnable to load CDNC9-93.DCL file")
  )
  (princ)
)
;;================================================================
;; Listing 2.
;; QP:ACT  define dialog box actions
;;
(defun QP:ACT ()
  (action_tile "DWG" "(QP:UPDT (setq INX (atoi $value)))")
  (action_tile "SDWG" "(QP:SD)") ;;select new file w/getfiled
  (action_tile "DDWG" "(QP:RD)") ;;delete current file from list
  (action_tile "EDWG" "(QP:AL $value)") ;;add user input
  (action_tile "XS" "(QP:SUB INX 2 $value)") ;;edit scale1
  (action_tile "YS" "(QP:SUB INX 3 $value)") ;;edit scale2
  (action_tile "FS" "(QP:SUB INX 1 $value)") ;;edit fit flag
  (action_tile "R0" "(QP:SUB INX 4 \"0\")")  ;;edit rotation
  (action_tile "R90" "(QP:SUB INX 4 \"90\")")
  (action_tile "R180" "(QP:SUB INX 4 \"180\")")
  (action_tile "R270" "(QP:SUB INX 4 \"270\")")
  (action_tile "OX" "(QP:SUB INX 5 $value)") ;;origin X
  (action_tile "OY" "(QP:SUB INX 6 $value)") ;;       Y
  (action_tile "D" "(QP:SUB INX 7 $key)") ;; Display
  (action_tile "E" "(QP:SUB INX 7 $key)") ;; Extents
  (action_tile "L" "(QP:SUB INX 7 $key)") ;; Limits
  ;;
  ;; Set default values into dialog box
  ;;
  (set_tile "D" "1") ;;display
  (set_tile "OX" "0.0")
  (set_tile "OY" "0.0")
  (set_tile "R0" "1")
  (set_tile "FS" "1")
  (set_tile "XS" "1.0")
  (set_tile "YS" "1.0")
  ;;
  (mode_tile "PARAMS" 1)
  (mode_tile "DDWG" 1)
)
;;================================================================
;; Listing 3.
;; QP:SUB (index sub-index newvalue)
;;   side-effect, sets global PQ list
;;
(defun QP:SUB (IX JX NV / TMP)
  (setq TMP (nth IX PQ)
        TMP (nsub JX NV TMP)
        PQ (subst TMP (nth IX PQ) PQ)
  )
)
;;Substitute IIth member of LST with NEW value
(defun NSUB (II NEW LST)
  (cond
    ((= II 0) (cons NEW (cdr LST)))
    (t (cons (car LST) (NSUB (1- II) NEW (cdr LST))))
  )
)
;;================================================================
;; Listing 4.
;; QP:SD add file to list based on GETFILED
;;
(defun QP:SD ()
  (setq TMP (getfiled "Select drawing file" "" "dwg" 0))
  (QP:AL TMP)
)
;;----------------------------------------------------------------
(defun QP:AL (TMP)
  (if (and TMP 
           (not (assoc TMP PQ))
           (or (findfile TMP) (findfile (strcat TMP ".dwg"))))
    (progn
      (if PQ
        (setq PQ (append PQ (list (cons TMP (cdr (last PQ)))))
              INX (1+ INX))
        (progn
          (setq PQ (list (cons TMP DFL))
                INX 0)
          (mode_tile "PARAMS" 0) ;;enable dialog
          (mode_tile "DDWG" 0)
        )
      )
      (start_list "DWG")
      (mapcar 'add_list (mapcar 'car PQ))
      (end_list)
      (QP:UPDT INX)
    )
    (alert "Drawing name not accepted")
  )
)
;;-------------------------------------------------------------
(defun QP:UPDT (INX / TMP)      
  (setq TMP (nth INX PQ))
  (set_tile "DWG" (itoa INX))
  (set_tile "FS" (nth 1 TMP))
  (set_tile "XS" (nth 2 TMP))
  (set_tile "YS" (nth 3 TMP))
  (set_tile "OX" (nth 5 TMP))
  (set_tile "OY" (nth 6 TMP))
  (set_tile (strcat "R" (nth 4 TMP)) "1")
  (set_tile (nth 7 TMP) "1")
)
;;===========================================================
;; Listing 5.
;; QP:RD remove current member from list
;;
(defun QP:RD ( / CNT TMP)
  (if (= (length PQ) 1)
    (progn
      (setq PQ nil)
      (mode_tile "PARAMS" 1)
      (mode_tile "DDWG" 1)
      (start_list "DWG")
      (end_list)
    )
    (progn
      (setq CNT 0)
      (repeat (length PQ)
        (if (/= CNT INX)
          (setq TMP (cons (nth CNT PQ) TMP)))
        (setq CNT (1+ CNT))
      )
      (setq PQ (reverse TMP))
      (if (>= INX (length PQ))
        (setq INX (1- (length PQ))))
      (start_list "DWG")
      (mapcar 'add_list (mapcar 'car PQ))
      (end_list)
      (QP:UPDT INX)
    )
  )
)
;;================================================================
;; Listing 6
;; QP:BUILD  output script portion to plot drawing
;;
;; D_REC (<dwg> <Fit> <Scale1> <Scale2> <Rot> <OrX> <OrY> <What>)
;;          0     1      2        3       4     5     6      7
;;
;; Created & tested on EPSON 800 series printer/plotter
;;
(defun QP:BUILD (D_REC)
  (write-line "OPEN" FH)
  (write-line (nth 0 D_REC) FH)
  (write-line "PLOT" FH)
  (write-line (nth 7 D_REC) FH) ;;what to plot
  (write-line "Y N" FH) ;;change/plot to file
  (write-line "" FH) ;;no change to units
  (write-line (strcat (nth 5 D_REC) "," (nth 6 D_REC)) FH) ;;origin
  (write-line "" FH) ;;size
  (write-line (nth 4 D_REC) FH) ;;rotation
  (write-line "" FH) ;;hidden lines
  (if (= (nth 1 D_REC) "1")
    (write-line "F" FH)
    (write-line (strcat (nth 2 D_REC) "=" (nth 3 D_REC)) FH)
  )
  (write-line "" FH)
  (write-line "delay 5000" FH)
)
