;; PREVDWGS.LSP
;;
;; Written by:  Gary Zagrzebski
;;              Woodward Governor Company
;;              Stevens Point ,WI
;;
;; Lists the last five previously opened drawings in the File (POP1) pulldown
;; menu. If the file name is selected from the menu the drawing is opened.
;; This provides an easy way to open previously worked on drawings.  The names
;; of the last five drawings are stored in the file PREVDWGS.LST located in
;; the first directory of the acad search path.  PREVDWGS.LSP is loaded from
;; S::STARTUP in the ACAD.LSP file.  The menu uses DIESEL commands so
;; AutoCAD(Tm) release 12 or greater is required.
;;
;; Add the following to the file ACAD.MNU between the [Applications...] and
;; [About AutoCAD...] menu items in the File (POP1) pulldown menu:
;;
;; [--]
;; [$(if,$(>,$(strlen,$(getvar,users1)),28),+
;; $(eval,$(substr,$(getvar,users1),1,3)"..."$(substr,$(getvar,users1),+
;; $(-,$(strlen,$(getvar,users1)),21))),$(getvar,users1))+
;; $(if,$(eq,$(getvar,users1),""),~No previous drawing list....)]+
;; ^C^C^P_open (princ(getvar "users1")) ^P
;; [$(if,$(>,$(strlen,$(getvar,users2)),28),+
;; $(eval,$(substr,$(getvar,users2),1,3)"..."$(substr,$(getvar,users2),+
;; $(-,$(strlen,$(getvar,users2)),21))),$(getvar,users2))]+
;; ^C^C^P_open (princ(getvar "users2")) ^P
;; [$(if,$(>,$(strlen,$(getvar,users3)),28),+
;; $(eval,$(substr,$(getvar,users3),1,3)"..."$(substr,$(getvar,users3),+
;; $(-,$(strlen,$(getvar,users3)),21))),$(getvar,users3))]+
;; ^C^C^P_open (princ(getvar "users3")) ^P
;; [$(if,$(>,$(strlen,$(getvar,users4)),28),+
;; $(eval,$(substr,$(getvar,users4),1,3)"..."$(substr,$(getvar,users4),+
;; $(-,$(strlen,$(getvar,users4)),21))),$(getvar,users4))]+
;; ^C^C^P_open (princ(getvar "users4")) ^P
;; [$(if,$(>,$(strlen,$(getvar,users5)),28),+
;; $(eval,$(substr,$(getvar,users5),1,3)"..."$(substr,$(getvar,users5),+
;; $(-,$(strlen,$(getvar,users5)),21))),$(getvar,users5))]+
;; ^C^C^P_open (princ(getvar "users5")) ^P
;; [--]
;;
;; Added the following to the file ACAD.LSP:
;;
;; (defun S::STARTUP ()
;;   (load "prevdwgs")
;; )
;;
;; This program is released as Freeware for all to enjoy.

(if (= (getvar "dwgtitled") 1)
  (progn                               ;do if current dwg is named
    (setq curdwg (getvar "dwgname")
          temp ""
          i 1
    ); setq
    (repeat (strlen curdwg)            ;strip off any path from dwgname
      (setq char (substr curdwg i 1))
      (if (= char "\\")
        (setq temp "")
        (setq temp (strcat temp char))
      ); if
      (setq i (1+ i))
    );repeat
    (setq curdwg (strcat (getvar "dwgprefix") temp ".DWG")) ;full path name
    (setvar "users1" curdwg)           ;set users1 var
    (setq i 2)                         ;next users var number
  ); progn                             ;do if current dwg is unnamed
  (setq i 1)                           ;next users var number
); if

(setq dwglst (findfile "prevdwgs.lst")) ;find list of last 5 drawings

(if dwglst
  (progn                               ;do if drawing list exists
    (setq fl (open dwglst "r"))        ;open file for reading
    (setq dwg T)
    (while (and (<= i 5) (/= dwg nil)) ;loop until 5 names or end-of-file
      (setq dwg (read-line fl))        ;read file line
      (if (and (/= dwg nil) (/= dwg curdwg) (/= dwg ""))
        (progn                    ;do if dwg is valid & /= to current dwg
          (setvar (strcat "users" (itoa i)) dwg) ;set users var
          (setq i (1+ i))              ;next users var number
        ); progn
      ); if
    ); while
    (close fl)                         ;close file
  ); progn
  (progn                               ;do if drawing list doesn't exist
    (setq acadpath (getvar "acadprefix")
          temp ""
          char " "
          i 1
    ); setq
    (while (and (/= char ";") (/= char "")) ;get 1st dir in acad search path
      (setq char (substr acadpath i 1))
      (if (and (/= char ";") (/= char ""))
        (setq temp (strcat temp char)
              i (1+ i)
        ); setq
      ); if
    ); while
    (setq dwglst (strcat temp "prevdwgs.lst")) ;new dwg list filename
  ); progn
); if

(setq fl (open dwglst "w"))            ;open file for writing

(setq i 1)
(repeat 5                              ;write users1-5 var to file
  (write-line (getvar (strcat "users" (itoa i))) fl)
  (setq i (1+ i))
); repeat

(close fl)                             ;close file

(princ)
