;=========================================================
;; CADENCE  December 1993      Utilities
;; Advanced Programming:  W.Kramer
;;
;=========================================================
;; Listing 1:  List tags.  returns assoc list of tags and 
;;                         values for and insert entity.
(defun LIST_TAGS (EN / EL ANS)
  (setq EL (entget (entnext EN)))
  (while (= (cdr (assoc 0 EL)) "ATTRIB")
    (setq 
      ANS (cons
            (cons 
              (cdr (assoc 2 EL)) 
              (cdr (assoc 1 EL)))
            ANS)
      EL 
          (entget 
            (entnext 
               (cdr 
                 (assoc -1 EL))))))
  (reverse ANS)
)
;----------------------------------------------------------------------
(defun PUT_TAGS (EN TLIST / EL)
  (setq EL (entget (entnext EN)))
  (while (= (cdr (assoc 0 EL)) "ATTRIB")
    (if (assoc (cdr (assoc 2 EL)) TLIST)
      (entmod
         (subst
            (cons 1 
                  (cdr 
                    (assoc 
                      (cdr (assoc 2 EL)) 
                      TLIST)))
            (assoc 1 EL)
            EL)))
    (setq EL 
      (entget 
        (entnext 
          (cdr 
            (assoc -1 EL))))))
  (entupd EN)
)
;;--------------------------------------------------------
;; Listing 2:  List tags and put tags in action
;; Update title block data information
(defun C:TUPDT ()
  (setq CD (rtos 
              (getvar "CDATE") ;;get CDATE YYYYMMDD
              2 0) 
        CD (strcat (substr CD 5 2) "/" ;;month MM
                   (substr CD 7 2) "/" ;;day  DD
                   (substr CD 3 2))    ;;year YY
        SS1 (ssget "X" '((0 . "INSERT") (2 . "TITLE")))
  )
  (if SS1 ;;found title block!
    (progn
       (setq EN (ssname SS1 0)
             TLIST (list_tags EN)
             TLIST (subst (cons "DATE" CD)
                          (assoc "DATE" TLIST)
                          TLIST)
       )
       (put_tags EN TLIST)
       (prompt "\nTitle block data updated!")
    )
    (prompt "\nCould not find block TITLE.")
  )
  (princ)
)
