;=========================================================
;; CADENCE  December 1993      Utilities
;; Advanced Programming:  W.Kramer
;;
;=========================================================
;;-----------------------------------------------------------------
;; Listing 3:  3D math utilities
;;
;;  3D_EXT P1 P2 OFS
(defun 3D_EXT (P1 P2 OFS)
  (if (not (equal P1 P2 0.000001))
   (setq U (mapcar '- P2 P1)
         S (distance P1 P2)
         U (mapcar '/ U (list S S S))
         U (mapcar '* U (list OFS OFS OFS))
         P2 (mapcar '+ P2 U)
   )
  )
)
;;
;; 3D_MID P1 P2
(defun 3D_MID (P1 P2)
  (mapcar '(lambda (X1 X2) (/ (+ X1 X2) 2.0)) P1 P2)
)

