/***
*   Written By: Cynthia Allingham  11/01/91
*   Purpose:    Displays exploding box on the screen
*   Returns:    Previous screen contents
*/

FUNC CreateBox (nTop, nLeft, nBottom, nRight, box_color)

local save_window:=savescreen(nTop, nLeft, nBottom, nRight)
local save_color:=setcolor(box_color)
local save_cursor:=setcursor()
local save_row:=row()
local save_column:=col()

@ nTop,nLeft,nBottom,nRight BOX 'Ŀ '

RETURN {nTop, nLeft, nBottom, nRight, save_window,;
    save_color, save_cursor, save_row, save_column}

/***
*   Written By: Cynthia Allingham  11/01/91
*   Purpose:    destroys the box and restores old settings
*/

FUNC    DestroyBox (aList)

restscreen(aList[1],aList[2],aList[3],aList[4],aList[5])
setcolor(aList[6])
setcursor(aList[7])
setpos(aList[8],aList[9])
aList:=nil
return nil


/***
*   Written By: Cynthia Allingham  11/01/91
*   Purpose:    Changes the box border
*/

FUNC    BoldBox (aList, cColor)

@ aList[1],aList[2],aList[3],aList[4];
    BOX ''  color cColor

return nil


/***
*   Written By: Cynthia Allingham  11/01/91
*   Purpose:    Redimensions the screen
*/

FUNC    MoveBox (aList, nVert, nHorz)

local save_window:=savescreen(aList[1],aList[2],aList[3],aList[4])

dispbegin()
restscreen(aList[1],aList[2],aList[3],aList[4],aList[5])
aList[3] += nVert; aList[1]+=nVert
aList[4] += nHorz; aList[2]+=nHorz
aList[5]:=savescreen(aList[1],aList[2],aList[3],aList[4])
restscreen(aList[1],aList[2],aList[3],aList[4],save_window)
dispend()

return nil

