DEFINT A-Z

    CONST BPORT = &H220  'Base Port address
    CONST XPORT = &H226  'Reset port address
    CONST WPORT = &H22C  'Write port address
    CONST RPORT = &H22A  'Read port address
    CONST APORT = &H22E  'Data Available port address

    DIM peakarrayc(37)    'peak leng
    lenpc = 0
    lastdc = 0   'last direction
    lastgotc = 128
    lastcapc = 128
    nextonec = 1

    DEF SEG = &HA000
    SCREEN 13
    
    DO
        OUT WPORT, &H20           'Tell SoundBlaster you wanna read a byte.
        gotit = INP(RPORT)
        dir = gotit - lastgotc
        
        IF dir > 1 THEN currentd = 1 ELSE IF dir < -1 THEN currentd = -1 ELSE currentd = lastd

        IF currentd <> lastd THEN
            IF nextonec = 1 THEN
                nextonec = 0
                lastcapc = gotit
            ELSE
                nextonec = 1
                amt = ABS(lastcapc - gotit)
                IF amt > 151 THEN amt = 151
                amt = amt \ 4
                peakarrayc(amt) = peakarrayc(amt) + 1
            END IF
        END IF
        
        atpc = atpc + 1

        lastdc = currentdc
        lastgotc = gotit
        
        IF atpc = 2500 THEN
            atpc = 0
            FOR r = 0 TO 37
                xx = peakarrayc(r)
                peakarrayc(r) = 0
                IF xx > 94 THEN xx = 94

                    IF xx < 94 THEN
                        FOR rr = xx + 1 TO 94
                            POKE (((94 - rr) * 320) + r) * 2 + 1, &H0
                        NEXT
                    END IF

                    FOR rr = 0 TO xx
                        POKE (((94 - rr) * 320) + r) * 2 + 1, &HF
                    NEXT
            NEXT
        END IF
    LOOP UNTIL INP(&H60) = 1    'esc pressed

    SCREEN 0
    PRINT "Realtime Frequency Analysis"
    PRINT
    PRINT " -based on level change between even wave peaks (top->top)"
    PRINT " -ie: high vol chng / low lfo / simple wave -----> low change"
    PRINT "      low vol chng / high lfo / complex wave  ---> high change"
    END

