DEFINT A-Z

    CONST BPORT = &H220  'Base Port address
    CONST XPORT = &H226  'Reset port address
    CONST WPORT = &H22C  'Write port address
    CONST RPORT = &H22A  'Read port address
    CONST APORT = &H22E  'Data Available port address

    DIM chgarray(40) 'change
    DIM lenarray(40) 'sust. len.
    DIM peakarray(30)    'peak leng
    lenp = 0
    lastd = 0   'last direction
    lastgot = 128
    lch0 = 0
    tz0 = 0

    DEF SEG = &HA000
    SCREEN 13

    lens = 0: lasts = 0
    
    DO
        OUT WPORT, &H20           'Tell SoundBlaster you wanna read a byte.
        gotit = INP(RPORT)
        gg = (gotit - 128)
        
        lastd = currentd
        lastgot = gotit

        IF gg > 4 THEN current = 1 ELSE IF gg < -4 THEN current = -1 ELSE current = lasts
        IF current <> lasts THEN
            IF lens > 309 THEN lens = 309
            lens = lens \ 10
            lenarray(lens) = lenarray(lens) + lens
            lens = 0
        ELSE
            lens = lens + 1
        END IF

        IF ABS(gg) > 4 THEN
            chng = ABS(gotit - last)
            IF chng > 39 THEN chng = 39
            IF chng = 0 THEN
                tz0 = tz0 + 1
                lch0 = 1
            ELSE
                IF lch0 = 1 THEN
                    xx = 41 - tz0
                    IF xx < 0 THEN xx = 0
                    chgarray(xx \ 2) = chgarray(xx \ 2) + 1
                    tz0 = 0
                    lch0 = 0
                ELSE
                    chgarray((chng + 40) \ 2) = chgarray((chng + 40) \ 2) + 1
                END IF
            END IF
        END IF
        
        at1 = at1 + 1
        at = at + 1

        lasts = current
        last = gotit
        
        IF at1 = 750 THEN
            at1 = 0
            FOR r = 0 TO 40
                xx = chgarray(r)
                chgarray(r) = 0
                IF xx > 94 THEN xx = 94

                    IF xx < 94 THEN
                        FOR rr = xx + 1 TO 94
                            POKE (((94 - rr) * 320) + r) * 2 + 1, &H0
                        NEXT
                    END IF

                    FOR rr = 0 TO xx
                        POKE (((94 - rr) * 320) + r) * 2 + 1, &HF
                    NEXT
            NEXT
        END IF

        IF at = 2500 THEN
            at = 0
            FOR r = 0 TO 30
                xx = lenarray(30 - r)
                lenarray(30 - r) = 0
                IF xx > 94 THEN xx = 94

                    IF xx < 94 THEN
                        FOR rr = xx + 1 TO 94
                            POKE (((94 - rr) * 320) + r) * 2 + 10, &H0
                        NEXT
                    END IF

                    FOR rr = 0 TO xx
                        POKE (((94 - rr) * 320) + r) * 2 + 10, &H9
                    NEXT
            NEXT
        END IF
    LOOP UNTIL INP(&H60) = 1    'esc pressed

    SCREEN 0

    PRINT "Realtime Frequency Analysis"
    PRINT
    PRINT " -based on angles from sample point to sample point (white)"
    PRINT " -ie: high frequency / high volume --> high angle"
    PRINT "      low frequency / low volume ----> low angle"
    PRINT "                 combined with"
    PRINT " -based sustinance above/below neutral sample point (blue)"
    PRINT " -ie: high frequency / complex frequency --> high crossrate"
    PRINT "      low frequency / simple frequency ----> low crossrate"
    END

