'Ŀ
' copies InFile$ to OutFile$ w/error checking, but does not verify    
' existence of InFile$                                                
' if OutFile$ already exists, it is truncated to 0, then overwritten  
' if copy is good, function returns 0                                 
' if error occurs, function returns PB error code                     
'ٰ
'  

FUNCTION CopyFile%(BYVAL InFile$, BYVAL OutFile$) PUBLIC
LOCAL BytesLeft&, MaxString%, FileIn%, FileOut%

$CODE SEG "DNASEG2"

ON LOCAL ERROR GOTO CopyFileError

FileIn% = FREEFILE                        'source file
OPEN InFile$ FOR BINARY AS FileIn%

FileOut% = FREEFILE
OPEN OutFile$ FOR OUTPUT AS FileOut%      'clear destination file if
CLOSE FileOut%                            'it exists
OPEN OutFile$ FOR BINARY AS FileOut%      'reopen destination

MaxString% = FRE(t$)                      'create largest buffer possible
Buffer$ = SPACE$(MaxString%)
BytesLeft& = LOF(FileIn%)                 'bytes to copy

DO
  IF BytesLeft& < MaxString% THEN         'nearly done
    MaxString% = BytesLeft&
    Buffer$ = SPACE$(MaxString%)
  END IF
  GET FileIn%,,Buffer$
  PUT FileOut%,,Buffer$
  BytesLeft& = BytesLeft& - MaxString%
LOOP WHILE ISTRUE(BytesLeft&)

CLOSE FileIn%, FileOut%

'-----------------------------------------------------------------------------
ExitCopyFile:

EXIT FUNCTION
'-----------------------------------------------------------------------------
CopyFileError:

CLOSE
CopyFile% = ERRTEST
RESUME ExitCopyFile
'-----------------------------------------------------------------------------
END FUNCTION
'-----------------------------------------------------------------------------
