DECLARE SUB GetStrLoc() 'we have to declare this because we need it
$INCLUDE "DNALIB.INC"
$LINK "DNALIB.PBL"

StatusAttr% = 14: BarAttr% = 112: HelpTextColor% = 0
HelpAttr% = 48: TextAttr% = 30: ErrorTxt% = 14: ErrorAttr% = 79
Allow$ = " ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890-=`~!@#$%^&*()_+}{[]:;'?><,./\|"
SearchFor$ = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-*~='"
Delimiter$ = " ,($[{" + CHR$(10)
Top% = 3: Bottom% = 23: LeftSide% = 2: RightSide% = 79: TextWidth% = 78
Pointer% = 1: Offset% = 0: Immbed% = 0: Tag% = 0

IF MouseThere% THEN Mouse% = 1

DIM About$(15)
DIM Prnter$(40)
DIM Action$(40)

HorzMenu$(1) = "@File" :HorzMenu$(2) = "@Edit"
HorzMenu$(3) = "@Search" :HorzMenu$(4) = "@Utilities"
HorzMenu$(5) = "@Help"

VertMenu1$(1) = "@New" :
VertMenu1$(2) = "@Open" :
VertMenu1$(3) = "@Save"
VertMenu1$(4) = "Save @As" :
VertMenu1$(5) = "_"
VertMenu1$(6) = "@Print" :
VertMenu1$(7) = "_"
VertMenu1$(8) = "@Dos Shell"
VertMenu1$(9) = "E@xit"

VertMenu2$(1) = "Cu@t" :VertMenu2$(2) = "@Copy"
VertMenu2$(3) = "@Paste" :VertMenu2$(4) = "@Delete"
VertMenu2$(5) = "@Show Clipboard"

VertMenu3$(1) = "@Find" :VertMenu3$(2) = "@Replace"
VertMenu3$(3) = "@Search again"

VertMenu4$(1) = "Printer @Setup": VertMenu4$(2) = "Codes to @Printer"
VertMenu4$(3) = "@Tagging OFF"

VertMenu5$(1) = "@Help" :VertMenu5$(2) = "About @DNA.Write"

About$(1) = "DNA Library meets PBWrite"
About$(2) = "by"
About$(3) = " Chris Foot. Erik Olson. Lloyd Smith. Mel Bishop "
About$(4) = " "
About$(5) = "I would like to thank the above people and others "
About$(6) = "who have contributed source code either knowingly "
About$(7) = "or other wise to this project.   And to encourage "
About$(8) = "other PowerBASIC users to share their Source code "
About$(9) = " "
About$(10) = "  I can be reached at the PowerBASIC tech support"
About$(11) = "BBS or at this address                           "
About$(12) = "                               15305 - 117 avenue"
About$(13) = "                                Edmonton, Alberta"
About$(14) = "FAX (403)452-5969                 CANADA, T5M 3X4"

ON ERROR GOTO WriteError

IF LEN(COMMAND$) THEN
  FileName$ = COMMAND$
  Test$ = DIR$(FileName$)
  IF LEN(Test$) THEN
    Been% = 1
    GOSUB LoadFile
  ELSE
    IF YesNo%("File does not Exist! should I create it? (Y or N)",1,10,79,112,1,1) THEN
      Been% = 1
      GOSUB LoadFile
    ELSE
      Test$ = DIR$("NONAME.TXT")
      IF LEN(Test$) THEN
        FileName$ = "NONAME.TXT"
        Been% = 1
        GOSUB LoadFile
      ELSE
        GOSUB DefaultFile
      END IF
    END IF
  END IF
ELSE
  Test$ = DIR$("NONAME.TXT")
  IF LEN(Test$) THEN
    FileName$ = "NONAME.TXT"
    Been% = 1
    GOSUB LoadFile
  ELSE
    GOSUB DefaultFile
  END IF
END IF

SplitPath GetProgramName$, Home$, EXEName$

SCREEN 0

TopRow% = 1
Marker% = 99
Popwind Title$,2,1,24,80,23,Shadow%,1
COLOR 7,1
LOCATE 24,3,0
PRINT "Line:     Col:     ĴFileSize:        "
LOCATE 4,80,0: PRINT CHR$(24);
LOCATE 22,80,0: PRINT CHR$(25);
LOCATE 24,62,0: PRINT CHR$(27) + STRING$(16,176) + CHR$(26);
AreaCLS 5,80,17,1,176,23
COLOR 0,7
LOCATE 25,1,0
PRINT SPACE$(80);
COLOR 4,7
LOCATE 25,2,0: PRINT "F1       F2       F3       F4               F6";
COLOR 0,7
LOCATE 25,4,0: PRINT "-Help";
LOCATE 25,13,0: PRINT "-Save";
LOCATE 25,22,0: PRINT "-Open";
LOCATE 25,31,0: PRINT "-Search Again";
LOCATE 25,48,0: PRINT "-Load Macros";

Menu:

LockStatus 25,70,BarAttr%,StatusAttr%

HORIZONTALMENU HorzMenu$(),BarSave$,HiLight%,Mouse%,HPointer%,4,112,15,TopRow%,4,Marker%

SELECT CASE HPointer%
	CASE 1  'Miscellaneous
	  VERTICALMENU VertMenu1$(),VertInfo1$(),VRtrn$,BarSave$,Mouse%,4,HelpTextColor%,HelpAttr%,15,TopRow%,Marker%,HPointer%,112,1,1
	  IF LEN(VRtrn$) THEN
	    SELECT CASE VRtrn$
		CASE "New"
                  GOSUB ClearAll
                CASE "Open"
                  GOSUB LoadNew
		CASE "Save"
                  GOSUB Save
                CASE "Save As"
                  GOSUB SaveAs
                CASE "Print"
                  IF LEN(Block$) THEN
                    IF YesNo%("Print Marked Text? (Y or N)",1,10,79,112,1,1) THEN
                      WIDTH "LPT1:",255
                      LPRINT Block$
                    ELSE
                      GOSUB PrintAll
                    END IF
                  ELSE
                    GOSUB PrintAll
                  END IF
                CASE "Dos Shell"
                  GOSUB DosShell
                CASE "Exit"
                  IF NoSave% THEN
                    IF YesNo%("Quit and Lose Changes to Current File? (Y or N)",1,10,79,112,1,1) THEN
                      GOTO WayOut
                    ELSE
                      GOSUB QuitSave
                    END IF
                  ELSE
                    GOTO WayOut
                  END IF
	    END SELECT
          ELSE
            IF Marker% THEN GOTO Menu
	  END IF
	CASE 2  'Edit
          VERTICALMENU VertMenu2$(),VertInfo2$(),VRtrn$,BarSave$,Mouse%,4,HelpTextColor%,HelpAttr%,15,TopRow%,Marker%,HPointer%,112,1,1
	  IF LEN(VRtrn$) THEN
	    SELECT CASE VRtrn$
		CASE "Cut"
                  GOSUB DeleteBlock
		CASE "Copy"
		CASE "Paste"
                  GOSUB CopyBlock
		CASE "Delete"
		CASE "Show Clipboard"
                  IF LEN(Block$) THEN
                    GOSUB ViewClipboard
                  ELSE
                    Message$(1) = " Nothing to View "
                    SOUND 50,5
                    DIALOG Message$(),"",1,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
                  END IF
	    END SELECT
          ELSE
            IF Marker% THEN GOTO Menu
	  END IF
	CASE 3  'Screen
          VERTICALMENU VertMenu3$(),VertInfo3$(),VRtrn$,BarSave$,Mouse%,4,HelpTextColor%,HelpAttr%,15,TopRow%,Marker%,HPointer%,112,1,1
	  IF LEN(VRtrn$) THEN
	    SELECT CASE VRtrn$
		CASE "Find"
                  GOSUB FindText
                CASE "Replace"
                  GOSUB SearchAndReplace
                CASE "Search again"
                  GOSUB SearchAgain
	    END SELECT
          ELSE
            IF Marker% THEN GOTO Menu
	  END IF
	CASE 4  'Utilities
          VERTICALMENU VertMenu4$(),VertInfo4$(),VRtrn$,BarSave$,Mouse%,4,HelpTextColor%,HelpAttr%,15,TopRow%,Marker%,HPointer%,112,1,1
	  IF LEN(VRtrn$) THEN
	    SELECT CASE VRtrn$
		CASE "Printer Setup"
                  GOSUB PrinterSetup
                CASE "Codes to Printer"
                  VertMenu4$(2) = "Codes to @Document"
                  Immbed% = 1
                CASE "Codes to Document"
                  VertMenu4$(2) = "Codes to @Printer"
                  Immbed% = 0
                CASE "Tagging ON"
                  VertMenu4$(3) = "@Tagging OFF"
                  Tag% = 0
                CASE "Tagging OFF"
                  VertMenu4$(3) = "@Tagging ON"
                  Tag% = 4
	    END SELECT
          ELSE
            IF Marker% THEN GOTO Menu
	  END IF
	CASE 5  'Help
          VERTICALMENU VertMenu5$(),VertInfo5$(),VRtrn$,BarSave$,Mouse%,4,HelpTextColor%,HelpAttr%,15,TopRow%,Marker%,HPointer%,112,1,1
	  IF LEN(VRtrn$) THEN
	    SELECT CASE VRtrn$
		CASE "Help"
                  GOSUB KeyBoardHelp
		CASE "About DNA.Write"
		  DIALOG About$(),"",0,Mouse%,3,0,0,0,112,1,1
	    END SELECT
          ELSE
            IF Marker% THEN GOTO Menu
	  END IF
END SELECT

IF Been% = 0 THEN
  DIALOG About$(),"",0,Mouse%,3,0,0,0,112,1,1
  Been% = 1
END IF

DO

MouseJump:

GOSUB PrintRoutine

IF CursorRow% < 3 OR CursorRow% > 23 THEN CursorRow% = 3
IF CursorCol% < 2 OR CursorCol% > 79 THEN CursorCol% = 2

GOSUB FileInfo

IF InsertKey% THEN
  LOCATE CursorRow%,CursorCol%,1,0,13    'Block Cursor
ELSE
  LOCATE CursorRow%,CursorCol%,1,11,12   'Normal Cursor
END IF

WHILE NOT INSTAT
  IF Mouse% THEN
    ShowCursor
    Rgt% = 0:Lft% = 0
    Clicked Rgt%,Lft%,MRow%,MCol%
    IF MRow% >= Top% - 2 AND MRow% <= Bottom% + 2 AND MCol% >= LeftSide% - 1 AND MCol% <= RightSide% + 1 THEN
      IF MRow% >= Top% AND MRow% <= Bottom% AND MCol% >= LeftSide% AND MCol% <= RightSide% THEN
        IF Lft% THEN
          CursorRow% = MRow%: CursorCol% = MCol%
          LOCATE CursorRow%,CursorCol%,1
          GOTO MouseJump
        END IF
      ELSE
        SELECT CASE MRow%
          CASE 1
            IF LeftButtonReleased% THEN
              FindMenu MRow%,MCol%,Found%
              IF Found% THEN
                HPointer% = Found%: Marker% = 1: HiLight% = 1: GOTO Menu
              END IF
            END IF
          CASE 2
          CASE 4        'Scroll arrow up
            IF Lft% AND MCol% = 80 THEN
              Editkey% = 26: GOTO KeyBoardRoutine
            END IF
          CASE 5 TO 21  'pageing
          CASE 22       'Scroll arrow down
            IF Lft% AND MCol% = 80 THEN
              Editkey% = 23: GOTO KeyBoardRoutine
            END IF
          CASE 24
            SELECT CASE MCol%
              CASE 62
                IF Lft% THEN
                  Editkey% = -157: GOTO KeyBoardRoutine
                END IF
              CASE 63 TO 78  'Home and End?
              CASE 79
                IF Lft% THEN
                  Editkey% = -155: GOTO KeyBoardRoutine
                END IF
            END SELECT
          CASE 25
            IF LeftButtonReleased% THEN
              ScreenPlus MRow%,MCol%,TextFound$
              SELECT CASE TextFound$
                CASE "F1-Help"
                  Editkey% = -59:GOTO KeyBoardRoutine
                CASE "F2-Save"
                  Editkey% = -60:GOTO KeyBoardRoutine
                CASE "F3-Open"
                  Editkey% = -61:GOTO KeyBoardRoutine
                CASE "F4-Search","Again"
                  Editkey% = -62:GOTO KeyBoardRoutine
                CASE "F6-Load","Macros"
                  Editkey% = -64:GOTO KeyBoardRoutine
              END SELECT
            END IF
        END SELECT
      END IF
    END IF
  END IF
  IF KeyDown% THEN
    LockStatus 25,70,BarAttr%,StatusAttr%
    LOCATE CursorRow%,CursorCol%,1
  END IF
  IF AltKey% THEN HiLight% = 1: GOTO Menu
WEND

Ky$ = INKEY$

IF LEN(Ky$) = 1 THEN
  EditKey% = ASC(Ky$)
ELSE
  EditKey% = -ASC(RIGHT$(Ky$,1))
END IF

KeyBoardRoutine:

SELECT CASE EditKey%
        CASE 1     'Ctrl A
          GOSUB WordLeft
        CASE 3     'Ctrl C
          GOSUB PageDown
        CASE 4     'Ctrl D
          GOSUB MoveRight
        CASE 5     'Ctrl E
          GOSUB MoveUp
        CASE 6     'Ctrl F
          GOSUB WordRight
        CASE 7     'Ctrl G
          GOSUB DeleteKey
	CASE 8     'BackSpace or Ctrl H
          GOSUB BackSpace
        CASE 9     'TabKey
          GOSUB TabKey
        CASE 11    'Ctrl K
          GOSUB CtrlKHelp
          WHILE NOT INSTAT
            IF Mouse% THEN
              ShowCursor
              Rgt% = 0:Lft% = 0
              Clicked Rgt%,Lft%,MRow%,MCol%
              IF Lft% THEN
                CtrlKKey% = 0: GOTO CtrlKRoutine
              END IF
            END IF
          WEND

          Ky$ = INKEY$

          IF LEN(Ky$) = 1 THEN
            CtrlKKey% = ASC(Ky$)
          ELSE
            CtrlKKey% = -ASC(RIGHT$(Ky$,1))
          END IF

          CtrlKRoutine:
          IF Mouse% THEN HideCursor
          RestoreScreen CtrlK$,6,50
          SELECT CASE CtrlKKey%
                 CASE 2,66,98   '^K B Mark Block begin
                   GOSUB MarkBlockBegin
                 CASE 3,67,99   '^K C Copy Block
                   GOSUB CopyBlock
                 CASE 4,68,100  '^K D Save and Exit
                   GOSUB QuitSave
                 CASE 8,72,104  '^K H View Clipboard
                   IF LEN(Block$) THEN
                     GOSUB ViewClipboard
                   ELSE
                     Message$(1) = " Nothing to View "
                     SOUND 50,5
                     DIALOG Message$(),"",1,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
                   END IF
                 CASE 11,75,107  '^K K Mark Block end
                   GOSUB MarkBlockEnd
                 CASE 14,78,110  '^K N Mark Position
                   GOSUB MarkPosition
                 CASE 16,80,112  '^K P Print Block
                   IF LEN(Block$) THEN
                     IF YesNo%("Print Marked Text? (Y or N)",1,10,79,112,1,1) THEN
                       WIDTH "LPT1:",255
                       LPRINT Block$
                     ELSE
                       GOSUB PrintAll
                     END IF
	           ELSE
                     GOSUB PrintAll
                   END IF
                 CASE 17,81,113  '^K Q Quit No Save
                   IF NoSave% THEN
                     IF YesNo%("Quit and Loose Changes to Current File? (Y or N)",1,10,79,112,1,1) THEN
                       GOTO WayOut
                     ELSE
                       GOSUB QuitSave
                     END IF
                   ELSE
                     GOTO WayOut
                   END IF
                 CASE 18,82,114  '^K R Read Block from disk
                   InFile% = 1
                   GOSUB InsertFile
                 CASE 19,83,115  '^K S Save and Edit
                   GOSUB Save
                 CASE 20,84,116  '^K T Mark Single word
                 CASE 22,86,118  '^K V Move Block
                   GOSUB MoveBlock
                 CASE 23,87,119  '^K W Write Block to disk
                   IF LEN(Block$) THEN
                     GOSUB WriteBlockToDisk
                   ELSE
                     Message$(1) = " Clipboard is Empty Nothing to Save "
                     SOUND 50,5
                     DIALOG Message$(),"",1,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
                   END IF
                 CASE 25,89,121  '^K Y Delete Block
                   GOSUB DeleteBlock
                 CASE -59     'F1 key
                   GOSUB KeyBoardHelp
          END SELECT
        CASE 12    'Crtl L
          GOSUB SearchAgain
        CASE 13    'EnterKey
          GOSUB CarriageReturn
        CASE 14    'Ctrl N
          GOSUB InsertLine
        CASE 16    'Ctrl P
          GOSUB ExtendedKeys
        CASE 17    'Ctrl Q
          GOSUB CtrlQHelp
          WHILE NOT INSTAT
            IF Mouse% THEN
              ShowCursor
              Rgt% = 0:Lft% = 0
              Clicked Rgt%,Lft%,MRow%,MCol%
              IF Lft% THEN
                CtrlQKey% = 0: GOTO CtrlQRoutine
              END IF
            END IF
          WEND

          Ky$ = INKEY$

          IF LEN(Ky$) = 1 THEN
            CtrlQKey% = ASC(Ky$)
          ELSE
            CtrlQKey% = -ASC(RIGHT$(Ky$,1))
          END IF

          CtrlQRoutine:
          IF Mouse% THEN HideCursor
          RestoreScreen CtrlQ$,6,50
          SELECT CASE CtrlQKey%

                 CASE 1,65,97   '^Q A Search and Replace
                   GOSUB SearchAndReplace
                 CASE 2,66,98   '^Q B Move to Block begin
                   GOSUB RestoreBlockBegin
                 CASE 3,67,99   '^Q C End of File
                   GOSUB EndOfFile
                 CASE 4,68,100  '^Q D End of line
                   GOSUB LineEnd
                 CASE 5,69,101  '^Q E Top of screen
                   CursorRow% = Top%
                 CASE 6,70,102  '^Q F Search
                   GOSUB FindText
                 CASE 11,75,107  '^Q K Move to Block end
                   GOSUB RestoreBlockEnd
                 CASE 12,76,108  '^Q L Restore line
                   GOSUB RestoreLine
                 CASE 16,80,112  '^Q P Move to previous position
                   GOSUB RestorePosition
                 CASE 18,82,114  '^Q R Start of File
                   GOSUB StartOfFile
                 CASE 19,83,115  '^Q S Start of line
                   GOSUB LineStart
                 CASE 23,87,119  '^Q W Last Message
                   IF Message$(1) = "" THEN Message$(1) = "No Message to Restore"
                   DIALOG Message$(),"",0,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
                 CASE 24,88,120  '^Q X Bottom of screen
                   CursorRow% = Bottom%
                 CASE 25,89,121  '^Q Y Delete to end of line
                   GOSUB DeleteToEndOfLine
                 CASE -59     'F1 key
                   GOSUB KeyBoardHelp
          END SELECT
        CASE 18    'Ctrl R
          GOSUB PageUp
        CASE 19    'Ctrl S
          GOSUB MoveLeft
        CASE 20    'Ctrl T
          GOSUB DeleteWordRight
        CASE 21    'Ctrl U
          GOSUB RestoreLine
        CASE 23    'Ctrl W
          GOSUB ScrollUp
        CASE 24    'Ctrl X
          GOSUB MoveDown
        CASE 25    'Ctrl Y
          GOSUB DeleteLine
        CASE 26    'Ctrl Z
          GOSUB ScrollDown
	CASE 27    'EscKey
        CASE 32 TO 126 'Normal Editing Keys
          GOSUB AddText
        CASE -59   'F1 Key
          GOSUB KeyBoardHelp
        CASE -60   'F2 Key
          GOSUB Save
        CASE -61   'F3 Key
          GOSUB LoadNew
        CASE -62   'F4 Key
          GOSUB SearchAgain
        CASE -64   'F6 Key
          GOSUB LoadMacro
        CASE -65   'F7 Key
          GOSUB PrinterSetup
	CASE -71   'HomeKey
          GOSUB LineStart
        CASE -72   'Up Arrow
          GOSUB MoveUp
        CASE -73   'Page Up
          GOSUB PageUp
	CASE -75   'LeftArrow
          GOSUB MoveLeft
	CASE -77   'RightArrow
          GOSUB MoveRight
	CASE -79   'EndKey
          GOSUB LineEnd
        CASE -80   'Down Arrow
          GOSUB MoveDown
        CASE -81   'Page Down
          GOSUB PageDown
	CASE -82   'InsertKey
          GOSUB ToggleInsert
	CASE -83   'DeleteKey
          GOSUB DeleteKey
        CASE -94   'Ctrl F1
          Mackro$ = Macro$(1)
          GOSUB MacroKeys
        CASE -95   'Ctrl F2
          Mackro$ = Macro$(2)
          GOSUB MacroKeys
        CASE -96   'Ctrl F3
          Mackro$ = Macro$(3)
          GOSUB MacroKeys
        CASE -97   'Ctrl F4
          Mackro$ = Macro$(4)
          GOSUB MacroKeys
        CASE -98   'Ctrl F5
          Mackro$ = Macro$(5)
          GOSUB MacroKeys
        CASE -99   'Ctrl F6
          Mackro$ = Macro$(6)
          GOSUB MacroKeys
        CASE -100  'Ctrl F7
          Mackro$ = Macro$(7)
          GOSUB MacroKeys
        CASE -101  'Ctrl F8
          Mackro$ = Macro$(8)
          GOSUB MacroKeys
        CASE -102  'Ctrl F9
          Mackro$ = Macro$(9)
          GOSUB MacroKeys
        CASE -103  'Ctrl F10
          Mackro$ = Macro$(10)
          GOSUB MacroKeys
        CASE -115  'Ctrl LeftArrow
          GOSUB WordLeft
        CASE -116  'Ctrl RightArrow
          GOSUB WordRight
        CASE -117  'Ctrl End
          CursorRow% = Bottom%
        CASE -118  'Ctrl PgDn
          GOSUB EndOfFile
        CASE -119  'Ctrl Home
          CursorRow% = Top%
        CASE -132  'Ctrl PgUp
          GOSUB StartOfFile
        CASE -155
          GOSUB ScrollLeft
        CASE -157
          GOSUB ScrollRight
        CASE ELSE
	  BEEP

END SELECT

LOOP

WayOut:

DELAY .5
COLOR 7,0
CLS

END
'----------------------------------------------------------------------------
KeyBoardHelp:

BROWSE Home$ + "KEYBOARD.HLP",Mouse%,HelpTextColor%,3,12,23,67,HelpAttr%,1,1

RETURN
'----------------------------------------------------------------------------
MacroKeys:

NoSave% = 1

GOSUB CheckForChange

IF LEN(Mackro$) THEN
  IF ((Offset% + CursorCol%) - LeftSide%) > EditLineLenght% THEN
    Text$ = LEFT$(Text$,EditEndPointer% - 1) + _
    SPACE$(((Offset% + CursorCol%) - LeftSide%) - EditLineLenght%) + _
    Mackro$ + MID$(Text$, EditEndPointer%)
  ELSE
    Text$ = LEFT$(Text$,Character% - 1) + Mackro$ + MID$(Text$, Character%)
  END IF
END IF

RETURN
'----------------------------------------------------------------------------
LoadMacro:

MacroLoaded% = 0
MacroName$(1) = "MACRO1.MAC": MacroName$(2) = "MACRO2.MAC"
MacroName$(3) = "MACRO3.MAC": MacroName$(4) = "MACRO4.MAC"
MacroName$(5) = "MACRO5.MAC": MacroName$(6) = "MACRO6.MAC"
MacroName$(7) = "MACRO7.MAC": MacroName$(8) = "MACRO8.MAC"
MacroName$(9) = "MACRO9.MAC": MacroName$(10) = "MACRO10.MAC"

FOR i% = 1 TO 10
  Test$ = DIR$(Home$ + MacroName$(i%))
  IF LEN(Test$) THEN
    FileNumber% = FREEFILE
    OPEN Home$ + MacroName$(i%) FOR BINARY AS FileNumber%
      IF LOF(FileNumber%) < 2000 THEN
        GET$ FileNumber%, LOF(FileNumber%), Macro$(i%)
        MacroLoaded% = 1
      END IF
    CLOSE FileNumber%
  END IF
NEXT i%

IF MacroLoaded% THEN
  COLOR 4,7: LOCATE 25,46,0: PRINT "Ctrl F1 to F10";
  COLOR 0,7: LOCATE 25,60,0: PRINT "-Macro#";
END IF

RETURN
'----------------------------------------------------------------------------
WordLeft:

Character% = EditStartPointer% + Offset% + (CursorCol% - LeftSide%)
LeftWord% = Character%

IF EditStartPointer% THEN
  DO
    IF LeftWord% > 1 THEN
      IF LeftWord% = EditStartPointer% AND LeftWord% > 1 THEN GOTO LineAbove
      DECR LeftWord%
    ELSE
      Offset% = 0: CursorCol% = LeftSide%
      EXIT
    END IF
    IF INSTR(MID$(Text$,LeftWord%,1),ANY SearchFor$) THEN
      DO
        IF LeftWord% > 1 THEN
          DECR LeftWord%
        ELSE
          Offset% = 0: CursorCol% = LeftSide%
          EXIT,EXIT
        END IF
        IF INSTR(MID$(Text$,LeftWord%,1),ANY DeLimiter$) THEN
          DO
          INCR LeftWord%
            IF INSTR(MID$(Text$,LeftWord%,1),ANY SearchFor$) THEN
              FOR l% = LeftWord% + 1 TO Character%
                GOSUB MoveLeft
              NEXT l%
              EXIT,EXIT,EXIT
            END IF
          LOOP UNTIL LeftWord% = Character%
        END IF
      LOOP
    END IF
  LOOP
END IF

RETURN
'----------------------------------------------------------------------------
LineAbove:

GOSUB MoveUp
GOSUB PrintRoutine
GOSUB LineEnd
GOTO WordLeft

'----------------------------------------------------------------------------
WordRight:

Character% = EditStartPointer% + Offset% + (CursorCol% - LeftSide%)
RightWord% = Character%

IF Character% < EditEndPointer% + 1 AND Character% < LEN(Text$) - 2 THEN
  RightWord% = INSTR(RightWord%,Text$,ANY DeLimiter$)
  IF RightWord% THEN
    RightWord% = INSTR(RightWord%,Text$,ANY SearchFor$)
    IF RightWord% < EditEndPointer% THEN
      FOR i% = Character% TO RightWord% - 1
        GOSUB MoveRight
      NEXT i%
    ELSE  'search for blank lines
      BlankLine% = 0
      FOR i% = EditEndPointer% + 1 TO RightWord%
        IF MID$(Text$,i%,1) = CHR$(10) THEN
          INCR BlankLine%
          GOSUB MoveDown
        END IF
      NEXT i%
      IF BlankLine% THEN
        CursorCol% = ((RightWord% - EditEndPointer%) - (2 * BlankLine%)) + 2
        IF CursorCol% > RightSide% THEN
          Offset% = (CursorCol% - RightSide%) + LeftSide%
          CursorCol% = RightSide% - 2
        ELSE
          Offset% = 0
        END IF
      ELSE
        CursorCol% = RightWord% - EditEndPointer%
        IF CursorCol% > RightSide% THEN
          Offset% = (CursorCol% - RightSide%) + LeftSide%
          CursorCol% = RightSide% - 2
        ELSE
          Offset% = 0
        END IF
        GOSUB MoveDown
      END IF
    END IF
  END IF
END IF

RETURN
'----------------------------------------------------------------------------
MarkWordRight:

RETURN
'----------------------------------------------------------------------------
AddText:

NoSave% = 1

GOSUB CheckForChange

IF Tabs% = 0 THEN
  IF ((Offset% + CursorCol%) - LeftSide%) > EditLineLenght% THEN
    Text$ = LEFT$(Text$,EditEndPointer% - 1) + _
    SPACE$(((Offset% + CursorCol%) - LeftSide%) - EditLineLenght%) + _
    MID$(Text$, EditEndPointer%)
  END IF
END IF

'INSERT OR OVERTYPE THE CHARACTER

IF ISFALSE InsertKey% THEN
  Text$ = LEFT$(Text$,Character% - 1) + Ky$ + MID$(Text$,Character%)
ELSE
  IF MID$(Text$,Character%,1) = CHR$(13) THEN
    Text$ = LEFT$(Text$,Character% - 1) + Ky$ + MID$(Text$,Character%)
  ELSE
    MID$(Text$,Character%,1) = Ky$
  END IF
END IF

'NOW ADJUST THE CURSOR POSITION

IF CursorCol% < 79 THEN
  INCR CursorCol%
ELSE
  INCR Offset%
END IF

RETURN
'----------------------------------------------------------------------------
ExtendedKeys:

Only$ = "1234567890"
Num$ = "   "
IF Mouse% THEN HideCursor
SAVESCREEN CtrlScreen$,3,4,22,76,1
POPWIND "ASCII Table Quick Reference",3,4,17,76,112,1,1
COLOR 0,7
LOCATE 4,6,0: PRINT "001 " + CHR$(1) + "   004 " + CHR$(4) + "   007 " + CHR$(7) + "   014 " + CHR$(14) + "   017 " + CHR$(17) + "   020 " + CHR$(20) + "   023 " + CHR$(23) + "   026 " + CHR$(26) + "   029 " + CHR$(29);
LOCATE 5,6,0: PRINT "002 " + CHR$(2) + "   005 " + CHR$(5) + "   011 " + CHR$(11) + "   015 " + CHR$(15) + "   018 " + CHR$(18) + "   021 " + CHR$(21) + "   024 " + CHR$(24) + "   027 " + CHR$(27) + "   030 " + CHR$(30);
LOCATE 6,6,0: PRINT "003 " + CHR$(3) + "   006 " + CHR$(6) + "   012 " + CHR$(12) + "   016 " + CHR$(16) + "   019 " + CHR$(19) + "   022 " + CHR$(22) + "   025 " + CHR$(25) + "   028 " + CHR$(28) + "   031 " + CHR$(31);
LOCATE 8,6,0: PRINT "174    183    192    201    210    219    228    237    246 ";
LOCATE 9,6,0: PRINT "175    184    193    202    211    220    229    238    247 ";
LOCATE 10,6,0: PRINT "176    185    194    203    212    221    230    239    248 ";
LOCATE 11,6,0: PRINT "177    186    195    204    213    222    231    240    249 ";
LOCATE 12,6,0: PRINT "178    187    196    205    214    223    232    241    250 ";
LOCATE 13,6,0: PRINT "179    188    197    206    215    224    233    242    251 ";
LOCATE 14,6,0: PRINT "180    189    198    207    216    225    234    243    252 ";
LOCATE 15,6,0: PRINT "181    190    199    208    217    226    235    244    253 ";
LOCATE 16,6,0: PRINT "182    191    200    209    218    227    236    245    254 ";

POPWIND Title$,20,55,22,76,112,1,1
COLOR 0,7: LOCATE 21,57,0: PRINT "Extended Key #";
LINEEDIT Only$,Num$,0,MouseRow%,MouseCol%,176,21,72,Editkey%,14
RESTORESCREEN CtrlScreen$,3,4
IF LEN(RTRIM$(Num$)) THEN
  IF VAL(Num$) > 254 THEN
    Message$(1) = " Sorry that Key is not supported "
    SOUND 50,5
    DIALOG Message$(),"",1,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
  ELSE
    Ky$ = CHR$(VAL(Num$))
    IF INSTR(Ky$,ANY CHR$(9,10,13)) THEN
      Message$(1) = " Sorry No Tabs, Linefeeds, or Carriage Returns "
      SOUND 50,5
      DIALOG Message$(),"",1,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
    ELSE
      GOSUB AddText
    END IF
  END IF
END IF

RETURN
'----------------------------------------------------------------------------
InsertLine:

NoSave% = 1

GOSUB CheckForChange

o% = Offset%: c% = CursorCol%: r% = CursorRow%
GOSUB CarriageReturn
Offset% = o%: CursorCol% = c%: CursorRow% = r%

RETURN
'----------------------------------------------------------------------------
CarriageReturn:

NoSave% = 1

GOSUB CheckForChange

IF ((Offset% + CursorCol%) - LeftSide%) > EditLineLenght% THEN
  Text$ = LEFT$(Text$,EditEndPointer% - 1) + CHR$(13) + CHR$(10) + _
  MID$(Text$,EditEndPointer%)
ELSE
  Text$ = LEFT$(Text$,Character% - 1) + CHR$(13) + CHR$(10) + MID$(Text$,Character%)
END IF

CursorCol% = LeftSide%

IF Offset% > 0 THEN Offset%=0
IF CursorRow% < 23 THEN
  INCR CursorRow%
ELSE
  IF TempPointer% < LEN(Text$) THEN
    Pointer% = INSTR(Pointer%, Text$, CHR$(13)) + 2
  END IF
END IF

RETURN
'----------------------------------------------------------------------------
TabKey:

NoSave% = 1

GOSUB CheckForChange

IF ((Offset% + CursorCol%) - LeftSide%) > EditLineLenght% THEN
  Tabs% = 8 - (((Offset% + CursorCol%) - LeftSide%) MOD 8)
  Text$ = LEFT$(Text$,EditEndPointer% - 1) + _
  SPACE$(((Offset% + CursorCol% + Tabs%) - LeftSide%) - EditLineLenght%) + _
  MID$(Text$,EditEndPointer%)
  GOSUB PrintRoutine
  CursorCol% = (LeftSide% + EditLineLenght%) - Offset%
  IF CursorCol% > 79 THEN GOSUB LineEnd
ELSE
  Tabs% = 8 - (((Offset% + CursorCol%) - LeftSide%) MOD 8)
  FOR i% = 1 TO Tabs%
    Ky$ = CHR$(32): GOSUB AddText
  NEXT i%
END IF

Tabs% = 0

RETURN
'----------------------------------------------------------------------------
DeleteKey:

NoSave% = 1

GOSUB CheckForChange

IF Character% =< EditEndPointer% THEN
  IF LEN(Text$) THEN
    IF MID$(Text$,Character%,1) = CHR$(13) THEN
      Text$ = LEFT$(Text$,Character% - 1) + MID$(Text$,Character% + 2)
    ELSE
      Text$ = LEFT$(Text$,Character% - 1) + MID$(Text$,Character% + 1)
    END IF
  END IF
END IF

RETURN
'----------------------------------------------------------------------------
ToggleInsert:

IF InsertKey% THEN
  LOCATE ,,,0,13    'Block Cusor
ELSE
  LOCATE ,,,11,12   'Normal Cursor
END IF

RETURN
'----------------------------------------------------------------------------
LineStart:

IF Offset% THEN
  Offset% = 0
  CursorCol% = LeftSide%
ELSE
  CursorCol% = LeftSide%
END IF

RETURN
'----------------------------------------------------------------------------
LineEnd:

CursorCol% = LeftSide% + EditLineLenght%

IF CursorCol% > RightSide% THEN
  CursorCol% = RightSide% - 1
  Offset% = (EditLineLenght% - RightSide%) + (LeftSide% + 1)
ELSE
  Offset% = 0
END IF

RETURN
'----------------------------------------------------------------------------
StartOfFile:

Pointer% = 1: Offset% = 0: CursorRow% = Top%: CursorCol% = LeftSide%

RETURN
'----------------------------------------------------------------------------
EndOfFile:

IF EditEndPointer% < LEN(Text$) - 2 THEN
  Pointer% = LEN(Text$): Count% = 0: RowCount% = Top% - 1

  FOR PageLenght% = Top% TO Bottom%
    IF Pointer% > 1 THEN
      INCR RowCount%
      DECR Pointer%,2
      DO
        DECR Pointer%
        IF PageLenght% = Top% THEN INCR Count%
      LOOP UNTIL MID$(Text$, Pointer%, 1) = CHR$(13) OR Pointer% = 1
      IF Pointer% > 1 THEN INCR Pointer%,2
    ELSE
      EXIT FOR
    END IF
  NEXT PageLenght%

  IF Count% > 78 THEN
    Offset% = Count% - 78: CursorCol% = RightSide%: CursorRow% = RowCount%
  ELSE
    Offset% = 0: CursorCol% = Count% + 1: CursorRow% = RowCount%
  END IF
ELSE
  GOSUB LineEnd
END IF

RETURN
'----------------------------------------------------------------------------
BackSpace:

NoSave% = 1

GOSUB CheckForChange

IF Offset% + (CursorCol% - LeftSide%) > EditLineLenght% THEN
  Adjust% = 0
ELSE
  Adjust% = 1
END IF

IF Character% > 2 AND Offset% = 0 AND CursorCol% = LeftSide% THEN WrapUp% = 1

IF CursorCol% > 2 THEN
  DECR CursorCol%: DECR Character%: NormalLine% = 1
ELSE
  IF Offset% THEN DECR Offset%: DECR Character%: NormalLine% = 1
END IF

IF Adjust% THEN
  IF WrapUp% THEN
    Text$ = LEFT$(Text$,Character% - 3) + MID$(Text$,Character%)
    Ptr% = EditStartPointer%: Count% = 0: WrapUp% = 0:

    DECR Ptr%,2
    DO
      DECR Ptr%
      IF Ptr% = 0 THEN EXIT LOOP
      IF Mid$(Text$,Ptr%,1) = CHR$(13) OR Ptr% = 1 THEN
        INCR Count%
        EXIT LOOP
      ELSE
        INCR Count%
      END IF
    LOOP

    IF Ptr% = 1 AND CursorRow% = Top% + 1 THEN INCR Count%,2

    IF Count% > 78 THEN
      Offset% = Count% - 79: CursorCol% = RightSide%
    ELSE
      Offset% = 0: CursorCol% = Count%
    END IF
    IF CursorRow% > Top% + 2 THEN
      DECR CursorRow%
    ELSE
      IF Pointer% > 1 THEN
        GOSUB ScrollDown
      ELSE
        DECR CursorRow%
      END IF
    END IF
  ELSE
    IF NormalLine% THEN
      NormalLine% = 0
      IF LEN(Text$) AND MID$(Text$,Character%,1) <> CHR$(13) AND _
      MID$(Text$,Character%,1) <> CHR$(10) THEN_
      Text$ = LEFT$(Text$,Character% - 1) + MID$(Text$,Character% + 1)
    END IF
  END IF
END IF

RETURN
'----------------------------------------------------------------------------
ScrollRight:

IF Offset% THEN DECR Offset%

RETURN
'----------------------------------------------------------------------------
ScrollLeft:

INCR Offset%

RETURN
'----------------------------------------------------------------------------
MoveRight:

  IF CursorCol% < 79 THEN
    INCR CursorCol%
  ELSE
    INCR Offset%
  END IF

RETURN
'----------------------------------------------------------------------------
MoveLeft:

IF CursorCol% > 2 THEN
  DECR CursorCol%
ELSE
  IF Offset% THEN DECR Offset%
END IF

RETURN
'----------------------------------------------------------------------------
MoveUp:

IF CursorRow% > 3 THEN
  DECR CursorRow%
ELSE
  GOSUB ScrollDown
END IF

RETURN
'----------------------------------------------------------------------------
MoveDown:

IF CursorRow% < 23 THEN
  INCR CursorRow%
ELSE
  GOSUB ScrollUp
END IF

RETURN
'----------------------------------------------------------------------------
PageUp:

FOR PageLenght% = Top% TO (Bottom% - 1)
  IF Pointer% > 1 THEN
    GOSUB ScrollDown
  ELSE
    EXIT FOR
  END IF
NEXT PageLenght%

RETURN
'----------------------------------------------------------------------------
PageDown:

Oldptr% = TempPointer%

IF ISFALSE LastLine% THEN
  FOR PageLenght% = Top% TO (Bottom% - 1)
    GOSUB ScrollUp
    TempPointer% = Pointer%
    IF Pointer% = 0 THEN
      Pointer% = Oldptr%
      EXIT FOR
    END IF
  NEXT PageLenght%
END IF

RETURN
'----------------------------------------------------------------------------
ScrollUp:

IF TempPointer% < LEN(Text$) THEN
  Pointer% = INSTR(Pointer%, Text$, CHR$(13)) + 2
END IF

RETURN
'----------------------------------------------------------------------------
ScrollDown:

IF Pointer% > 1 THEN
  DECR Pointer%,2
  DO
    DECR Pointer%
  LOOP UNTIL MID$(Text$, Pointer%, 1) = CHR$(13) OR Pointer% = 1
  IF Pointer% > 1 THEN INCR Pointer%,2
END IF

RETURN
'----------------------------------------------------------------------------
RestoreBlockBegin:

IF BlockBeginPointer% THEN
  Pointer% = BlockBeginPointer%: Offset% = BlockBeginOffset%
  CursorRow% = BlockBeginCursorRow%: CursorCol% = BlockBeginCursorCol%
ELSE
  Message$(1) = "Beginning of Block not Marked"
  SOUND 50,5
  DIALOG Message$(),"",1,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
END IF

RETURN
'----------------------------------------------------------------------------
RestoreBlockEnd:

IF BlockEndPointer% THEN
  Pointer% = BlockEndPointer%: Offset% = BlockEndOffset%
  CursorRow% = BlockEndCursorRow%: CursorCol% = BlockEndCursorCol%
ELSE
  Message$(1) = "End of Block not Marked"
  SOUND 50,5
  DIALOG Message$(),"",1,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
END IF

RETURN
'----------------------------------------------------------------------------
MarkBlockBegin:

Character% = EditStartPointer% + Offset% + (CursorCol% - LeftSide%)
IF Character% <= EditEndPointer% THEN
  BlockStart% = EditStartPointer% + Offset% + (CursorCol% - LeftSide%)
  BlockBeginPointer% = Pointer%: BlockBeginOffset% = Offset%
  BlockBeginCursorRow% = CursorRow%: BlockBeginCursorCol% = CursorCol%
  IF BlockEnd% > BlockStart% THEN
    Change% = 0
    SOUND 2500,.5: SOUND 3000,.5: SOUND 3500,.5
    Block$ = MID$(Text$,BlockStart%,BlockEnd%-BlockStart%)
  END IF
ELSE
  Message$(1) = "Cursor is Past the End of the Line!"
  SOUND 50,5
  DIALOG Message$(),"",1,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
END IF

RETURN
'----------------------------------------------------------------------------
MarkBlockEnd:

Character% = EditStartPointer% + Offset% + (CursorCol% - LeftSide%)
IF Character% <= EditEndPointer% THEN
  BlockEnd% = EditStartPointer% + Offset% + (CursorCol% - LeftSide%)
  BlockEndPointer% = Pointer%: BlockEndOffset% = Offset%
  BlockEndCursorRow% = CursorRow%: BlockEndCursorCol% = CursorCol%
  IF BlockEnd% > BlockStart% THEN
    Change% = 0
    SOUND 2500,.5: SOUND 3000,.5: SOUND 3500,.5
    Block$ = MID$(Text$,BlockStart%,BlockEnd% - BlockStart%)
  END IF
ELSE
  Message$(1) = "Cursor is Past the End of the Line!"
  SOUND 50,5
  DIALOG Message$(),"",1,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
END IF

RETURN
'----------------------------------------------------------------------------
CopyBlock:

NoSave% = 1: Change% = 0

IF LEN(Block$) THEN
  OldBlock$ = ""
  Character% = EditStartPointer% + Offset% + (CursorCol% - LeftSide%)
  IF ((Offset% + CursorCol%) - LeftSide%) > EditLineLenght% THEN
    Text$ = LEFT$(Text$,EditEndPointer% - 1) + _
    SPACE$(((Offset% + CursorCol%) - LeftSide%) - EditLineLenght%) + _
    Block$ + MID$(Text$, EditEndPointer%)
  ELSE
    Text$ = LEFT$(Text$,Character% - 1) + Block$ + MID$(Text$, Character%)
  END IF
  BlockStart% = Character%: BlockEnd% = Character% + LEN(Block$)
END IF

RETURN
'----------------------------------------------------------------------------
MoveBlock:

NoSave% = 1

IF LEN(Block$) THEN
  IF Block$ = OldBlock$ THEN
    Message$(1) = "You Cannot Move A Deleted Block use Copy Instead"
    SOUND 50,5
    DIALOG Message$(),"",1,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
  ELSE
    IF Change% = 0 THEN
      BlockBeginPointer% = 0: BlockEndPointer% = 0
      Character% = EditStartPointer% + Offset% + (CursorCol% - LeftSide%)
      IF Character% > EditEndPointer% THEN Character% = EditEndPointer%
      IF Character% < BlockStart% THEN
        Text$ = LEFT$(Text$,BlockStart% - 1) + MID$(Text$,BlockEnd%)
        Text$ = LEFT$(Text$,Character% - 1) + Block$ + MID$(Text$,Character%)
        BlockStart% = Character%: BlockEnd% = Character% + LEN(Block$)
      ELSEIF Character% > BlockEnd% THEN
        Text$ = LEFT$(Text$,Character% - 1) + Block$ + MID$(Text$,Character%)
        Text$ = LEFT$(Text$,BlockStart% - 1) + MID$(Text$,BlockEnd%)
        BlockStart% = Character%: BlockEnd% = Character% + LEN(Block$)
      END IF
    ELSE
      Message$(1) = "Pointers are no longer Valid! Remark Block"
      SOUND 50,5
      DIALOG Message$(),"",1,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
    END IF
  END IF
END IF

RETURN
'----------------------------------------------------------------------------
DeleteWordRight:

NoSave% = 1

GOSUB CheckForChange

IF Character% < EditEndPointer% THEN
  Temp% = (INSTR(Character% + 1,Text$,ANY CHR$(32,10)) + 1) - Character%
  SaveLine$ =  MID$(Text$,Character%,temp%) + CHR$(255) + SaveLine$
  Text$ = LEFT$(Text$,Character% - 1) + MID$(Text$,Character% + Temp%)
  IF Text$ = "" THEN Text$ = CHR$(13) + CHR$(10)
END IF

RETURN
'----------------------------------------------------------------------------
RestoreLine:

NoSave% = 1

GOSUB CheckForChange

IF LEN(SaveLine$) THEN
  Temp$ = EXTRACT$(SaveLine$,CHR$(255))
  IF LEN(Temp$) THEN
    SaveLine$ = MID$(SaveLine$,INSTR(SaveLine$,CHR$(255)) + 1)
    IF ((Offset% + CursorCol%) - LeftSide%) > EditLineLenght% THEN
      Text$ = LEFT$(Text$,EditEndPointer% - 1) + _
      SPACE$(((Offset% + CursorCol%) - LeftSide%) - EditLineLenght%) + _
      Temp$ + MID$(Text$, EditEndPointer%)
    ELSE
      Text$ = LEFT$(Text$,Character% - 1) + Temp$ + MID$(Text$, Character%)
    END IF
  ELSE
    IF SaveLine$ = Temp$ + CHR$(255) THEN SaveLine$ = ""
  END IF
END IF

RETURN
'----------------------------------------------------------------------------
DeleteToEndOfLine:

NoSave% = 1

GOSUB CheckForChange

IF Character% < EditEndPointer% THEN
  i% = ((EditStartPointer% + Offset% + CursorCol%) - LeftSide%)
  SaveLine$ = MID$(Text$,i%,EditEndPointer% - i%) + CHR$(255) + SaveLine$
  Text$ = LEFT$(Text$,i% - 1) + MID$(Text$,EditEndPointer%)
END IF

RETURN
'----------------------------------------------------------------------------
DeleteLine:

NoSave% = 1

GOSUB CheckForChange

SaveLine$ = MID$(Text$,EditStartPointer%,EditEndPointer% - EditStartPointer%) + _
CHR$(13) + CHR$(10) + CHR$(255) + SaveLine$
Text$ = LEFT$(Text$,EditStartPointer% - 1) + MID$(Text$,EditEndPointer% + 2)
IF Text$ = "" THEN Text$ = CHR$(13) + CHR$(10)

RETURN
'----------------------------------------------------------------------------
CheckForChange:

Character% = EditStartPointer% + Offset% + (CursorCol% - LeftSide%)

IF BlockEnd% THEN
  IF Character% < BlockEnd% THEN Change% = 1
END IF

RETURN
'----------------------------------------------------------------------------
DeleteBlock:

NoSave% = 1

IF LEN(Block$) THEN
  IF Change% = 0 THEN
    BlockEndPointer% = 0
    IF Block$ = OldBlock$ THEN
      Message$(1) = "You have Deleted that Block Already !!!"
      SOUND 50,5
      DIALOG Message$(),"",1,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
    ELSE
      OldBlock$ = Block$
      Text$ = LEFT$(Text$,BlockStart% - 1) + MID$(Text$,BlockEnd%)
      IF Text$ = "" THEN Text$ = CHR$(13) + CHR$(10)
    END IF
  ELSE
    Message$(1) = "Pointers are no longer Valid! Remark Block"
    SOUND 50,5
    DIALOG Message$(),"",1,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
  END IF
END IF

RETURN
'----------------------------------------------------------------------------
FindText:

SearchPointer% = Pointer%
TextOne$ = SPACE$(45)
EditBox "Find what:",TextOne$,Allow$,Mouse%,176,6,79,14,112,1,1
TextOne$ = RTRIM$(TextOne$)

IF LEN(TextOne$) THEN GOSUB SearchAgain

RETURN
'----------------------------------------------------------------------------
SearchAndReplace:

SearchPointer% = Pointer%
TextOne$ = SPACE$(40)
TextTwo$ = SPACE$(40)
DoubleBox "Find what:","Replace with:",TextOne$,TextTwo$,Allow$,Mouse%,255,176,6,79,14,112,1,1
TextOne$ = RTRIM$(TextOne$)
TextTwo$ = RTRIM$(TextTwo$)

IF LEN(TextOne$) AND LEN(TextTwo$) THEN
  DO
    GOSUB SearchAgain
    IF TestPointer% THEN
      GOSUB PrintRoutine
      GOSUB FileInfo
      LOCATE 3,CursorCol%,0: COLOR 31,1: PRINT TextOne$;
      MayBe "Replace the Hilighted Text ? (Y or N or Esc)",Answer%,Mouse%,10,79,112%,1,1
      SELECT CASE Answer%
             CASE 0
               EXIT SELECT
             CASE 1
               NoSave% = 1
               GOSUB CheckForChange
               Text$ = LEFT$(Text$,TestPointer% - 1) + TextTwo$ + MID$(Text$,(TestPointer% + LEN(TextOne$)))
               GOSUB PrintRoutine
               DELAY .5
             CASE 2
               RETURN
      END SELECT
    END IF
  LOOP WHILE TestPointer%
ELSE
  Message$(1) = "Both Lines must contain Text"
  IF LEN(TextOne$) OR LEN(TextTwo$) THEN SOUND 50,5: DIALOG Message$(),"",1,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
END IF

RETURN
'----------------------------------------------------------------------------
SearchAgain:

Position% = 0

IF LEN(TextOne$) THEN
  IF SearchPointer% THEN
    SearchPointer% = INSTR(SearchPointer%,Text$,TextOne$)
    IF ISFALSE SearchPointer% THEN
      Message$(1) = "Text Not Found or No More Matches"
      SOUND 50,5
      DIALOG Message$(),"",1,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
      TestPointer% = SearchPointer%
      RETURN
    END IF
  END IF
ELSE
  Message$(1) = "No Text to Search For"
  SOUND 50,5
  DIALOG Message$(),"",1,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
  RETURN
END IF

TestPointer% = SearchPointer%

IF SearchPointer% THEN
    DO
      IF SearchPointer% > 1 THEN DECR SearchPointer%: INCR Position%
    LOOP UNTIL MID$(Text$, SearchPointer%, 1) = CHR$(13) OR SearchPointer% = 1
    IF SearchPointer% > 1 THEN
      INCR SearchPointer%,2
    ELSE
      IF ISFALSE Add% THEN
        INCR Position%,2
      ELSE
        INCR SearchPointer%,2
      END IF
    END IF
END IF

IF SearchPointer% THEN
  Pointer% = SearchPointer%
  INCR SearchPointer%,(Position% + LEN(TextOne$))
  IF Position% + LEN(TextOne$) > 78 THEN
    Offset% = (Position% + LEN(TextOne$)) - 78
    CursorCol% = 78 - LEN(TextOne$)
  ELSE
    Offset% = 0
    CursorCol% = Position%
  END IF
  CursorRow% = Top%
END IF

RETURN
'----------------------------------------------------------------------------
MarkPosition:

MarkedPointer% = Pointer%: MarkedOffset% = Offset%
MarkedCursorRow% = CursorRow%: MarkedCursorCol% = CursorCol%

RETURN
'----------------------------------------------------------------------------
RestorePosition:

IF MarkedPointer% THEN
  Pointer% = MarkedPointer%: Offset% = MarkedOffset%
  CursorRow% = MarkedCursorRow%: CursorCol% = MarkedCursorCol%
ELSE
  Message$(1) = "Previous Position Not Marked"
  SOUND 50,5
  DIALOG Message$(),"",1,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
END IF

RETURN
'----------------------------------------------------------------------------
DosShell:

MEMPACK
IF Mouse% THEN HideCursor
SaveScreen Dos$,1,1,25,80,0
COLOR 7,0: CLS: LOCATE 1,1,0
PRINT "Type EXIT to Return to DNAWrite";
SHELL
IF Mouse% THEN HideCursor
RestoreScreen Dos$,1,1

RETURN
'----------------------------------------------------------------------------
FileInfo:

FileSize% = LEN(Text$)
ColNumber% = ((Offset% + CursorCol%) - LeftSide%)
LineNumber% = 0

FOR i% = 1 TO EditEndPointer%
  j% = INSTR(i%,Text$,CHR$(13))
  IF j% THEN INCR LineNumber%: i% = j%
NEXT i%

COLOR 7,1
LOCATE 2,2,0: PRINT RIGHT$(STRING$(77,196) + " " + CurrentName$ + " ",77);
LOCATE 24,9,0: PRINT LEFT$(STR$(LineNumber%) + "   ",4);
LOCATE 24,18,0: PRINT LEFT$(STR$(ColNumber% + 1) + "   ",4);
IF FileSize% > 31999 THEN COLOR 31,1
LOCATE 24,42,0: PRINT LEFT$(STR$(FileSize%) + "     ",6);

RETURN
'----------------------------------------------------------------------------
CtrlKHelp:

IF Mouse% THEN HideCursor
SaveScreen CtrlK$,6,50,21,76,1
Popwind "Control - K",6,50,21,76,112,1,1
COLOR 0,7
LOCATE 7,52,0: PRINT "B  mark block begin";
LOCATE 8,52,0: PRINT "K  mark block end";
LOCATE 9,52,0: PRINT "T  mark single word";
LOCATE 10,52,0: PRINT "C  copy block";
LOCATE 11,52,0: PRINT "V  move block";
LOCATE 12,52,0: PRINT "Y  delete block";
LOCATE 13,52,0: PRINT "R  read block from file";
LOCATE 14,52,0: PRINT "W  save marked block";
LOCATE 15,52,0: PRINT "H  view clipboard";
LOCATE 16,52,0: PRINT "P  print block";
LOCATE 17,52,0: PRINT "D  save and exit";
LOCATE 18,52,0: PRINT "S  save";
LOCATE 19,52,0: PRINT "Q  quit without saving";
LOCATE 20,52,0: PRINT "N  set place marker";

RETURN
'----------------------------------------------------------------------------
CtrlQHelp:

IF Mouse% THEN HideCursor
SaveScreen CtrlQ$,6,50,21,76,1
Popwind "Control - Q",6,50,21,76,112,1,1

COLOR 0,7
LOCATE 7,52,0: PRINT "S  beginning of line";
LOCATE 8,52,0: PRINT "D  end of line";
LOCATE 9,52,0: PRINT "E  top of window";
LOCATE 10,52,0: PRINT "X  bottom of window";
LOCATE 11,52,0: PRINT "R  top of file";
LOCATE 12,52,0: PRINT "C  end of file";
LOCATE 13,52,0: PRINT "B  beginning of block";
LOCATE 14,52,0: PRINT "K  end of block";
LOCATE 15,52,0: PRINT "P  last cursor position";
LOCATE 16,52,0: PRINT "W  restore last message";
LOCATE 17,52,0: PRINT "Y  delete to line end";
LOCATE 18,52,0: PRINT "L  restore line";
LOCATE 19,52,0: PRINT "F  search";
LOCATE 20,52,0: PRINT "A  search and replace";

RETURN
'----------------------------------------------------------------------------
PrintRoutine:

IF Mouse% THEN HideCursor

 TempPointer% = Pointer% : Row% = Top% : LastLine% = 0: FirstTime% = 1
 IF RIGHT$(Text$,2) <> CHR$(13) + CHR$(10) THEN Text$ = Text$ + CHR$(13) + CHR$(10)
 DO
  EndOfLine% = INSTR(MID$(Text$,TempPointer%),CHR$(13))
    IF EndOfLine% = 0 THEN
      EndOfLine% = LEN(Text$)
      IF LastLine% = 0 THEN
        LastLine% = Row% - 1
        DECR Row%
        EndOfLine% = LastEndOfLine%
        TempPointer% = LastPointer%
      END IF
      IF CursorRow% > LastLine% THEN  CursorRow% = LastLine%
    ELSE
      DECR EndOfLine%   ' DECR: do not show the CR
    END IF
  LastPointer% = TempPointer%: LastEndOfLine% = EndOfLine%
  CurrentLine$ = MID$(Text$, TempPointer%,EndOfLine%)
  IF CurrentLine$ = CHR$(10) THEN CurrentLine$ = ""
  IF Row% = CursorRow% THEN
    EditLineLenght% = LEN(CurrentLine$)
    EditStartPointer% = TempPointer%
    EditEndPointer% = TempPointer% + EndOfLine%
  END IF
  QPRINT Row%, LeftSide%, MID$(CurrentLine$ + SPACE$(TextWidth% + Offset%), 1 + Offset% , TextWidth%), TextAttr%
  TempPointer% = INSTR(TempPointer%,Text$, CHR$(13)) + 2  ' +2 for CRLF
  IF Pointer% = 1 AND FirstTime% THEN
    FirstTime% = 0
    IF TempPointer% > 5 THEN Add% = 0 ELSE Add% = 1
  END IF
  IF TempPointer% = 2 THEN TempPointer% = LEN(Text$)
  INCR Row%
  IF Row% > Bottom% THEN EXIT LOOP
 LOOP

RETURN
'----------------------------------------------------------------------------
Save:

IF LEN(CurrentName$) THEN
  FileNumber% = FREEFILE
  OPEN CurrentName$ FOR OUTPUT AS #FileNumber%
  PRINT #FileNumber%,Text$;
  CLOSE #FileNumber%
  NoSave% = 0
END IF

RETURN
'----------------------------------------------------------------------------
SaveAs:

Kurrent$ = CurrentName$

FOR i% = 1 TO LEN(Kurrent$)      'get the path and file name
  Test$ = RIGHT$(Kurrent$,i%)
  IF LEFT$(Test$,1) = CHR$(92) THEN
    FindPath$ = LEFT$(Kurrent$,LEN(Kurrent$) - (i% - 1))
    EXIT FOR
  END IF
NEXT i%

DefaultName$ = LTRIM$(Kurrent$,FindPath$)

WriteToBox ReturnedFile$,DefaultName$,Mouse%,112,14,79,1,1

IF LEN(ReturnedFile$) THEN CurrentName$ = ReturnedFile$: GOSUB Save

RETURN
'----------------------------------------------------------------------------
QuitSave:

GOSUB SaveAll
GOTO WayOut

RETURN
'----------------------------------------------------------------------------
PrinterSetup:

PrnCfg$ = Home$ + "PRINTER.CFG"
Count% = 0

Test$ = DIR$(PrnCfg$)

IF LEN(Test$) THEN
  OPEN PrnCfg$ FOR INPUT AS #1
  DO
    INCR Count%
    LINE INPUT #1, Prnter$(Count%)
    LINE INPUT #1, Action$(Count%)
  LOOP WHILE NOT EOF(1)
  CLOSE #1
ELSE
  RETURN
END IF

SCROLLBOX Prnter$(),Instruction$,"Printer",Mouse%,10,Tag%,1,0,14,112,0,0,1,1

IF LEN(Instruction$) THEN
  TagCount% = 0
  IF Tag% THEN
    Temp$ = LTRIM$(Instruction$,CHR$(Tag%))
  ELSE
    Temp$ = LTRIM$(Instruction$)
  END IF
  DO
    INCR TagCount%
    b% = INSTR(Temp$,ANY CHR$(Tag%))
    IF b% = 0 THEN
      Compare$(TagCount%) = Temp$
    ELSE
      Compare$(TagCount%) = LEFT$(Temp$,b% - 1)
    END IF
    Temp$ = LTRIM$(Temp$,Compare$(TagCount%))
    Temp$ = LTRIM$(Temp$,CHR$(Tag%))
  LOOP UNTIL Compare$(TagCount%) = ""
  DECR TagCount%
  FOR i% = 1 TO TagCount%
    j% = 0
    DO
      INCR j%
      IF Prnter$(j%) = Compare$(i%) THEN
        IF Immbed% THEN
          FOR k% = 1 TO LEN(Action$(j%))
            a$ = LEFT$(Action$(j%),k%)
            b$ = RIGHT$(a$,1)
            Ky$ = b$
            GOSUB AddText
            GOSUB PrintRoutine
          NEXT k%
          EXIT LOOP
        ELSE
          LPRINT Action$(j%);
          EXIT LOOP
        END IF
      END IF
    LOOP UNTIL j% = Count%
  NEXT i%
  FOR i% = 1 to TagCount%
    Compare$(i%) = ""
  NEXT i%
END IF

RETURN
'----------------------------------------------------------------------------
PrintAll:

WIDTH "LPT1:",255
LPRINT Text$

SOUND 5000,.5:SOUND 1000,.5

RETURN
'----------------------------------------------------------------------------
WriteBlockToDisk:

WriteToBox ReturnedFile$,"NONAME.BLK",Mouse%,112,14,79,1,1
BlockName$ = ReturnedFile$

IF LEN(BlockName$) THEN
  FileNumber% = FREEFILE
  OPEN BlockName$ FOR OUTPUT AS #FileNumber%
  PRINT #FileNumber%,Block$;
  CLOSE #FileNumber%
END IF

RETURN
'----------------------------------------------------------------------------
SaveAll:

IF NoSave% THEN
  IF CurrentName$ = "NONAME.TXT" THEN
    WriteToBox ReturnedFile$,"NONAME.TXT",Mouse%,112,14,79,1,1
    IF LEN(ReturnedFile$) THEN
      CurrentName$ = ReturnedFile$: GOSUB Save
    END IF
    RETURN
  ELSE
    IF YesNo%("Save " + CurrentName$ + " (Y or N)",1,10,79,112,1,1) THEN
      GOSUB Save
    END IF
    RETURN
  END IF
ELSE
  RETURN
END IF

RETURN
'----------------------------------------------------------------------------
ClearAll:

GOSUB SaveAll

DefaultFile:

CurrentName$ = "NONAME.TXT"
Text$ = CHR$(13,10)
Pointer% = 1: Offset% = 0: NoSave% = 0
CursorRow% = Top%: CursorCol% = LeftSide%
MarkedPointer% = 0: SearchPointer% = 1
BlockBeginPointer% = 0: BlockEndPointer% = 0
BlockStart% = 0: BlockEnd% = 0

RETURN
'----------------------------------------------------------------------------
LoadNew:

IF NoSave% THEN GOSUB SaveAll

InsertFile:

DirectoryBox FileName$,Mouse%,112,14,79,1,1

LoadFile:

IF LEN(FileName$) THEN
  IF LEN(DIR$(FileName$)) THEN
    FileNumber% = FREEFILE
    OPEN FileName$ FOR BINARY AS FileNumber%
    IF LOF(FileNumber%) > 32000 THEN
      ERROR 188
      CLOSE #FileNumber%
      RETURN
    ELSE
      IF InFile% = 1 THEN
        GET$ FileNumber%, LOF(FileNumber%),Block$
        InFile% = 0
        ExpandTabs Block$
        IF Mouse% THEN HideCursor
        SaveScreen Msg$,12,13,15,66,1
        Popwind "Expanding Tabs",12,13,15,66,112,1,1
        FOR j% = 1 to 100
          Percentage j%,13,15,4,112:DELAY .054
        NEXT j%
        IF Mouse% THEN HideCursor
        RestoreScreen Msg$,12,13
      ELSE
        GET$ FileNumber%, LOF(FileNumber%), Text$
        ExpandTabs Text$
        IF Mouse% THEN HideCursor
        SaveScreen Msg$,12,13,15,66,1
        Popwind "Expanding Tabs",12,13,15,66,112,1,1
        FOR j% = 1 to 100
          Percentage j%,13,15,4,112:DELAY .054
        NEXT j%
        IF Mouse% THEN HideCursor
        RestoreScreen Msg$,12,13
        CurrentName$ = FileName$
        IF Text$ = "" THEN Text$ = " " + CHR$(13) + CHR$(10)
          Offset% = 0: Pointer% = 1: NoSave% = 0
          CursorRow% = Top%: CursorCol% = LeftSide%
          MarkedPointer% = 0: SearchPointer% = 1
          BlockBeginPointer% = 0: BlockEndPointer% = 0
          BlockStart% = 0: BlockEnd% = 0
      END IF
      CLOSE #FileNumber%
    END IF
  ELSE
    Message$(1) = FileName$ + " is an Invalid Name"
    SOUND 50,5
    DIALOG Message$(),"",0,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2
  END IF
END IF

RETURN
'----------------------------------------------------------------------------
ViewClipboard:

CbOffset% = Offset%: CbPointer% = Pointer%: CbCursorRow% = CursorRow%
CbCursorCol% = CursorCol%: CbText$ = Text$

Pointer% = 1: CursorRow% = Top%: CusorCol% = LeftSide%
Offset% = 0: Text$ = Block$: TextAttr% = 112

IF Mouse% THEN HideCursor
ClipKey$ = "Viewing Keys  Home End PageUp PageDown ArrowKeys  Esc = Exit"
SaveScreen Clip$,2,1,24,80,0
Popwind ClipKey$,2,1,24,80,15,0,1

DO

GOSUB PrintRoutine

WHILE NOT INSTAT:WEND
Ky$ = INKEY$

IF LEN(Ky$) = 1 THEN
  Chose% = ASC(Ky$)
ELSE
  Chose% = -ASC(RIGHT$(Ky$,1))
END IF

  SELECT CASE Chose%

       CASE -80 'down arrow
         GOSUB ScrollUp
       CASE -72 ' up arrow
         GOSUB ScrollDown
       CASE -71 ' home
         GOSUB StartOfFile
       CASE -77 ' right arrow
        INCR Offset%
       CASE -75 ' left arrow
        IF Offset% THEN DECR Offset%
       CASE -81 ' page down
         GOSUB PageDown
       CASE -73 ' page up
         GOSUB PageUp
       CASE -79  'EndKey
         GOSUB EndOfFile
       CASE 27
         EXIT LOOP
       CASE ELSE

  END SELECT

LOOP

Offset% = CbOffset%: Pointer% = CbPointer%: CursorRow% = CbCursorRow%
CursorCol% = CbCursorCol%: Text$ = CbText$:
TextAttr% = 30
IF Mouse% THEN HideCursor
RestoreScreen Clip$,2,1

RETURN
'----------------------------------------------------------------------------
WriteError:

SELECT CASE ERR

  CASE 5
    Message$(1) = "   ILLEGAL FUNCTION CALL   "
  CASE 6
    Message$(1) = "   OVERFLOW   "
  CASE 7
    Message$(1) = "   OUT OF MEMORY   "
  CASE 9
    Message$(1) = "   SEGMENT OR STACK EXPIRED   "
  CASE 11
    Message$(1) = "   DIVIDE BY 0   "
  CASE 14
    Message$(1) = "   OUT OF VARIABLE SPACE   "
  CASE 15
    Message$(1) = "   FILE EXCEEDS 32K   "
  CASE 24
    Message$(1) = "   DEVICE TIMEOUT   "
  CASE 25
    Message$(1) = "   DEVICE FAULT   "
  CASE 27
    Message$(1) = "   NO PAPER   "
  CASE 52
    Message$(1) = "   IMPROPER FILE LOGIC   "
  CASE 53
    Message$(1) = "   FILE NOT ACCESSABLE   "
  CASE 54
    Message$(1) = "   BAD FILE MODE   "
  CASE 55
    Message$(1) = "   FILE IS OPEN   "
  CASE 57
    Message$(1) = "   DEVICE I/O   "
  CASE 58
    Message$(1) = "   FILE EXISTS   "
  CASE 61
    Message$(1) = "   DISK IS FULL   "
  CASE 62
    Message$(1) = "   UNEXPECTED END OF FILE   "
  CASE 64
    Message$(1) = "   BAD FILE NAME   "
  CASE 67
    Message$(1) = "   TOO MANY FILES OPEN   "
  CASE 68
    Message$(1) = "   DEVICE UNNAVAILABLE   "
  CASE 70
    Message$(1) = "   FILE LOCK   "
  CASE 71
    Message$(1) = "   DISK IS NOT READY   "
  CASE 72
    Message$(1) = "   DISK MEDIA ERROR   "
  CASE 73
    Message$(1) = "   ADVANCED FEATURE UNNAVAILABLE   "
  CASE 74
    Message$(1) = "   RENAME ACROSS DISKS   "
  CASE 75
    Message$(1) = "   BAD PATH/FILE   "
  CASE 76
    Message$(1) = "   PATH NOT FOUND   "
  CASE 188
    Message$(1) = "   FILE EXCEEDS 32K   "
  CASE ELSE
    Message$(1) = "   ERROR" + STR$(ERR) + " AT PGM-CTR" + STR$(ERADR) + "   "
END SELECT

SOUND 50,5
DIALOG Message$(),"",1,Mouse%,3,0,0,ErrorTxt%,ErrorAttr%,1,2

RESUME NEXT
'----------------------------------------------------------------------------
SUB QPrint(BYVAL Row%,BYVAL Col%,BYVAL St$, BYVAL Attr%)PUBLIC
! push            si              ; Save em
! push            di              ;
! push            ds              ;
! mov             ax,St$          ; get the handle
! push            ax              ; push it
! call            getstrloc       ; Get String info
! mov             ds,dx           ; Set the string seg
! mov             si,ax           ; set string ptr
! cmp             cx,0            ; Quit if string = 0
! je              Done            ;
! xor             ax,ax           ;
! mov             ax,Row%         ; get the row
! dec             al              ; convert row to zero base
! mov             bl,80           ; get the number of cols
! mul             bl              ; multiply # of cols * rows
! add             ax,Col%         ; add the column
! dec             al              ; convert column to zero base
! mov             di,ax           ; offset within video page
! shl             di,1            ; account for color/attribute
! mov             ax,&HB800       ; default to mono card segment
Display:
! mov             es,ax           ; point ES to video
! mov             ax,Attr%        ; color/attribute
! mov		  ah,al
Printit:
! lodsb                           ; get a char into al
! stosw                           ; write char and attr to screen
! loop            Printit         ; go for entire string
Done:                             ' (len\counter already in cx)
! pop             ds              ; pop em
! pop             di              ;
! pop             si              ;
END SUB