'Ŀ
'  general purpose string parser                                      
'  call initially with the string to parse and the delimiter          
'  call with null parse string to continue parsing original string    
'  delimiter only needs re-specification if it changes                
'  delimiter can be a list of characters or just one                  
'ٰ
'  

FUNCTION Parse$(strg$,delim$)PUBLIC

$CODE SEG "DNASEG2"

STATIC remain$, dlm$

IF LEN(strg$) THEN remain$ = strg$    'init parms if required
IF LEN(delim$) THEN dlm$ = delim$

remain$ = LTRIM$(remain$,ANY dlm$)    'strip leading delimiters

dpos% = INSTR(remain$,ANY dlm$)       'find next delimiter

IF dpos% THEN                         ' extract parsed bit, leave remainder
  parse$ = LEFT$(remain$,dpos% - 1)
  remain$ = MID$(remain$,dpos% + 1)
ELSE
  parse$ = remain$
  remain$ = ""
END IF

END FUNCTION

'Ŀ
'                  Parse a full file specification                    
'ٰ
'  

SUB ParseSpec(SpecToParse$,Drive$,Path$,FileName$,Extn$) PUBLIC

$CODE SEG "DNASEG2"

Spec$ = UCASE$(LTRIM$(RTRIM$(SpecToParse$)))

IF MID$( Spec$, 2, 1) = ":" THEN
  Drive$ = LEFT$(Spec$,2)
  Spec$ = MID$(Spec$,3)
ELSE
  Drive$ = ""
END IF

LastSlash% = RevInstr%(Spec$, "\")

IF LastSlash% THEN
  Path$ = LEFT$(Spec$,LastSlash% - 1)
  Path$ = Path$ + "\"
  Spec$ = MID$(Spec$,LastSlash% + 1)
ELSE
  Path$ = ""
END IF

FileName$ = Parse$(Spec$, ".")
Extn$ = "." + Parse$("","")

END SUB

'Ŀ
'                    Reverse instring function                        
'ٰ
'  

FUNCTION RevInstr%(Strg$,Target$) PUBLIC

$CODE SEG "DNASEG2"

RevInstr% = 0

FOR i% = LEN(Strg$) TO 1 STEP -1
  IF MID$(Strg$,i%,LEN(Target$)) = Target$ THEN
    RevInstr% = i%
    EXIT FOR
  END IF
NEXT i%

END FUNCTION

'Ŀ
' REVERSE general purpose string parser - parses right to left        
' call initially with the string to parse and the delimiter           
' call with null parse string to continue parsing original string     
' delimiter only needs re-specification if it changes                 
' delimiter can only be one character!                                
'ٰ
'  

FUNCTION RevParse$(strg$,delim$)PUBLIC

$CODE SEG "DNASEG2"

STATIC remain$,dlm$

IF LEN(strg$) THEN remain$ = strg$    ' init parms if required
IF LEN(delim$) THEN dlm$ = delim$

remain$ = RTRIM$(remain$,ANY dlm$)    ' strip leading delimiters

dpos% = RevInstr%(remain$,dlm$)       ' find next delimiter

IF dpos% THEN                         ' extract parsed bit, leave remainder
  RevParse$ = MID$(remain$,dpos% + 1)
  remain$ = LEFT$(remain$,dpos% - 1)
ELSE
  RevParse$ = remain$
  remain$ = ""
END IF

END FUNCTION

'Ŀ
'              returns a binary string of size% digits                
'ٰ
'  

FUNCTION BinFmt$(value&,size%) PUBLIC

$CODE SEG "DNASEG2"

BinFmt$ = RIGHT$("000000000000000" + BIN$(value&),size%)

END FUNCTION

'Ŀ
'               returns a hex string of size% digits                  
'ٰ
'  

FUNCTION HexFmt$(value&,size%) PUBLIC

$CODE SEG "DNASEG2"

HexFmt$ = RIGHT$("000" + HEX$(value&),size%)

END FUNCTION

'Ŀ
'          returns string padded to left with chars to width          
'ٰ
'  

FUNCTION PadLeft$(Strg$,Wid%,CharNum%)PUBLIC

$CODE SEG "DNASEG2"

PadLeft$ = RIGHT$(STRING$(Wid%,CharNum%) + Strg$,Wid%)

END FUNCTION

'Ŀ
'         returns string padded to right with chars to width          
'ٰ
'  

FUNCTION PadRight$(Strg$,Wid%,CharNum%)PUBLIC

$CODE SEG "DNASEG2"

PadRight$ = LEFT$(Strg$ + STRING$(Wid%,CharNum%),Wid%)

END FUNCTION
