DECLARE FUNCTION getoct% (note$)
DECLARE SUB doplay (dat%)
DECLARE SUB d1 ()
DECLARE SUB d2 ()
DECLARE SUB playnote (note$, oct%)
DECLARE SUB stopplay ()
DECLARE SUB setoptions (am%, vibrato%, sustain%, harmonic%)
DECLARE SUB setlevel (level%)
DECLARE SUB setad (attack%, decay%)
DECLARE SUB setsr (sustain%, release%)
DECLARE SUB setwave (wavetype%)
DECLARE SUB delay ()
DEFINT A-Z
COMMON SHARED curvoice, curoctave, curlength, deflength, curtempo

curtempo = 120

file$ = COMMAND$
IF file$ = "" THEN
        PRINT "play FILENAME"
        END
END IF

deflength = 16  'quarter note default
curlength = 16

RANDOMIZE TIMER
FOR curvoice = 0 TO 10
    setoptions 0, 0, 1, 1
    setlevel 63
    setad 8, 1
    setsr 2, 15
    setwave curvoice MOD 4
    stopplay
NEXT


curvoice = 0
setlevel 20

CLS

OPEN file$ FOR INPUT AS #1

DO
    LINE INPUT #1, x$
    PRINT ">"; x$;
    FOR curvoice = 0 TO 10
        note$ = MID$(x$, (curvoice * 3) + 1, 3)
        SELECT CASE note$
            CASE "   "  'nothing
            CASE "***"  'stop
                stopplay
            CASE ELSE   'new note X: X" X' X x x' x" x: x; x= x*
                stopplay
                note$ = LTRIM$(RTRIM$(note$))
                oct = getoct(note$)
                playnote note$, oct
        END SELECT
    NEXT
    PRINT
    delay
LOOP UNTIL EOF(1) OR INKEY$ <> ""

FOR curvoice = 0 TO 10
    setad 15, 15
NEXT

CLOSE

SUB d1
        FOR r = 1 TO 6: x = INP(&H388): NEXT
END SUB

SUB d2
        FOR r = 1 TO 35: x = INP(&H388): NEXT
END SUB

SUB delay
        x# = (1 / curlength) * (60 / curtempo)
        xx# = TIMER + x#
        DO UNTIL TIMER > xx#: LOOP
END SUB

SUB doplay (dat)
        curvoice = 0
        curlength = 8
        curoctave = dat \ 25
        x$ = "defgabccccc"
        n$ = MID$(x$, ((dat MOD 25) \ 4) + 1, 1)
        stopplay
        playnote n$, curoctave
        PRINT n$ + "/o" + LTRIM$(RTRIM$(STR$(curoctave))) + " ";
        delay

END SUB

FUNCTION getoct (note$)
    ' X" X' X x x' x" x: x; x= x*
    no = 1
    IF ASC(MID$(note$, 1, 1)) < 72 THEN 'ucase
        SELECT CASE RIGHT$(note$, 1)
            CASE ":"
                oct = 0
            CASE CHR$(34)
                oct = 1
            CASE "'"
                oct = 2
            CASE ELSE
                oct = 3
                no = 0
        END SELECT
    ELSE
        SELECT CASE RIGHT$(note$, 1)
            CASE "'"
                oct = 5
            CASE CHR$(34)
                oct = 6
            CASE ":"
                oct = 7
            CASE ";"
                oct = 8
            CASE "="
                oct = 9
            CASE "*"
                oct = 10
            CASE ELSE
                oct = 4
                no = 0
        END SELECT
    END IF
    IF no = 1 THEN note$ = MID$(note$, 1, LEN(note$) - 1)
    getoct = oct
END FUNCTION

SUB playnote (note$, oct)
SELECT CASE LCASE$(note$)
        CASE "c#", "c+", "d-"
                msb = &H1: lsb = &H6B
        CASE "d"
                msb = &H1: lsb = &H81
        CASE "d#", "d+", "e-"
                msb = &H1: lsb = &H98
        CASE "e"
                msb = &H1: lsb = &HB0
        CASE "f"
                msb = &H1: lsb = &HCA
        CASE "f#", "f+", "g-"
                msb = &H1: lsb = &HE5
        CASE "g"
                msb = &H2: lsb = &H2
        CASE "g#", "g+", "a-"
                msb = &H2: lsb = &H20
        CASE "a"
                msb = &H2: lsb = &H41
        CASE "a#", "a+", "b-"
                msb = &H2: lsb = &H63
        CASE "b"
                msb = &H2: lsb = &H87
        CASE "c"
                msb = &H2: lsb = &HAE
                oct = oct - 1
        CASE ELSE
                PRINT "ERR[" + note$ + "]";
END SELECT

        OUT &H388, &HA0 + curvoice: d1
        OUT &H389, lsb: d2
        OUT &H388, &HA3 + curvoice: d1
        OUT &H389, lsb: d2

        OUT &H388, &HB0 + curvoice: d1
        OUT &H389, msb + (oct * 4) + 32: d2
        OUT &H388, &HB3 + curvoice: d1
        OUT &H389, msb + (oct * 4) + 32: d2

END SUB

SUB setad (attack, decay)
        OUT &H388, &H60 + curvoice: d1
        OUT &H389, (attack * 16) + decay: d2
        OUT &H388, &H63 + curvoice: d1
        OUT &H389, (attack * 16) + decay: d2
END SUB

SUB setlevel (level)
        OUT &H388, &H40 + curvoice: d1
        OUT &H389, (63 - level): d2
        OUT &H388, &H43 + curvoice: d1
        OUT &H389, (63 - level): d2
END SUB

SUB setoptions (am, vibrato, sustain, harmonic)
        temp = 0
        IF am THEN temp = 128
        IF vibrato THEN temp = temp + 64
        IF sustain THEN temp = temp + 32
        '       harmonic options:
        '            0 - one octave below
        '            1 - at the voice's specified frequency
        '            2 - one octave above
        '            3 - an octave and a fifth above
        '            4 - two octaves above
        '            5 - two octaves and a major third above
        '            6 - two octaves and a fifth above
        '            7 - two octaves and a minor seventh above
        '            8 - three octaves above
        '            9 - three octaves and a major second above
        '           10 - three octaves and a major third above
        '           11 -  "       "     "  "   "     "     "
        '           12 - three octaves and a fifth above
        '           13 -   "      "     "  "   "     "
        '           14 - three octaves and a major seventh above
        '           15 -   "      "     "  "   "      "      "
        temp = temp + harmonic
        OUT &H388, &H20 + curvoice: d1
        OUT &H389, temp: d2
        OUT &H388, &H23 + curvoice: d1
        OUT &H389, temp: d2
END SUB

SUB setsr (sustain, release)
        OUT &H388, &H80 + curvoice: d1
        OUT &H389, ((15 - sustain) * 16) + release: d2
        OUT &H388, &H83 + curvoice: d1
        OUT &H389, ((15 - sustain) * 16) + release: d2
END SUB

SUB setwave (wavetype)
        OUT &H388, &HE0 + curvoice: d1
        '   ___              ___            ___    ___       _      _
        '  /   \            /   \          /   \  /   \     / |    / |
        ' /_____\_______   /_____\_____   /_____\/_____\   /__|___/__|___
        '        \     /
        '         \___/
        '     -0-             -1-              -2-             -3-
        OUT &H389, wavetype: d2
        OUT &H388, &HE3 + curvoice: d1
        OUT &H389, wavetype: d2
END SUB

SUB stopplay
        OUT &H388, &HB0 + curvoice: d1
        OUT &H389, 0: d2
        OUT &H388, &HB3 + curvoice: d1
        OUT &H389, 0: d2
END SUB

