'AMORT.BAS       Copyright 1993 by JN Goodale
'Date: [93-12-20]
'
'   Use to demonstrate BASICXR Cross-Reference program.
'
'Desc: Amortization of a Loan - Find Amount of Level Payment
'
'
'      P=Principal
'      R=Interest Rate
'      I=Interest/Period
'      N=Number of Payments (Periods)
'      A=Amount of Level Payment
'
'
'
'                 P * I
'        A =   --------------
'                      1
'              1 -  --------
'                   (1+I) ^N           Where ^N is "to the Nth Power"
'
'.......................................................................

DIM text$(24)
text$(1) = "                             [ LOAN AMORTIZATION ]"
text$(2) = " "
text$(3) = "      Calculate a Level Loan Payment, given:"
text$(4) = ""
text$(5) = "          Loan Principal, nearest full $  (Max 500000, no commas)"
text$(6) = "          Interest Rate per Year (Max 30.00), Full %, as in 7.75% = 7.75"
text$(7) = "          Number of months to Pay  (Max 480)"
text$(8) = "                I.E. 30 Years = 360 Months"
text$(9) = "                      4 Years =  48 Months"
text$(10) = STRING$(80, 220)
text$(11) = "      Enter Amount of PRINCIPAL:             (Q-to Quit)"
text$(12) = "          Enter Interest Rate %: "
text$(13) = "         Enter Number of Months: "
text$(14) = " "
text$(15) = "     The MONTHLY Payment on the above loan would be:  $"
text$(16) = " "
text$(17) = ""
text$(18) = "              Total Interest: $           Total Payments: $"
text$(19) = ""
text$(20) = "          V-To View schedule      P-To Print schedule"
text$(21) = "          Q-To Start Over"
text$(22) = "                       Choice ? _"
text$(23) = " "
text$(24) = " "

DIM Heading$(3)
Heading$(1) = "[ Loan Amortization ]    Principal:        Interest       Months      "
Heading$(2) = "     Payment #   Balance      Interest     Principal"
Heading$(3) = " "

E0$ = "#######": E2$ = "#######.##": EI$ = "####": FF$ = CHR$(13)
' Non=ASCI within Quotes
DiskPic$(1) = "Ŀ"
DiskPic$(2) = "     "
DiskPic$(3) = ""
DiskPic$(4) = "     "

''.......................................................Page Eject
StartProcess:
    Principal$ = SPACE$(6)
    InterestRate$ = SPACE$(5)
    Months$ = SPACE$(3)

GetPrincipal:
    CLS
    FOR i = 1 TO 11: PRINT text$(i): NEXT i
    LOCATE 11, 34: LINE INPUT Principal$
    IF (Principal$ = "Q") OR (Principal$ = "q") THEN GOTO EndProgram
    n = INSTR(Principal$, ".")
    IF n THEN LSET Principal$ = LEFT$(Principal$, n - 1)
    LOCATE 11, 34: PRINT Principal$;
    Principal = VAL(Principal$)
    IF Principal < 1 THEN GOTO StartProcess
    IF Principal > 500000 THEN GOTO StartProcess
    LOCATE 12, 1: PRINT text$(12)

GetInterest:
    LOCATE 12, 35: LINE INPUT InterestRate$
    IF (InterestRate$ = "q") OR (InterestRate$) = "Q" THEN GOTO EndProgram
    InterestRate = VAL(InterestRate$) / 1200
    IF (InterestRate < 0) OR (InterestRate > 30 / 1200) THEN
        LOCATE 12, 35
        PRINT SPACE$(10);
        GOTO GetInterest
    END IF
    LOCATE 13, 1: PRINT text$(13)

GetMonthsToPay:
    LOCATE 13, 35: LINE INPUT Months$
    IF (Months$ = "q") OR (Months$ = "Q") THEN GOTO EndProgram
    Months% = VAL(Months$) \ 1
    Months = Months%
    IF (Months% < 1) OR (Months% > 480) THEN
        LOCATE 13, 35
        PRINT SPACE$(10);
        GOTO GetMonthsToPay
    END IF

    MID$(Heading$(1), 37) = Principal$
    MID$(Heading$(1), 53) = InterestRate$
    MID$(Heading$(1), 67) = Months$

' CalculateAmount
    x = (1 + InterestRate) ^ Months%
    y = 1 / x
    z = 1 - y
    Amount = (Principal * InterestRate) / z

PrintAmount:
    LOCATE 15, 1
    FOR i = 15 TO 23: PRINT text$(i): NEXT i
    LOCATE 15, 57: PRINT USING E2$; (Amount);
    TotalInterest = 0: TotalPayments = Months% * Amount
    Balance = Principal
    FOR i% = 1 TO Months%
        InterestPay = Balance * InterestRate
        PrincipalPay = Amount - InterestPay
        Balance = Balance - PrincipalPay
        IF Balance < 0 THEN
            TotalPayments = TotalPayments + Balance
            Balance = 0
        END IF
        TotalInterest = TotalInterest + InterestPay
    NEXT i%
    LOCATE 18, 32: PRINT USING E2$; TotalInterest;
    LOCATE 18, 60: PRINT USING E2$; TotalPayments;

GetChoice:
    LOCATE 22, 33
    LINE INPUT k$
    k$ = UCASE$(k$)
    IF k$ = "Q" THEN GOTO StartProcess
    IF k$ = "V" THEN GOSUB ViewLoanTable
    IF k$ = "P" THEN GOSUB PrintLoanTable
    CLS
    GOTO PrintAmount

EndProgram:
    CLS
    END
'>..............................................Start Selected Printing
ViewLoanTable:
    GOSUB HeadUpTableX: Balance = Principal
    FOR i% = 1 TO Months%
        InterestPay = Balance * InterestRate
        PrincipalPay = Amount - InterestPay
        Balance = Balance - PrincipalPay
        Row = Row + 1
        IF Row > 22 THEN GOSUB HeadUpTable
        IF k$ = "Q" THEN RETURN
        PRINT "          ";
        PRINT USING EI$; (i%); : PRINT "   ";
        PRINT USING E0$; Balance; : PRINT "    ";
        PRINT USING E2$; InterestPay; : PRINT "    ";
        PRINT USING E2$; PrincipalPay
    NEXT i%
    GOSUB HeadUpTable
    RETURN
'<............................................... End Selected Listing
PrintLoanTable:
    GOSUB HeadUpPrintX: Balance = Principal
    FOR i% = 1 TO Months%
        InterestPay = Balance * InterestRate
        PrincipalPay = Amount - InterestPay
        Balance = Balance - PrincipalPay
        Row = Row + 1
        IF Row > 52 THEN GOSUB HeadUpPrint
        LPRINT TAB(10); USING EI$; (i%); : LPRINT "   ";
        LPRINT USING E0$; Balance; : LPRINT "    ";
        LPRINT USING E2$; InterestPay; : LPRINT "    ";
        LPRINT USING E2$; PrincipalPay
    NEXT i%
    LPRINT FF$
    RETURN

HeadUpTable:
    PRINT
    PRINT TAB(20); "Q-To Quit,   Any Other Key to Continue ......";
GetAKey:
    k$ = INKEY$
    IF k$ = "" THEN GOTO GetAKey
    k$ = UCASE$(k$)
HeadUpTableX:
    CLS
    IF k$ = "Q" THEN RETURN
    FOR Row = 1 TO 3: PRINT Heading$(Row): NEXT Row
    RETURN

HeadUpPrint:
    LPRINT FF$
HeadUpPrintX:
    FOR Row = 1 TO 3: LPRINT Heading$(Row): NEXT Row
    LPRINT " "
    RETURN

