/*
**  Mark Stephen (1:2607/103.6)
*/

#include <stdio.h>

/*
** Trotter's permutation algorithm, CACM 115
*/

int perm(int *x, int n, int *sig, int *inc, int *first)
{
      int k,m,sigm,sigk,t;

      if (*first)                                     /* initialize     */
      {
            for (k = 0; k < n; k++)
            {
                  sig[k] = 0;
                  inc[k] = 1;
            }
            *first = 0;
      }
      k = -1;
      m = 0;
      sig[m] = sigm = sig[m] + inc[m];
      while (sigm == n - m || sigm == 0)
      {
            if (sigm == 0)    /* off left end */
            {
                  inc[m] = 1;       /* so shift to forward              */
                  k++;              /* and move up transposition point  */
            }
            else  inc[m] = -1;      /* off right end, shift to reverse  */
            if (m == n-2)           /* final exit                       */
            {
                  t = x[m]; x[m] = x[--n]; x[n] = t;
                  sigm = 1;         /* break while loop                 */
                  *first = 1;       /* reset first                      */
            }
            else
            {
                  m++;              /* move to next element             */
                  sig[m] = sigm = sig[m] + inc[m];
            }
      }
      if (! *first)
      {
            sigk = k + sigm;
            t = x[sigk]; x[sigk] = x[sigk+1]; x[sigk+1] = t;
      }
      return *first;
}

main()
{
      unsigned long n;
      int odds[] = {1,3,7,9};
      int evens[] = {2,4,6,8};
      int odd_pos[] = {0,1,2,3};
      int even_pos[] = {0,1,2,3};
      int esig[4], einc[4], osig[4], oinc[4];
      int odd, even;
      int i, j;

      odd = even = 1;
      for (i = 0; i < 1000; i++)          /* for timing                 */
      {
            do                            /* odd positions              */
            {
                  do                      /* even positions             */
                  {
                        n = odds[odd_pos[0]];
                        n = n*10 + evens[even_pos[0]];
                        n = n*10 + odds[odd_pos[1]];

                        /* got first three digits, start testing */

                        if (n % 3)
                              continue;
                        n = n*10 + evens[even_pos[1]];
                        if (n % 4)
                              continue;
                        n = n*10 + 5;
                        n = n*10 + evens[even_pos[2]];
                        if (n % 6)
                              continue;
                        n = n*10 + odds[odd_pos[2]];
                        if (n % 7)
                              continue;
                        n = n*10 + evens[even_pos[3]];
                        if (n % 8)
                              continue;
                        n = n*10 + odds[odd_pos[3]];
                        if (0 == n%9)
                              goto done;
                  } while (! perm(even_pos, 4, esig, einc, &even));
            } while(! perm(odd_pos, 4, osig, oinc, &odd));
done:       odd = even = 1;               /* reset perm indexes         */
            for (j = 0; j < 4; j++)       /* and permutation arrays     */
                  odd_pos[j] = even_pos[j] = j;
      }                                   /* end of timing loop         */
      printf("Number = %lu?\n", n);
}
