/*
**  Larry Hudson (1:206/2503)
*/

#include <stdio.h>
#include <string.h>
#include <setjmp.h>

typedef enum { FALSE, TRUE } bool; /*  Boolean values       */

int  get_next(int dig);
void eval(int idx);

bool avail[10]; /*  Array to keep track of available digits */
long number;    /*  The number in process                   */
jmp_buf env;

int  main()
{
#ifdef TEST
    int I;

    for (I = 0; I < 1000; ++I)
    {
#endif

        /*  Set avail[] array for all digits available          */

        memset(avail, TRUE, sizeof(avail));
        number = 0L;
        if (0 == setjmp(env))
            eval(1);                /*  Find the number(s)      */
#ifdef TEST
    }
#endif
    printf("%ld\n", number);    /* Print result */
    return 0;
}

/*
** Find next available digit
*/

int  get_next(int dig)
{
    for (avail[dig++] = TRUE; dig < 10; ++dig)
    {
        if (avail[dig])
        {
            avail[dig] = FALSE;
            break;
        }
    }
    return dig;
}

/*
** Recursively evaluate the number
*/

void eval(int idx)
{
    int  digit;                 /*  Current digit this level*/

    digit = get_next(0);        /*  Get lowest avail digit  */
    number = number * 10 + digit;   /*  Add to end of number*/

    while (1)
    {
        if (number % idx == 0)  /*  Evenly divisible?       */
        {
            if (idx == 9)       /*  All nine digits?        */
                longjmp(env, -1);
            else
                eval(idx + 1);  /*  Next digit level        */
        }

        number -= digit;        /*  Remove current digit    */

        /*  Get next higher digit                           */
        if ((digit = get_next(digit)) > 9)
        {
            /*  Out of digits, truncate number and return   */
            number /= 10;
            return;
        }
        number += digit;        /*  Add new current digit   */
    }
}
