/*********************************************************************

Subj: A simple programming challenge

The object is to find a particular nine digit decimal number.  The number
must consist of the nine digits (1,2,3...9).  Each (and every) digit is used
once, and only once. The number must have the following properties...

The leftmost digit of the number must be evenly divisible by the number 1.
(trivial)

The leftmost two digits of the number must be evenly divisible by the number
2.

The leftmost three digits of the number must be evenly divisible by the
number 3, and so on.  The entire number must be evenly divisible by the
number 9.

There is only one number which will satisfy the above conditions.

*********************************************************************/

/*********************************************************************

Ron Bemis' (1:124/1113) Solution

Interesting problem.

Once they learn how to use a computer, it's amazing how many people make it do their thinking for them.  This is (almost) just a simple logic problem.

Although you can could use the computer to generate the possible solutions and eliminate duplicate numbers, I found it just as easy to do it with my text editor.

o Since 0 cannot be used, #5 must be a 5.

o #1 can be 1, 3, 7 or 9.

o #2 can be 2, 4, 6 or 8.

o #3 can be 3, 5, 7 or 9.

o #1-3 must be a multiple of 3.  That gives 20 possibilities:

    123     321     723     921
    129     327     729     927
    147     369     741     963
    183     381     783     981
    189     387     789     987

o Since #1-4 must be a multiple of 4, #3-4 must also be a multiple of
  4, so #4 must be 2 or 6 (since #3 is odd).

o Since #4 is 2 or 6, and #5 is 5, there are only 6 possibilies for
  the #4-6 range:

    254     652
    256     654
    258     658

o Since #1-6 must be a multiple of 3 as well as 6, and since #1-3 are
  already a multiple of 3, #4-6 must be a multiple of 3.  This leaves
  only three possibilities for #4-6:

    258
    654
    658

o Since #1-8 must be a multiple of 8 and since #6 is either 4 or 8,
  #7-8 must be a multiple of 8, so #7-8 can be:

    16
    32
    72
    96

o Since #4 and #8 are assigned 2 and 6, #2 and #6 must be 4 and 8.

o Since #2 must be 4 or 8, the possibilies for #1-3 are cut in half:

    147     741
    183     783
    189     789
    381     981
    387     987

o Combine the possibilities for #1-3 and #4-6:

    #1-3        #4-6
    ----        ----
    147         258
    183         654
    189         658
    381
    387
    741
    783
    789
    981
    987

    147258          147654 (4)      147658
    183258 (8)      183654          183658 (8)
    189258 (8)      189654          189658 (8)
    381258 (8)      381654          381658 (8)
    387258 (8)      387654          387658 (8)
    741258          741654 (4)      741658
    783258 (8)      783654          783658 (8)
    789258 (8)      789654          789658 (8)
    981258 (8)      981654          981658 (8)
    987258 (8)      987654          987658 (8)

o And eliminate repeated 4's and 8's:

    147258                          147658
                    183654
                    189654
                    381654
                    387654
    741258                          741658
                    783654
                    789654
                    981654
                    987654

o #8 must be 2 or 6 (whichever #4 isn't), and the possibilities for
  #7-8 are limited to 16, 32, 72 and 96.  So if #4 is a 2, #7-8 can be
  16 or 96 and if #4 is a 6, #7-8 can be 32 or 72.

    14725816 (1)    14725896
    14765832        14765872 (7)
    18365432 (3)    18365472
    18965432        18965472
    38165432 (3)    38165472
    38765432 (3)    38765472 (7)
    74125816 (1)    74125896
    74165832        74165872 (7)
    78365432 (3)    78365472 (7)
    78965432        78965472 (7)
    98165432        98165472
    98765432        98765472 (7)

o And eliminate repeated digits:

    14725896
    14765832
    18365472
    18965432
    18965472
    38165472
    74125896
    74165832
    78965432
    98165432
    98165472
    98765432

o Using all nine digits once assures us that any number will be a
  multiple of 9, so #9 is whatever is left over.  The 12 possible
  solutions fall neatly into place:

    147258963
    147658329
    183654729
    189654327
    189654723
    381654729
    741258963
    741658329
    789654321
    981654327
    981654723
    987654321

o These can be checked for divisibility by 7 with a calculator.  :-)

*********************************************************************/

#include <stdio.h>

int main(void)
{
      unsigned long test;
      unsigned long possible[] = {
            147258963L,
            147658329L,
            183654729L,
            189654327L,
            189654723L,
            381654729L,
            741258963L,
            741658329L,
            789654321L,
            981654327L,
            981654723L,
            987654321L
            };
      int i
#ifndef TEST
      ;
#else
      , I;

      for (I = 0; I < 1000; ++I)
      {
#endif
            for (i=0; i<sizeof(possible)/sizeof(long); i++)
            {
                  test = possible[i] / 100L;                /* 7 digits */
                  if (test % 7L == 0)
                        printf("%lu\n", possible[i]);
            }
            return(0);
#ifdef TEST
      }
#endif
      return 0;
}
