/*
 * Function to find the "magic" 9 digit number, where every substring
 * of the number (to the left) is divisible by the number of digits in
 * that substring.
 *
 * Dave Dunfield - May 20, 1994 - Released to the Public Domain
 */

#include <stdio.h>
#include <string.h>
#include <setjmp.h>

jmp_buf env;

long RetVal;
char digits[10];

void findnum(long num, int n)
{
      long next;
      int i;

      if(n >= 10)                               /* This number qualifies */
      {
            RetVal = num;
            longjmp(env, -1);
      }
      else for(i=1; i < 10; ++i)                /* Test digits 1-9 only  */
      {
            if(digits[i])                       /* Digit in use          */
                  continue;
            if(!((next = num * 10 + i) % n))    /* Divides - proceed     */
            {
                  digits[i] = (char)-1;         /* Mark digit as used    */
                  findnum(next, n + 1);         /* Try sub-combinations  */
                  digits[i] = 0;                /* Release digit         */
            }
      }
}

main()
{
#ifdef TEST
      int I;

      for (I = 0; I < 1000; ++I)
      {
#endif
            memset(digits, 0, sizeof(digits));
            if (0 == setjmp(env))
                  findnum(0L, 1);
#ifdef TEST
      }
#endif
      printf("Numer = %ld\n", RetVal);
      return 0;
}
