/* TPAL4C demo program v1.00

 To compile this demo program you must create a project file containing:

        TPALDEMO.C
        FONTS_x.LIB
        TPALC_x.LIB

 'x' is the letter of the memory module you want to use.  (This demo requires
 Compact or larger memory module!)

        S = small
        M = medium
        C = compact
        L = large
        H = huge

 * Note:  The unregistered version only contains the small memory module. *

*/

#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <time.h>
#include "fonts.h"
#include "tpal.h"

void Center(int row, char st[80]);
void InOut(void);

void main(void)
{
     int i;

     if (!TGetVGA())
     {
        printf("\nSorry, but you *MUST* have VGA to run this demo!\n\n");
        exit(1);
     }

     InitTPALDriver();
     TFadeOutPalette(5);
     _setcursortype(_NOCURSOR);
     textattr(15);
     clrscr();
     TSetFont(script);
     textattr(12);
     Center(5, "Did you know that by accessing the video port directly");
     textattr(10);
     Center(7, "you can change the palette in any text video mode?");
     textattr(13);
     InOut();

     TSetFont(scribble);
     Center(5, "Wouldn't your programs look better with");
     textattr(9);
     Center(7, "smooth-fading TEXT palettes?");
     textattr(10);
     Center(12, "(not to mention these cool fonts!)");
     textattr(7);
     Center(24, "Remember:  This is in text mode, not a graphic mode!");
     InOut();

     TSetFont(puter);
     textattr(15);
     Center (2,"You can use ANY of VGA's 256,000 color combinations in TEXT mode!");
     Center (25,"Press any key to continue ...");
     gotoxy(1,5);
     for (i=0;i<=14;i++)
     {
        textattr(14-i);
        textbackground(i);
        cprintf("                              This is awsome!!                                \r\n");
     }
     textbackground(0);
     TFadeInPalette(7);
     randomize();
     while(!kbhit())
     {
        TSetPalette((rand()%62)+1,rand()%63,rand()%63,rand()%63);
     }
     getch();
     TFadeOutPalette(7);
     clrscr();
     TResetPalette();
     TBlankPalette();

     TSetFont(thix);
     textattr(14);
     Center(5, "This will work with any VGA video card!");
     textattr(10);
     Center(7, "Works with all the extended 256 text colors (VGA)");
     textattr(11);
     Center(9, "And now YOU can do this too!");
     InOut();

     TSetFont(future);
     textattr(15);
     textbackground(7);
     clrscr();
     Center(12, "You can even set the brightness of the display!");
     Center(14, "This is COLOR 15 (bright white) on 7 (white)");
     Center(15, "The brightness is at 50%!");
     TSetBright(31);
     delay(3000);
     Center(14, "This is still COLOR 15 (bright white) on 7 (white)");
     Center(15, "But now the brightness is at 100% (normal)!");
     TResetPalette();
     delay(3000);
     TFadeOutPalette(7);

     TSetFont(king);
     textbackground(0);
     clrscr();
     Center(5, "You could fade-in ...");
     textattr(13);
     gotoxy(1, 10);
     cprintf("                                     \r\n");
     cprintf("                                           \r\n");
     cprintf("                                            \r\n");
     cprintf("                                          \r\n");
     cprintf("                                         \r\n");
     cprintf("                                    \r\n");
     cprintf("                              \r\n");
     TFadeInPalette(40);
     delay(2000);
     TFadeOutPalette(7);

     clrscr();
     textattr(13);
     Center(5, "OR you can fade-in nice and ...");
     textattr(15);
     gotoxy(1, 10);
     cprintf("                                   \r\n");
     cprintf("                                         \r\n");
     cprintf("                                             \r\n");
     cprintf("                                           \r\n");
     cprintf("                                          \r\n");
     cprintf("                                      \r\n");
     cprintf("                                       \r\n");
     TFadeInPalette(1);
     delay(2000);
     TFadeOutPalette(7);

     clrscr();
     TResetFont();
     Center(1, "TPAL4C v1.00 - (C) Copyright 1994 Peak Computing");
     textattr(12);
     Center(5, "But of course, it's all up to you!");
     textattr(7);
     Center(9, "If you plan to use these routines I ask you to");
     Center(11, "PLEASE REGISTER!");
     Center(13, "Registration only costs $15.00");
     Center(15, "See ORDER.FRM for registration information.");
     gotoxy(1, 20);
     TFadeInPalette(7);
     delay(3000);
     TPALDone();
     _setcursortype(_NORMALCURSOR);
     exit(0);
}

void Center(int row, char st[80])
{
    gotoxy(40-(strlen(st)/2+.5),row);
    cprintf("%s",st);
}

void InOut(void)
{
    TFadeInPalette(7);
    delay(2500);
    TFadeOutPalette(7);
    clrscr();
}
