/*****************************************************************************
   MODULE: _rbget.h
  PURPOSE: header used to compile library functions
COPYRIGHT: (C) 1994 William Pierpoint
  VERSION: 1.10
  RELEASE: Mar 28, 1994
*****************************************************************************/

#ifndef _RBGET_H
#define _RBGET_H

#include "recio.h"

extern int _rstatus(REC *rp);
extern char *_rfldstr(REC *rp, size_t len);
extern char *_rerrs(REC *rp, int errnum);

/* macro for number conversion */
#define rbget_fn( /* define function to get number from record */\
    fn_type,      /* defined function return type */\
    fn_name,      /* defined function name */\
    fn_err,       /* defined function error return value */\
    cv_type,      /* conversion function return type */\
    cv_name,      /* conversion function name */\
    fn_min,       /* inclusive valid minimum value */\
    fn_max)       /* inclusive valid maximum value */\
\
fn_type fn_name(        /* return fn_type, return fn_err on error */\
        REC *rp,        /* record pointer */\
        int base)       /* radix of number */\
{ \
    fn_type result=(fn_err); /* result to return */\
    cv_type val;             /* conversion value */\
    char *fldptr;            /* pointer to field string */\
    char *endptr;            /* pointer to first invalid field char */\
\
    if (!_rstatus(rp)) { \
      fldptr = _rfldstr(rp, 0); \
      if (fldptr) { \
        for (;;) { \
          if (*fldptr != '\0') { \
            endptr = fldptr; \
            val = cv_name(fldptr, &endptr, base); \
            while(isspace(*endptr)) endptr++; \
            if (errno==ERANGE||!*endptr) { \
              if (!errno&&((fn_min)==(fn_max)||(val>=(fn_min)&&val<=(fn_max)))) { \
                result = (fn_type) val; \
                break; \
              } /* out of range */ \
              fldptr = _rerrs(rp, R_ERANGE); \
              if (fldptr) continue; \
            } /* invalid data */ \
            fldptr = _rerrs(rp, R_EINVDAT); \
            if (fldptr) continue; \
          } /* missing data (empty fldstr) */ \
          fldptr = _rerrs(rp, R_EMISDAT); \
          if (fldptr) continue; \
        break; \
        } \
      } /* null pointer */ \
    } \
    return result; \
}

/* useful macro support */
#define BUILTIN 0  /* indicates that range testing and/or radix
                      is built into the conversion function */
#define uint   unsigned int
#define ulong  unsigned long

#endif
