/*****************************************************************************
   MODULE: rget.c
  PURPOSE: defines rget series of functions for recio library
COPYRIGHT: (C) 1994 William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 1.10
  RELEASE: Mar 28, 1994
*****************************************************************************/

#include <ctype.h>
#include <errno.h>
#include <float.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "_rget.h"

#define rreclen(rp)      ((rp)->r_reclen)
#define rcol(rp)         ((rp)->r_colno)

#ifdef __BORLANDC__
#pragma warn -ccc
#endif

/****************************************************************************/
int                          /* return character; EOF=error or missing data */
    strtoc(                  /* convert string to character                 */
        const char  *nptr,   /* pointer to string to convert                */
              char **endptr) /* pointer to conversion leftover string       */
/****************************************************************************/
{
    int ch=EOF;              /* result to return */

    /* set *endptr to nptr just in case conversion fails */
    if (endptr) *endptr = (char *) nptr;

    /* skip over white space */
    while (isspace(*nptr)) nptr++;
    
    /* if string contains a non-whitespace character */
    if (*nptr != '\0') {
        
        /* get the character */
        ch = (int) *nptr;
        
        /* position endptr just past the character */
        if (endptr) *endptr = (char *) ++nptr;
    } 
    return (ch);
}

/****************************************************************************/
char *                       /* return pointer to string; NULL on error     */
    rgets(                   /* get string from record stream               */
        REC *rp)             /* record pointer                              */
/****************************************************************************/
/* note: can't use our rget_fn macro for rgets since empty string is not 
         considered missing data (unless beyond end of record) */
{
    char *retp=NULL;         /* return pointer to string */
    char *fldp;              /* pointer to field buffer */

    if (!_rstatus(rp)) {

        /* if field position is within record */
        if (rcol(rp) <= rreclen(rp)) {
            fldp = _rfldstr(rp, 0);
            if (fldp) retp = fldp;

        /* else beyond end of record */
        } else {
            rfldno(rp)++;
            fldp = _rerrs(rp, R_EMISDAT);
            if (fldp) retp = fldp;
        }
    }
    return (retp);
}

/****************************************************************************/
/* rget_fn() - define other rget functions                                  */
/****************************************************************************/

rget_fn(    int, rgetc, EOF,    int, strtoc, BUILTIN, BUILTIN)
rget_fn(  float, rgetf, 0.0, double, strtod, FLT_MIN, FLT_MAX)
rget_fn( double, rgetd, 0.0, double, strtod, BUILTIN, BUILTIN)
