#include <stdio.h>

typedef float map_entry[5];

static void
read_cmap(char *ifilename, char *mapname)
{
   FILE *ifile = fopen(ifilename, "r");
   char buffer[512];
   map_entry cmap[16];
   int i, j, cnt;

   if (ifile == NULL) {
      printf("Failed to open input file: '%s'\n", ifilename);
      exit(1);
      }

   fgets(buffer, 512, ifile);
   i = sscanf(buffer, "%d", &cnt);
   if (i != 1) {
      printf("Unable to read map entries\n");
      exit(1);
      }

   i = 0;
   while (i <= cnt && !feof(ifile)) {
      fgets(buffer, 512, ifile);
      j = sscanf(buffer, "%f %f %f %f %f",
		 &cmap[i][0], &cmap[i][1], &cmap[i][2], &cmap[i][3],
		 &cmap[i][4]);
      if (i > 0 && i < cnt)
	 fgets(buffer, 512, ifile);
      if (j != 5) {
	 printf("Bad # of entries at line %d of map file\n", i+1);
	 exit(1);
	 }
      i++;
      }

   fclose(ifile);

   /* Now write the Polyray color map */
   printf("define %s color_map(\n", mapname);
   for (j=0;j<i-1;j++) {
      printf("   [%5.3f, %5.3f, <%5.3f, %5.3f, %5.3f>, %5.3f, <%5.3f, %5.3f, %5.3f>, %5.3f]",
	   cmap[j][0], cmap[j+1][0], 
	   cmap[j][1], cmap[j][2], cmap[j][3], cmap[j][4],
	   cmap[j+1][1], cmap[j+1][2], cmap[j+1][3], cmap[j+1][4]);
      if (j<i-2)
	 printf("\n");
      else
	 printf(")\n");
      }
}

int
main(argc,argv)
   int argc;
   char *argv[];
{
   FILE *file;
   char *infile;

   if (argc != 3) {
      printf("Usage: makemap cmapfile mapname\n");
      exit(1);
      }
   else
      read_cmap(argv[1], argv[2]);
}
