/*** TERM_IO.C ***/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pcl4c.h"
#include "term.h"
#include "ascii.h"
#include "dos_io.h"

/*** Display status line ***/

#define INVERSE 0x70
#define RIGHTMOST 40

void DisplayLine(char *MsgPtr, char *UserPtr, int UserLength)
{static int right = RIGHTMOST;
 int row;
 int col;
 int i;
 char c;
 int MsgLength;
 row = GetRow();
 col = GetCol();
 Position(24,0);
 /* display message */
 MsgLength = strlen(MsgPtr);
 for(i=0;i<MsgLength;i++)
     {AttrWrite(*MsgPtr++,INVERSE);
      Position(24,(unsigned char)(i+1));
     }
 /* blank rest of menu bar */
 for(i=MsgLength;i<right;i++)
     {AttrWrite(' ',INVERSE);
      Position(24,(unsigned char)(i+1));
     }
 right = MsgLength;
 /* want response from user ? */
 if(UserPtr!=NULL)
     {right = RIGHTMOST;
      /* input text from user */
      i = 0;
      while(1)
          {Position(24,(unsigned char)(MsgLength+i));
           c = SioKeyRead();
           if((c==ESC)||(c==CAN))
               {UserPtr[0] = '\0';
                break;
               }
           if((c=='\r')||(MsgLength+i==RIGHTMOST))
               {UserPtr[i] = '\0';
                break;
               }
           if((c==BS)&&(i>0))
               {i--;
                Position(24,(unsigned char)(MsgLength+i));
                AttrWrite(' ',INVERSE);
               }
           else
               {/* save character & display on status line */
                UserPtr[i++] = c;
                AttrWrite(c,INVERSE);
                if(i==UserLength)
                    {/* user string done */
                     UserPtr[i] = '\0';
                     break;
                    }
               }
          } /* end -- while */
     } /* end -- if */
 Position((unsigned char)row,(unsigned char)col);
}

/*** output character to serial port ***/

int PutChar(int Port, char ch)
{int rc;
 /* transmit character */
 rc = SioPutc(Port,ch);
 if(rc<0)
     {printf("SioPutc Error: COM%d: ",1+Port);
      SioError(rc);
      SioDone(Port);
      exit(1);
     }
 return(rc);
}

/*** receive character from serial port ***/

int GetChar(int Port, int Timeout)
{int rc;
 rc = SioGetc(Port,Timeout);
 if(rc<-1)
     {printf("SioGetc Error: COM%d: ",1+Port);
      SioError(rc);
      exit(1);
     }
 return(rc);
}

/*** display the error text ***/

void SayError(int Port, char *ptr)
{char temp[81];
 sprintf(temp,"ERROR! COM%d : %s",1+Port,ptr);
 DisplayLine(temp,NULL,0);
 printf("\n*** %s\n",temp);
 /* cancel remote */
 PutChar(Port,CAN);
 PutChar(Port,CAN);
 PutChar(Port,CAN);
} /* end SayError */
