// *************************************************************** //
// Filename:    MDIMenu.h                                          //
//                                                                 //
// Date:        November 26, 1993                                  //
//                                                                 //
// Description:                                                    //
// *************************************************************** //

#ifndef MDIMenu_H
#define MDIMenu_H

#include <owl\owlcore.h>
#include <owl\mdi.h>
#include <owl\mdichild.h>
#include <owl\decmdifr.h>
#include <owl\statusba.h>
#include <owl\controlb.h>
#include <owl\buttonga.h>
#pragma hdrstop
#include "WhichDlg.h"
#include "MDIMenu.rh"

// --------------------------------------------------------------- //
// MDIMenuApplication                                              //
// --------------------------------------------------------------- //
class TMDIMenuApp : public TApplication 
{
  public:
    TMDIMenuApp();
   ~TMDIMenuApp();
    void InitMainWindow();

    TStatusBar *StatusBar;
    TControlBar *ControlBar;
};

// --------------------------------------------------------------- //
// MDIMenuClient                                                   //
// --------------------------------------------------------------- //
class TMDIMenuClient : public TMDIClient
{
  public:
    TMDIMenuClient(TModule *module = 0);
   ~TMDIMenuClient();

    void SetupWindow();
    void CleanupWindow();
  
    TMDIChild* InitChild();
    DECLARE_RESPONSE_TABLE(TMDIMenuClient);
  protected:
    void CmCommon();
};

// --------------------------------------------------------------- //
// MDIMenuChild                                                   //
// --------------------------------------------------------------- //
class TMDIChildA : public TMDIChild
{
  public:
    TMDIChildA(TMDIClient &parent, const char far *title = 0,
      TWindow *clientWnd = 0, BOOL shrinkToClient = FALSE,
      TModule *module = 0);
   ~TMDIChildA();

    void GetWindowClass(WNDCLASS& wndClass);
    char *GetClassName();
    void SetupWindow();
    void CleanupWindow();
  
    DECLARE_RESPONSE_TABLE(TMDIChildA);
  protected:
    void CmAction();
    void EvMDIActivate(HWND hWndActivated, HWND hWndDeactivated);
    TButtonGadget *Gadget;
    BOOL Inserted;
};

class TMDIChildB : public TMDIChild
{
  public:
    TMDIChildB(TMDIClient &parent, const char far *title = 0,
      TWindow *clientWnd = 0, BOOL shrinkToClient = FALSE,
      TModule *module = 0);
   ~TMDIChildB();

    void GetWindowClass(WNDCLASS& wndClass);
    char *GetClassName();
    void SetupWindow();
    void CleanupWindow();
  
    DECLARE_RESPONSE_TABLE(TMDIChildB);
  protected:
    void CmAction();
    void EvMDIActivate(HWND hWndActivated, HWND hWndDeactivated);
    TButtonGadget *Gadget;
    BOOL Inserted;
};


#endif


