// *************************************************************** //
// Filename:    app.cpp                                            //
//                                                                 //
// Date:        November 26, 1993                                  //
//                                                                 //
// Description:                                                    //
// *************************************************************** //
#include "MDIMenu.h"

// --------------------------------------------------------------- //
// Application constructor                                         //
// --------------------------------------------------------------- //
TMDIMenuApp::TMDIMenuApp() : 
  TApplication() 
{
}

// --------------------------------------------------------------- //
// Application destructor                                          //
// --------------------------------------------------------------- //
TMDIMenuApp::~TMDIMenuApp()
{
}

// --------------------------------------------------------------- //
// InitMainWindow                                                  //
// --------------------------------------------------------------- //
void TMDIMenuApp::InitMainWindow()
{
  TDecoratedMDIFrame *frame = new TDecoratedMDIFrame(
    GetName(), "MDIMenu", *new TMDIMenuClient, TRUE);

  ControlBar = new TControlBar(frame, TControlBar::Horizontal);
  ControlBar->Insert(*new TButtonGadget("COMMON", CM_COMMON));
  frame->Insert(*ControlBar, TDecoratedFrame::Top);

  StatusBar = new TStatusBar(frame, TGadget::Embossed);
  frame->Insert(*StatusBar, TDecoratedFrame::Bottom);

  TMenuDescr menuDescr("MDIMenu", 1, 1, 0, 0, 1, 1);
  frame->SetMenuDescr(menuDescr);
  SetMainWindow(frame);
}

// --------------------------------------------------------------- //
// OwlMain                                                         //
// --------------------------------------------------------------- //
int OwlMain(int /*argc*/, char* /*argv*/ [])
{
  TMDIMenuApp app;
  return app.Run();
}

