//*************************************************************
//  File name: RECTVIEW.CPP
//
//  Description:
//     Implementation for the CRectView class.
//
//  History:    Date       Author     Comment
//              3/8/94     FJB        Created
//
// Written by Microsoft Product Support Services, Windows Developer Support
// Copyright (c) 1994 Microsoft Corporation. All rights reserved.
//*************************************************************

#include "stdafx.h"
#include "multicon.h"  
#include "micondoc.h" 
#include "modview.h"
#include "rectview.h"  

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif 
 
//*************************************************************
//  Class:
//      CRectView 
//
//  Description:
//      AppWizard generated view class that draws a rectangle of random color
//      and size.
//
//  Derived from:
//      CModView
//
//  Data Members:
//      None
//
//  Member Functions:
//      CRectView      : Constructor
//     ~CRectView      : Destructor
//      GetDocument    : Returns a CMulticonDoc*
//      OnDraw         : Draws an rectangle
//
//  Comments
//      This class is derived from CModView, a CView derived class that
//      exposes a public OnDraw override.
//
//  History:    Date       Author     Comment
//              3/8/94     FJB        Created
//
//*************************************************************  


IMPLEMENT_DYNCREATE(CRectView, CModView)

CRectView::CRectView()
{
}

CRectView::~CRectView()
{
}


BEGIN_MESSAGE_MAP(CRectView, CModView)
   //{{AFX_MSG_MAP(CRectView)
      // NOTE - the ClassWizard will add and remove mapping macros here.
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CRectView drawing


void CRectView::OnDraw(CDC* pDC)
{   
   CMulticonDoc* pDoc = GetDocument();
   
   CRect rcClient;
   GetClientRect(&rcClient);
   // Compute some random coordinates for the rectangle
   // Make it a little larger than the client area to make sure the 
   // clipping is working OK.
   int xMin = rcClient.left   - rcClient.Width()/4;
   int xMax = rcClient.right  + rcClient.Width()/4;
   int yMin = rcClient.top    - rcClient.Height()/4;
   int yMax = rcClient.bottom + rcClient.Height()/4;

   int x1 = pDoc->Rand(xMax,xMin);
   int x2 = pDoc->Rand(xMax,xMin);
   int y1 = pDoc->Rand(yMax,yMin);
   int y2 = pDoc->Rand(yMax,yMin);

   // Compute a random RGB value    
   int nRed   = pDoc->Rand(255);
   int nBlue  = pDoc->Rand(255);
   int nGreen = pDoc->Rand(255);  
      
   CBrush br;
   br.CreateSolidBrush( RGB(nRed,nBlue,nGreen) );
      
   CBrush *pbrOld = pDC->SelectObject(&br);
      
   pDC->Rectangle(x1,y1,x2,y2);
      
   pDC->SelectObject(pbrOld);
   br.DeleteObject();
}
   


/////////////////////////////////////////////////////////////////////////////
// CRectView message handlers
 
