//*************************************************************
//  File name: ELLPSEVW.CPP
//
//  Description: Implementation for the CEllipseView class.
//
//  History:    Date       Author     Comment
//              3/7/94     FJB        Created
//
// Written by Microsoft Product Support Services, Windows Developer Support
// Copyright (c) 1994 Microsoft Corporation. All rights reserved.
//*************************************************************

#include "stdafx.h"
#include "multicon.h" 
#include "micondoc.h" 
#include "modview.h"
#include "ellpsevw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
        
        
//*************************************************************
//  Class:
//      CEllipseView 
//
//  Description:
//      AppWizard generated view class that draws an ellipse of random color
//      and size.
//
//  Derived from:
//      CEllipseView
//
//  Data Members:
//      None
//
//  Member Functions:
//      CEllipseView      : Constructor
//     ~CEllipseView      : Destructor
//      GetDocument       : Returns a CMulticonDoc*
//      OnDraw            : Draws an ellipse
//
//  Comments
//      This class is derived from CModView, a CView derived class that
//      exposes a public OnDraw override.
//
//  History:    Date       Author     Comment
//              3/7/94     FJB        Created
//
//*************************************************************  


IMPLEMENT_DYNCREATE(CEllipseView, CModView)

CEllipseView::CEllipseView()
{ 
   // nothing to do here...
}

CEllipseView::~CEllipseView()
{ 
   // or here.
}


BEGIN_MESSAGE_MAP(CEllipseView, CModView)
   //{{AFX_MSG_MAP(CEllipseView)
      // NOTE - the ClassWizard will add and remove mapping macros here.
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CEllipseView drawing


void CEllipseView::OnDraw(CDC* pDC)
{   
   CMulticonDoc* pDoc = GetDocument();
  
   // This block draws an ellipse of random size and color 
   // The coordinate range for the rectangle is 50% larger than
   // the view's current client area, to give a splashover effect
   CRect rcClient;
   GetClientRect(&rcClient);
   int xMin = rcClient.left   - rcClient.Width()/4;
   int xMax = rcClient.right  + rcClient.Width()/4;
   int yMin = rcClient.top    - rcClient.Height()/4;
   int yMax = rcClient.bottom + rcClient.Height()/4;
  
   // This view doesn't really need a document, since it generates it's
   // own random data and doesn't require serialization support.  Just
   // for fun, the document provides a random number function that returns
   // a value in the specified range
   int x1 = pDoc->Rand(xMax,xMin);
   int x2 = pDoc->Rand(xMax,xMin);
   int y1 = pDoc->Rand(yMax,yMin);
   int y2 = pDoc->Rand(yMax,yMin);
      
   int nRed   = pDoc->Rand(255);
   int nBlue  = pDoc->Rand(255);
   int nGreen = pDoc->Rand(255);  
      
   CBrush br;
   br.CreateSolidBrush( RGB(nRed,nBlue,nGreen) );
      
   CBrush *pbrOld = pDC->SelectObject(&br);
      
   pDC->Ellipse(x1,y1,x2,y2);

   // We painted the picture, now clean the brush   
   pDC->SelectObject(pbrOld);
   br.DeleteObject();
   
}


