
//REGEN_FILEHEADING
//REGEN_FILEHEADING


     /********************************************************************
      *                                                                  *
      *   Source File: METER.cpp                                         *
      *   Description: C++ Source file for METER application             *
      *   Date:        Wed Mar 23 21:14:36 1994                          *
      *                                                                  *
      ********************************************************************/

#include <owl.h>
#include "METERID.h"
#include "METER.h"

//REGEN_VARIABLES

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ddeml.h>
#include <dde.h>

const int MaxStringLength=128;
const int MaxPathLength=260;

//REGEN_VARIABLES

// Define application class derived from  TApplication
class TMeter : public TApplication
{
public:
  TMeter(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine, int nCmdShow)
    : TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
    virtual void InitMainWindow();
    virtual void InitInstance();
    //REGEN_APPCLASS
//	 virtual void Error(int ErrorCode){};
	 //REGEN_APPCLASS
};

void TMeter::InitInstance()
{
	if (hPrevInstance){
		HWND hWndPrev=FindWindow(Name, NULL);
		if (hWndPrev){
      	ShowWindow(hWndPrev, nCmdShow);
			Status=EM_INVALIDMAINWINDOW;
         return;
      }
   }
	TApplication::InitInstance();
	HAccTable = LoadAccelerators(hInstance, Name);
}
// Declare TMainWindow, a TWindow descendant
class TMainWindow : public TWindow
{
public:
   TMainWindow(PTWindowsObject AParent, LPSTR ATitle);
   ~TMainWindow();
   virtual void Install(RTMessage Msg) = [CM_FIRST + IDM_INSTALL];
   virtual void UnInstall(RTMessage Msg) = [CM_FIRST + IDM_UNINSTALL];
   virtual void Exit(RTMessage Msg) = [CM_FIRST + IDM_EXIT];
   virtual void Copy(RTMessage Msg) = [CM_FIRST + IDM_COPY];
   virtual void Index(RTMessage Msg) = [CM_FIRST + IDM_INDEX];
   virtual void TopicSearch(RTMessage Msg) = [CM_FIRST + IDM_TOPICSEARCH];
   virtual void UsingHelp(RTMessage Msg) = [CM_FIRST + IDM_USINGHELP];
   virtual void About(RTMessage Msg) = [CM_FIRST + IDM_ABOUT];
	//REGEN_MAINCLASS
	virtual void FormatTicks(DWORD dwTicks, char szBuffer[]);
	virtual void UpdateTitle(DWORD dwTicks);
	virtual void SaveWindowPos(void);
	virtual void LoadWindowPos(void);
	virtual int  ShowMessage(UINT uiID, UINT uiStyle);
 	virtual void SaveTotal(DWORD dwTime);
protected:
	virtual void SetupWindow(void);
	virtual void WMTimer(RTMessage Msg) = [WM_FIRST + WM_TIMER];
	virtual void WMQueryEndSession(RTMessage Msg);
	virtual void Paint(HDC PaintDC, PAINTSTRUCT _FAR & PaintInfo);
	virtual void WMDestroy(RTMessage Msg);
	static HDDEDATA CALLBACK DDECallback ( WORD wType, WORD wFmt, HCONV hConvX, HSZ hsz1,
                                HSZ hsz2, HDDEDATA hData, DWORD dwData1,
                                DWORD dwData2 );
	DWORD    idInst;            /*  Instance of app for DDEML       */
	HCONV    hConv;           /*Handle of established conversation*/
	HINSTANCE hInst;
	UINT uiTimer;
	DWORD dwTimeFrom;
	DWORD dwTotalOn;
	FARPROC lpDdeProc;      /*  DDE callback function           */
	//REGEN_MAINCLASS

protected:
	virtual void GetWindowClass(WNDCLASS _FAR & AWndClass);
   virtual LPSTR GetClassName();
};


/****************************************************
 * TMainWindow implementations: 
 ****************************************************/

// Define TMainWindow, a TWindow constructor
TMainWindow::TMainWindow(PTWindowsObject AParent, LPSTR ATitle)
								 : TWindow(AParent, ATitle)
{
   AssignMenu(GetClassName());
	//REGEN_MAINCONSTRUCT
	Attr.Style &= ~WS_MAXIMIZEBOX;
   UpdateTitle(0);
	LoadWindowPos();
	//REGEN_MAINCONSTRUCT

}

// Define TMainWindow destructor
TMainWindow::~TMainWindow()
{
   //REGEN_MAINDESTRUCT
   //REGEN_MAINDESTRUCT

}

LPSTR TMainWindow::GetClassName()
{
   return "Meter";
}

void TMainWindow::GetWindowClass(WNDCLASS _FAR & AWndClass)
{
   TWindow::GetWindowClass(AWndClass);
	AWndClass.hIcon = LoadIcon(AWndClass.hInstance, GetClassName());
   //REGEN_CLASSINFO
   //REGEN_CLASSINFO

}

void TMainWindow::Install(RTMessage)
{
	//REGEN_INSTALL_EXEC
	HSZ  hszService;
	HSZ  hszTopic;
	hszService = DdeCreateStringHandle ( idInst, "PROGMAN", CP_WINANSI );
   hszTopic = DdeCreateStringHandle ( idInst, "PROGMAN", CP_WINANSI );
	if (!hConv){
		hConv = DdeConnect (idInst, hszService, hszTopic,
      		(PCONVCONTEXT)NULL );
	}
	HDDEDATA       hData;
	char  szDDEString[MaxStringLength+2*MaxPathLength];
	LoadString(hInst, 8, (LPSTR)szDDEString, MaxStringLength);
	hData = DdeCreateDataHandle ( idInst, &szDDEString,
   		lstrlen(szDDEString)+1, 0L, NULL, CF_TEXT, 0 );
   if ( hData ){
		hData = DdeClientTransaction ( (LPBYTE)hData, -1, hConv,
				NULL, CF_TEXT, XTYP_EXECUTE, 2000, NULL);
	}
 	char szFileName[MaxPathLength];
 	if(GetModuleFileName(hInst, szFileName, MaxPathLength)){
		char szFormat[MaxStringLength];
	 	LoadString(hInst, 9, (LPSTR)szFormat, MaxStringLength);
	 	sprintf(szDDEString, szFormat, szFileName, szFileName);
		hData = DdeCreateDataHandle ( idInst, &szDDEString,
     	lstrlen(szDDEString)+1, 0L, NULL, CF_TEXT, 0 );
      if ( hData ){
      	hData = DdeClientTransaction ( (LPBYTE)hData, -1, hConv,
					NULL, CF_TEXT, XTYP_EXECUTE, 2000, NULL);
	 	}
	}
	DdeDisconnect(hConv);
	hConv = NULL;
	DdeFreeStringHandle ( idInst, hszTopic );
	DdeFreeStringHandle ( idInst, hszService );
	//REGEN_INSTALL_EXEC
}

void TMainWindow::UnInstall(RTMessage)
{
   //REGEN_UNINSTALL_EXEC
	if(IDYES==ShowMessage(3, MB_ICONSTOP | MB_YESNOCANCEL)){
		HSZ  hszService;
		HSZ  hszTopic;
		hszService = DdeCreateStringHandle ( idInst, "PROGMAN", CP_WINANSI );
      hszTopic = DdeCreateStringHandle ( idInst, "PROGMAN", CP_WINANSI );
 		if (!hConv){
			hConv = DdeConnect (idInst, hszService, hszTopic,
	      		(PCONVCONTEXT)NULL );
		}
		HDDEDATA       hData;
		char  szDDEString[MaxStringLength];
		LoadString(hInst, 8, (LPSTR)szDDEString, MaxStringLength);
		hData = DdeCreateDataHandle ( idInst, &szDDEString,
      lstrlen(szDDEString)+1, 0L, NULL, CF_TEXT, 0 );
      if ( hData ){
      	hData = DdeClientTransaction ( (LPBYTE)hData, -1, hConv,
					NULL, CF_TEXT, XTYP_EXECUTE, 2000, NULL);
	   }
		LoadString(hInst, 10, (LPSTR)szDDEString, MaxStringLength);
		hData = DdeCreateDataHandle ( idInst, &szDDEString,
      lstrlen(szDDEString)+1, 0L, NULL, CF_TEXT, 0 );
      if ( hData ){
      	hData = DdeClientTransaction ( (LPBYTE)hData, -1, hConv,
					NULL, CF_TEXT, XTYP_EXECUTE, 2000, NULL);
	   }
		DdeDisconnect(hConv);
      hConv = NULL;
		DdeFreeStringHandle ( idInst, hszTopic );
		DdeFreeStringHandle ( idInst, hszService );
		dwTimeFrom = GetTickCount();
      dwTotalOn=0;
		SaveTotal(0);  
		if (!IsIconic(HWindow)){
			InvalidateRect(HWindow, NULL, TRUE);
      }
	};
	//REGEN_UNINSTALL_EXEC
}

void TMainWindow::Exit(RTMessage)
{
   //REGEN_EXIT_EXEC
	PostMessage(TMainWindow::HWindow, WM_CLOSE, 0, 0L);
	//REGEN_EXIT_EXEC
}

void TMainWindow::Copy(RTMessage)
{
   //REGEN_COPY_EXEC
	char szText[MaxStringLength];
 	DWORD dwTimeNow = GetTickCount();
 	char szBuffer[MaxStringLength];
 	LoadString(hInst, 6, (LPSTR)szText, MaxStringLength);
	lstrcat(szText, ": ");
	FormatTicks(dwTimeNow-dwTimeFrom, szBuffer);
	lstrcat(szText, szBuffer);
	lstrcat(szText, "\n");
	LoadString(hInst, 2, (LPSTR)szBuffer, MaxStringLength);
	lstrcat(szText, szBuffer);
	lstrcat(szText, ": ");
	FormatTicks(dwTotalOn+dwTimeNow-dwTimeFrom, szBuffer);
	lstrcat(szText, szBuffer);
	lstrcat(szText, "\n");
	if(OpenClipboard(HWindow)){
   	HANDLE hText;
		EmptyClipboard();
      hText=GlobalAlloc(GHND, lstrlen(szText)+1);
		LPSTR lpText;
		lpText = (LPSTR) GlobalLock(hText);
      lstrcpy(lpText, (LPSTR)szText);
		GlobalUnlock(hText);
		SetClipboardData(CF_TEXT, hText);
      CloseClipboard();
   }
	//REGEN_COPY_EXEC
}

void TMainWindow::Index(RTMessage)
{
   //REGEN_INDEX_EXEC
	char szHelpFile[MaxStringLength];
	lstrcpy(szHelpFile, GetClassName());
   lstrcat(szHelpFile, ".HLP");
   WinHelp(HWindow, szHelpFile, HELP_INDEX, 0);
	//REGEN_INDEX_EXEC
}

void TMainWindow::TopicSearch(RTMessage)
{
   //REGEN_TOPICSEARCH_EXEC
   //REGEN_TOPICSEARCH_EXEC
}

void TMainWindow::UsingHelp(RTMessage)
{
   //REGEN_USINGHELP_EXEC
	char szHelpFile[MaxStringLength];
	lstrcpy(szHelpFile, GetClassName());
   lstrcat(szHelpFile, ".HLP");
   WinHelp(HWindow, szHelpFile, HELP_HELPONHELP, 0);
	//REGEN_USINGHELP_EXEC
}

void TMainWindow::About(RTMessage)
{
   //REGEN_ABOUT_EXEC
	ShowMessage(12, MB_OK);
	//REGEN_ABOUT_EXEC
}


/***************************************************
 * TMeterApp method implementations:
 ***************************************************/

// Construct the TMeter's MainWindow of type TMainWindow
void TMeter::InitMainWindow()
{
   MainWindow = new TMainWindow(NULL, Name);
   //REGEN_MAINCREATE
   //REGEN_MAINCREATE
}

// Main program
int PASCAL WinMain(HINSTANCE hInstance,
                   HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine,
                   int nCmdShow)
{
   //REGEN_INIT
	char szFileName[_MAX_FNAME];
	{
	char s[_MAX_PATH];
  	char drive[_MAX_DRIVE];
  	char dir[_MAX_DIR];
	char ext[_MAX_EXT];
	char szModuleName[260];
   // Query file name
   GetModuleFileName(hInstance, szModuleName, sizeof(szModuleName));
  	_splitpath(szModuleName,drive,dir,szFileName,ext);
  	}
	//REGEN_INIT

	TMeter Meter (szFileName, hInstance, hPrevInstance,
      lpCmdLine, nCmdShow);

	Meter.Run();

   //REGEN_CLEANUP
   //REGEN_CLEANUP

   return Meter.Status;
}

//REGEN_CUSTOMCODE
void
TMainWindow::WMTimer(RTMessage Msg)
{                  
	if (Msg.WParam==uiTimer){
		DWORD dwTimeNow=GetTickCount();
      UpdateTitle(dwTimeNow-dwTimeFrom);
		if (!IsIconic(HWindow)){
			InvalidateRect(HWindow, NULL, TRUE);
      }
	}
}

void
TMainWindow::WMQueryEndSession(RTMessage Msg)
{
	DWORD dwTimeNow = GetTickCount();
	SaveTotal(dwTotalOn+dwTimeNow-dwTimeFrom);
	TWindow::WMQueryEndSession(Msg);
}

void
TMainWindow::SetupWindow(void)
{
	TWindow::SetupWindow();
	idInst=0L;
	hConv=NULL;
	uiTimer=1;
	WNDCLASS _FAR AWndClass;
   GetWindowClass(AWndClass);
	hInst=AWndClass.hInstance;
	if (!SetTimer(HWindow, uiTimer, 7500, NULL)){
		ShowMessage(5, MB_ICONSTOP);
		Status=EM_INVALIDMAINWINDOW;
		return;
	}
	lpDdeProc = MakeProcInstance ( (FARPROC) DDECallback, hInst );
	if (DdeInitialize ( (LPDWORD)&idInst, (PFNCALLBACK)lpDdeProc,
			APPCMD_CLIENTONLY, 0L ) ){
		ShowMessage(7, MB_ICONSTOP);
		Status=EM_INVALIDMAINWINDOW;
		return;
	}
	dwTimeFrom = GetTickCount();
	char szIniFile[MaxStringLength];
	char szTotal[MaxStringLength];
	char szEntry[MaxStringLength];
	char szTime[MaxStringLength];
   lstrcpy(szIniFile, GetClassName());
	lstrcat(szIniFile,".INI");
	LoadString(hInst, 2, (LPSTR)szTotal, MaxStringLength);
	LoadString(hInst, 11, (LPSTR)szEntry, MaxStringLength);
	if (!GetPrivateProfileString(szTotal, szEntry,"0",
			szTime, MaxStringLength, szIniFile)){
   	ShowMessage(4, MB_ICONSTOP);
	}
	sscanf(szTime, "%lu", &dwTotalOn);
}

void
TMainWindow::WMDestroy(RTMessage Msg)
{
	KillTimer(HWindow, uiTimer);
	DWORD dwTimeNow = GetTickCount();
	SaveTotal(dwTotalOn+dwTimeNow-dwTimeFrom);
	DdeUninitialize ( idInst );
	FreeProcInstance(lpDdeProc);
   SaveWindowPos();
	char szHelpFile[MaxStringLength];
	lstrcpy(szHelpFile, GetClassName());
   lstrcat(szHelpFile, ".HLP");
	WinHelp(HWindow, szHelpFile, HELP_QUIT, 0);
	TWindow::WMDestroy(Msg);
}

#pragma argsused
void
TMainWindow::Paint(HDC PaintDC, PAINTSTRUCT _FAR & PaintInfo)
{
	char szText[MaxStringLength];
	RECT rect;
	GetClientRect(HWindow, &rect);
	RECT rectUpper=rect;
	rectUpper.bottom=rect.top+(rectUpper.bottom-rect.top)/2;
	DWORD dwTimeNow = GetTickCount();
	char szBuffer[MaxStringLength];
	LoadString(hInst, 6, (LPSTR)szText, MaxStringLength);
	lstrcat(szText, ": ");
	FormatTicks(dwTimeNow-dwTimeFrom, szBuffer);
   lstrcat(szText, szBuffer);
	DrawText(PaintDC, szText, lstrlen(szText), &rectUpper,
			DT_CENTER | DT_VCENTER | DT_SINGLELINE);
   RECT rectLower;
	SubtractRect(&rectLower, &rect, &rectUpper);
	LoadString(hInst, 2, (LPSTR)szText, MaxStringLength);
	lstrcat(szText, ": ");
	FormatTicks(dwTotalOn+dwTimeNow-dwTimeFrom, szBuffer);
         lstrcat(szText, szBuffer);
	DrawText(PaintDC, szText, lstrlen(szText), &rectLower,
			DT_CENTER | DT_VCENTER | DT_SINGLELINE);
}

void
TMainWindow::FormatTicks(DWORD dwTicks, char szBuffer[])
{
	sprintf(szBuffer, "%lu:%02lu", dwTicks/3600000L, dwTicks/60000L%60L);
}

void
TMainWindow::UpdateTitle(DWORD dwTicks)
{
	char szTitle[MaxStringLength];
	GetWindowText(this->HWindow, szTitle, MaxStringLength);
	lstrcpy(szTitle, GetClassName());
	lstrcat(szTitle," ");
	char szTime[MaxStringLength];
	FormatTicks(dwTicks, szTime);
	lstrcat(szTitle, szTime);
  	SetWindowText(this->HWindow, szTitle);
}

void
TMainWindow::SaveWindowPos(void)
{
	if (!IsIconic(this->HWindow)){
		char szIniFile[MaxStringLength];
		char szPosition[MaxStringLength];
		char szEntry[MaxStringLength];
		char szString[MaxStringLength];
		RECT rect;
		GetWindowRect(this->HWindow, &rect);
		lstrcpy(szIniFile, GetClassName());
		lstrcat(szIniFile, ".INI");
		LoadString(hInst, 13, (LPSTR)szPosition, MaxStringLength);
		LoadString(hInst, 14, (LPSTR)szEntry, MaxStringLength);
	   sprintf(szString,"%d", rect.left);
		WritePrivateProfileString(szPosition, szEntry, szString, szIniFile);
		LoadString(hInst, 15, (LPSTR)szEntry, MaxStringLength);
		sprintf(szString,"%d", rect.top);
		WritePrivateProfileString(szPosition, szEntry, szString, szIniFile);
		LoadString(hInst, 16, (LPSTR)szEntry, MaxStringLength);
		sprintf(szString,"%d", rect.right-rect.left);
		WritePrivateProfileString(szPosition, szEntry, szString, szIniFile);
		LoadString(hInst, 17, (LPSTR)szEntry, MaxStringLength);
		sprintf(szString,"%d", rect.bottom-rect.top);
		WritePrivateProfileString(szPosition, szEntry, szString, szIniFile);
   }
}

void
TMainWindow::LoadWindowPos(void)
{
	int right,top,left,bottom;
	char szIniFile[MaxStringLength];
	char szPosition[MaxStringLength];
	char szEntry[MaxStringLength];
	lstrcpy(szIniFile, GetClassName());
	lstrcat(szIniFile, ".INI");
	LoadString(hInst, 13, (LPSTR)szPosition, MaxStringLength);
	LoadString(hInst, 14, (LPSTR)szEntry, MaxStringLength);
	right=GetPrivateProfileInt(szPosition, szEntry, 0, szIniFile);
	LoadString(hInst, 15, (LPSTR)szEntry, MaxStringLength);
	top=GetPrivateProfileInt(szPosition, szEntry, 0, szIniFile);
	LoadString(hInst, 16, (LPSTR)szEntry, MaxStringLength);
	left=GetPrivateProfileInt(szPosition, szEntry, 0, szIniFile);
	LoadString(hInst, 17, (LPSTR)szEntry, MaxStringLength);
	bottom=GetPrivateProfileInt(szPosition, szEntry, 0, szIniFile);
	if(right*top*left*bottom){
		SetWindowPos(this->HWindow, NULL, right, top, left, bottom,
				SWP_NOZORDER | SWP_NOREDRAW | SWP_NOACTIVATE);
   }
}

int
TMainWindow::ShowMessage(UINT uiID, UINT uiStyle)
{
	char szMessage[MaxStringLength];
	char szTitle[MaxStringLength];
	LoadString(hInst, uiID, (LPSTR)szMessage, MaxStringLength);
	GetWindowText(this->HWindow, szTitle, MaxStringLength);
	return(MessageBox(this->HWindow, szMessage, szTitle, uiStyle));
}

void
TMainWindow::SaveTotal(DWORD dwTime)
{
	char szIniFile[MaxStringLength];
	char szTotal[MaxStringLength];
	char szEntry[MaxStringLength];
	char szTime[MaxStringLength];
	lstrcpy(szIniFile, GetClassName());
	lstrcat(szIniFile, ".INI");
	LoadString(hInst, 2, (LPSTR)szTotal, MaxStringLength);
	LoadString(hInst, 11, (LPSTR)szEntry, MaxStringLength);
	sprintf(szTime, "%lu", dwTime);
	if (!WritePrivateProfileString(szTotal, szEntry,
			dwTime?szTime:NULL, szIniFile)){
   	ShowMessage(4, MB_ICONSTOP);
	}
}

#pragma argsused
HDDEDATA CALLBACK
TMainWindow::DDECallback ( WORD wType, WORD wFmt, HCONV hConvX, HSZ hsz1,
                                HSZ hsz2, HDDEDATA hData, DWORD dwData1,
                                DWORD dwData2 )
{
	HDDEDATA rc=(HDDEDATA)NULL;

   switch ( wType )
   {
		case XTYP_DISCONNECT:
//			DdeDisconnect(hConvX);
			break;
      case XTYP_ERROR:
			DdeDisconnect(hConvX);
			break;
   }
	return rc;
}

//REGEN_CUSTOMCODE
