/*
**	Constants and Declarations for ImageKnife/VBX library
**
**	Copyright (c) 1993 by Media Architects, Inc.  ALL RIGHTS RESERVED
*/


#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif	/* __cplusplus */


/* ######  Typedefs  ###### */

typedef	PALETTEENTRY FAR *	LPPE;
typedef RGBQUAD      FAR *	LPQUAD;
typedef	HANDLE					HDIB;
typedef	HDIB         FAR *	LPHDIB;

/* ######  Constants  ###### */

#define	VBCOLOR	PALETTEENTRY

/* Image file formats */
enum  IMAGETYPE {
	IMK_EXTENSION,
	IMK_TIFF,
	IMK_TARGA,
	IMK_BITMAP,
	IMK_GIF,
	IMK_DIB,
	IMK_PCX,
	IMK_JPEG,
	IMK_OLEPBRUSH
};

/* Compression schemes */
enum  COMPRESS {
	IMK_UNCOMP,
	IMK_LZW,
	IMK_RLE,
	IMK_PACKBITS,
	IMK_OS2,
	IMK_PCXCOMP,
	IMK_CCIT3,
	IMK_CCIT4
};


/* ######  Function Pointer Declarations  ###### */
typedef void  (FAR PASCAL * IMKAPPENDTIFF)     (LPSTR filename, short hdib, int compression);
typedef short (FAR PASCAL * IMKBLUR)           (short hdib);
typedef short (FAR PASCAL * IMKBRIGHTCONT)     (short hdib, double bright_pct, double contrast_pct);
typedef short (FAR PASCAL * IMKCOLORREPLACE)   (short hdib, VBCOLOR rgb1, VBCOLOR rgb2, int flag, VBCOLOR newColor);
typedef int   (FAR PASCAL * IMKCOUNTIMAGES)    (LPSTR string, int format);
typedef short (FAR PASCAL * IMKDEREFPOINTER)   (LPHDIB pointer);
typedef short (FAR PASCAL * IMKDUPLICATE)      (short hdib);
typedef short (FAR PASCAL * IMKEXTRACTEDGES)   (short hdib, int magintude);
typedef short (FAR PASCAL * IMKFORCEPAL)       (short hdib, short hpal);
typedef short (FAR PASCAL * IMKGAMMA)          (short hdib, double magintude);
typedef long  (FAR PASCAL * IMKGETCOLOR)       (short hdib, int x, int y);
typedef long  (FAR PASCAL * IMKGETCOLORCOUNT)  (short hdib);
typedef long  (FAR PASCAL * IMKGETPALCOLOR)    (short hpal, int position);
typedef void  (FAR PASCAL * IMKGETPALETTE)     (short hdib, LPPE pal);
typedef void  (FAR PASCAL * IMKGETSCANLINE)    (short hdib, int lineNum, LPPE scanLine);
typedef short (FAR PASCAL * IMKGRAYSCALE)      (short hdib);
typedef short (FAR PASCAL * IMKINCREASECOLORS) (short hdib, int depth);
typedef short (FAR PASCAL * IMKINIT)           (int depth, int width, int height, VBCOLOR colorVal);
typedef short (FAR PASCAL * IMKLOAD)           (LPSTR string, int imageNo, int format);
typedef short (FAR PASCAL * IMKLOADPAL)        (LPSTR string, int imageNo, int format);
typedef short (FAR PASCAL * IMKMASKCOPY)       (HCTL hFrom, HCTL hTo, HCTL hMask);
typedef short (FAR PASCAL * IMKMATRIXFILTER)   (short hdib, int matrixSize, int FAR *matrix, int scale, int norm, int offset);
typedef short (FAR PASCAL * IMKMIRROR)         (short hdib, BOOL horiz, BOOL vert);
typedef short (FAR PASCAL * IMKNEGATE)         (short hdib);
typedef short (FAR PASCAL * IMKOPTIMIZEPAL)    (LPHDIB lphdib, int noImages, int colors);
typedef void  (FAR PASCAL * IMKPUTSCANLINE)    (short hdib, int lineNum, LPPE scanLine);
typedef short (FAR PASCAL * IMKREDUCECOLORS)   (short hdib, long colors, BOOL optimize, BOOL dither, BOOL noBleed);
typedef short (FAR PASCAL * IMKREMAPPAL)       (short hdib, short hpal);
typedef short (FAR PASCAL * IMKROTATE)         (short hdib, int radians, VBCOLOR backColor);
typedef short (FAR PASCAL * IMKSETPALCOLOR)    (short hpal, int position, long colorVal);
typedef short (FAR PASCAL * IMKSETPALETTE)     (int numColors, LPDWORD pal);
typedef void  (FAR PASCAL * IMKSETSCREENPAL)   (short hpal);
typedef short (FAR PASCAL * IMKSHARPEN)        (short hdib, int sharpness);
typedef short (FAR PASCAL * IMKSOFTEN)         (short hdib, int softness);
typedef void  (FAR PASCAL * IMKSTORE)          (LPSTR string, short hdib, int format, int compression);
typedef void  (FAR PASCAL * IMKSTOREPAL)       (LPSTR string, short hpal, int format);
typedef int   (FAR PASCAL * IMKTWIPSTOXCOORD)  (HCTL hctl, long twips);
typedef int   (FAR PASCAL * IMKTWIPSTOYCOORD)  (HCTL hctl, long twips);
typedef int   (FAR PASCAL * IMKVERIFY)         (short hdib);
typedef long  (FAR PASCAL * IMKXCOORDTOTWIPS)  (HCTL hctl, int XCoord);
typedef long  (FAR PASCAL * IMKYCOORDTOTWIPS)  (HCTL hctl, int YCoord);

#ifdef KNIFE_DATA	/* Only add globals when KNIFE_DATA is defined */

IMKAPPENDTIFF 		imkAppendTIFF;
IMKBLUR 			imkBlur;
IMKBRIGHTCONT		imkBrightCont;
IMKCOLORREPLACE 	imkColorReplace;
IMKCOUNTIMAGES		imkCountImages;
IMKDEREFPOINTER		imkDerefPointer;
IMKDUPLICATE		imkDuplicate;
IMKEXTRACTEDGES 	imkExtractEdges;
IMKFORCEPAL			imkForcePal;
IMKGAMMA			imkGamma;
IMKGETCOLOR			imkGetColor;
IMKGETCOLORCOUNT	imkGetColorCount;
IMKGETPALCOLOR		imkGetPalColor;
IMKGETPALETTE		imkGetPalette;
IMKGETSCANLINE		imkGetScanLine;
IMKGRAYSCALE		imkGrayScale;
IMKINCREASECOLORS	imkIncreaseColors;
IMKINIT				imkInit;
IMKLOAD				imkLoad;
IMKLOADPAL			imkLoadPal;
IMKMASKCOPY			imkMaskCopy;
IMKMATRIXFILTER		imkMatrixFilter;
IMKMIRROR			imkMirror;
IMKNEGATE			imkNegate;
IMKOPTIMIZEPAL		imkOptimizePal;
IMKPUTSCANLINE		imkPutScanLine;
IMKREDUCECOLORS		imkReduceColors;
IMKREMAPPAL			imkRemapPal;
IMKROTATE			imkRotate;
IMKSETPALCOLOR		imkSetPalColor;
IMKSETPALETTE		imkSetPalette;
IMKSETSCREENPAL		imkSetScreenPal;
IMKSHARPEN			imkSharpen;
IMKSOFTEN			imkSoften;
IMKSTORE			imkStore;
IMKSTOREPAL			imkStorePal;
IMKTWIPSTOXCOORD	imkTwipsToXCoord;
IMKTWIPSTOYCOORD	imkTwipsToYCoord;
IMKVERIFY			imkVerify;
IMKXCOORDTOTWIPS	imkXCoordToTwips;
IMKYCOORDTOTWIPS    imkYCoordToTwips;

HINSTANCE hKnifeLib;

BOOL imkBegin(void)
/*
**	Create references to KNIFE.VBX functions.
*/
{   
	
	if ((hKnifeLib = LoadLibrary("KNIFE.VBX")) < HINSTANCE_ERROR)
		return(FALSE);
		
	imkAppendTIFF     = (IMKAPPENDTIFF)			GetProcAddress(hKnifeLib, "imkAppendTIFF");
	imkBlur           = (IMKBLUR)				GetProcAddress(hKnifeLib, "imkBlur");
	imkBrightCont     = (IMKBRIGHTCONT)			GetProcAddress(hKnifeLib, "imkBrightCont");
	imkColorReplace   = (IMKCOLORREPLACE) 		GetProcAddress(hKnifeLib, "imkColorReplace");
	imkCountImages    = (IMKCOUNTIMAGES)		GetProcAddress(hKnifeLib, "imkCountImages");
	imkDerefPointer   = (IMKDEREFPOINTER)		GetProcAddress(hKnifeLib, "imkDerefPointer");
	imkDuplicate      = (IMKDUPLICATE)			GetProcAddress(hKnifeLib, "imkDuplicate");
	imkExtractEdges   = (IMKEXTRACTEDGES)		GetProcAddress(hKnifeLib, "imkExtractEdges");
	imkForcePal       = (IMKFORCEPAL)			GetProcAddress(hKnifeLib, "imkForcePal");						
	imkGamma          = (IMKGAMMA)				GetProcAddress(hKnifeLib, "imkGamma");					
	imkGetColor       = (IMKGETCOLOR)			GetProcAddress(hKnifeLib, "imkGetColor");						
	imkGetColorCount  = (IMKGETCOLORCOUNT)		GetProcAddress(hKnifeLib, "imkGetColorCount");					
	imkGetPalColor    = (IMKGETPALCOLOR)		GetProcAddress(hKnifeLib, "imkGetPalColor");						
	imkGetPalette     = (IMKGETPALETTE)			GetProcAddress(hKnifeLib, "imkGetPalette");						
	imkGetScanLine    = (IMKGETSCANLINE)		GetProcAddress(hKnifeLib, "imkGetScanLine");						
	imkGrayScale      = (IMKGRAYSCALE)			GetProcAddress(hKnifeLib, "imkGrayScale");						
	imkIncreaseColors = (IMKINCREASECOLORS)		GetProcAddress(hKnifeLib, "imkIncreaseColor");				
	imkInit           = (IMKINIT)				GetProcAddress(hKnifeLib, "imkInit");						
	imkLoad           = (IMKLOAD)				GetProcAddress(hKnifeLib, "imkLoad");						
	imkLoadPal        = (IMKLOADPAL)			GetProcAddress(hKnifeLib, "imkLoadPal");						
	imkMaskCopy       = (IMKMASKCOPY)			GetProcAddress(hKnifeLib, "imkMaskCopy");						
	imkMatrixFilter   = (IMKMATRIXFILTER)		GetProcAddress(hKnifeLib, "imkMatrixFilter");					
	imkMirror         = (IMKMIRROR)				GetProcAddress(hKnifeLib, "imkMirror");					
	imkNegate         = (IMKNEGATE)				GetProcAddress(hKnifeLib, "imkNegate");					
	imkOptimizePal    = (IMKOPTIMIZEPAL)		GetProcAddress(hKnifeLib, "imkOptimizePal");						
	imkPutScanLine    = (IMKPUTSCANLINE)		GetProcAddress(hKnifeLib, "imkPutScanLine");						
	imkReduceColors   = (IMKREDUCECOLORS)		GetProcAddress(hKnifeLib, "imkReduceColors");					
	imkRemapPal       = (IMKREMAPPAL)			GetProcAddress(hKnifeLib, "imkRemapPal");						
	imkRotate         = (IMKROTATE)				GetProcAddress(hKnifeLib, "imkRotate");					
	imkSetPalColor    = (IMKSETPALCOLOR)		GetProcAddress(hKnifeLib, "imkSetPalColor");						
	imkSetPalette     = (IMKSETPALETTE)			GetProcAddress(hKnifeLib, "imkSetPalette");						
	imkSetScreenPal   = (IMKSETSCREENPAL)		GetProcAddress(hKnifeLib, "imkSetScreenPal");					
	imkSharpen        = (IMKSHARPEN)			GetProcAddress(hKnifeLib, "imkSharpen");						
	imkSoften         = (IMKSOFTEN)				GetProcAddress(hKnifeLib, "imkSoften");					
	imkStore          = (IMKSTORE)				GetProcAddress(hKnifeLib, "imkStore");					
	imkStorePal       = (IMKSTOREPAL)			GetProcAddress(hKnifeLib, "imkStorePal");						
	imkTwipsToXCoord  = (IMKTWIPSTOXCOORD)		GetProcAddress(hKnifeLib, "imkTwipsToXCoord");					
	imkTwipsToYCoord  = (IMKTWIPSTOYCOORD)		GetProcAddress(hKnifeLib, "imkTwipsToYCoord");					
	imkVerify         = (IMKVERIFY)				GetProcAddress(hKnifeLib, "imkVerify");					
	imkXCoordToTwips  = (IMKXCOORDTOTWIPS)		GetProcAddress(hKnifeLib, "imkXCoordToTwips");					
	imkYCoordToTwips  = (IMKYCOORDTOTWIPS)		GetProcAddress(hKnifeLib, "imkYCoordToTwips");					
		
	return(TRUE);

}
	
void imkEnd(void)
/*
**	Remove references to KNIFE.VBX functions.
*/
{
	FreeLibrary(hKnifeLib);
}

#endif  /* KNIFE_DATA */


/* ######  Function Prototypes  ###### */
extern	IMKAPPENDTIFF 		imkAppendTIFF;
extern	IMKBLUR 			imkBlur;
extern	IMKBRIGHTCONT		imkBrightCont;
extern	IMKCOLORREPLACE 	imkColorReplace;
extern	IMKCOUNTIMAGES		imkCountImages;
extern	IMKDEREFPOINTER		imkDerefPointer;
extern	IMKDUPLICATE		imkDuplicate;
extern	IMKEXTRACTEDGES 	imkExtractEdges;
extern	IMKFORCEPAL			imkForcePal;
extern	IMKGAMMA			imkGamma;
extern	IMKGETCOLOR			imkGetColor;
extern	IMKGETCOLORCOUNT	imkGetColorCount;
extern	IMKGETPALCOLOR		imkGetPalColor;
extern	IMKGETPALETTE		imkGetPalette;
extern	IMKGETSCANLINE		imkGetScanLine;
extern	IMKGRAYSCALE		imkGrayScale;
extern	IMKINCREASECOLORS	imkIncreaseColors;
extern	IMKINIT				imkInit;
extern	IMKLOAD				imkLoad;
extern	IMKLOADPAL			imkLoadPal;
extern	IMKMASKCOPY			imkMaskCopy;
extern	IMKMATRIXFILTER		imkMatrixFilter;
extern	IMKMIRROR			imkMirror;
extern	IMKNEGATE			imkNegate;
extern	IMKOPTIMIZEPAL		imkOptimizePal;
extern	IMKPUTSCANLINE		imkPutScanLine;
extern	IMKREDUCECOLORS		imkReduceColors;
extern	IMKREMAPPAL			imkRemapPal;
extern	IMKROTATE			imkRotate;
extern	IMKSETPALCOLOR		imkSetPalColor;
extern	IMKSETPALETTE		imkSetPalette;
extern	IMKSETSCREENPAL		imkSetScreenPal;
extern	IMKSHARPEN			imkSharpen;
extern	IMKSOFTEN			imkSoften;
extern	IMKSTORE			imkStore;
extern	IMKSTOREPAL			imkStorePal;
extern	IMKTWIPSTOXCOORD	imkTwipsToXCoord;
extern	IMKTWIPSTOYCOORD	imkTwipsToYCoord;
extern	IMKVERIFY			imkVerify;
extern	IMKXCOORDTOTWIPS	imkXCoordToTwips;
extern	IMKYCOORDTOTWIPS    imkYCoordToTwips;

BOOL imkBegin(void);
void imkEnd(void);

#ifdef __cplusplus
}                       /* End of extern "C" { */
#endif	/* __cplusplus */

